/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.InetSocketAddress;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public abstract class AbstractCustomCommandLine<T>
implements CustomCommandLine<T> {
    protected final Option zookeeperNamespaceOption = new Option("z", "zookeeperNamespace", true, "Namespace to create the Zookeeper sub-paths for high availability mode");
    protected final Option addressOption = new Option("m", "jobmanager", true, "Address of the JobManager (master) to which to connect. Use this flag to connect to a different JobManager than the one specified in the configuration.");
    protected final Configuration configuration;

    protected AbstractCustomCommandLine(Configuration configuration) {
        this.configuration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void addRunOptions(Options baseOptions) {
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        baseOptions.addOption(this.addressOption);
        baseOptions.addOption(this.zookeeperNamespaceOption);
    }

    protected Configuration applyCommandLineOptionsToConfiguration(CommandLine commandLine) throws FlinkException {
        Configuration resultingConfiguration = new Configuration(this.configuration);
        if (commandLine.hasOption(this.addressOption.getOpt())) {
            String addressWithPort = commandLine.getOptionValue(this.addressOption.getOpt());
            InetSocketAddress jobManagerAddress = ClientUtils.parseHostPortAddress(addressWithPort);
            CliFrontend.setJobManagerAddressInConfig(resultingConfiguration, jobManagerAddress);
        }
        if (commandLine.hasOption(this.zookeeperNamespaceOption.getOpt())) {
            String zkNamespace = commandLine.getOptionValue(this.zookeeperNamespaceOption.getOpt());
            resultingConfiguration.setString(HighAvailabilityOptions.HA_CLUSTER_ID, zkNamespace);
        }
        return resultingConfiguration;
    }
}

