/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.annotation.Internal;

@Internal
public class ClosableBlockingQueue<E> {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition nonEmpty = this.lock.newCondition();
    private final ArrayDeque<E> elements;
    private volatile boolean open;

    public ClosableBlockingQueue() {
        this(10);
    }

    public ClosableBlockingQueue(int initialSize) {
        this.elements = new ArrayDeque(initialSize);
        this.open = true;
    }

    public ClosableBlockingQueue(Collection<? extends E> initialElements) {
        this(initialElements.size());
        this.elements.addAll(initialElements);
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.elements.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean close() {
        this.lock.lock();
        try {
            if (this.open) {
                if (this.elements.isEmpty()) {
                    this.open = false;
                    this.nonEmpty.signalAll();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean addIfOpen(E element) {
        Objects.requireNonNull(element);
        this.lock.lock();
        try {
            if (this.open) {
                this.elements.addLast(element);
                if (this.elements.size() == 1) {
                    this.nonEmpty.signalAll();
                }
            }
            boolean bl = this.open;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(E element) throws IllegalStateException {
        block5: {
            Objects.requireNonNull(element);
            this.lock.lock();
            try {
                if (this.open) {
                    this.elements.addLast(element);
                    if (this.elements.size() == 1) {
                        this.nonEmpty.signalAll();
                    }
                    break block5;
                }
                throw new IllegalStateException("queue is closed");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public E peek() {
        this.lock.lock();
        try {
            if (this.open) {
                if (this.elements.size() > 0) {
                    E e = this.elements.getFirst();
                    return e;
                }
                E e = null;
                return e;
            }
            throw new IllegalStateException("queue is closed");
        }
        finally {
            this.lock.unlock();
        }
    }

    public E poll() {
        this.lock.lock();
        try {
            if (this.open) {
                if (this.elements.size() > 0) {
                    E e = this.elements.removeFirst();
                    return e;
                }
                E e = null;
                return e;
            }
            throw new IllegalStateException("queue is closed");
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<E> pollBatch() {
        this.lock.lock();
        try {
            if (this.open) {
                if (this.elements.size() > 0) {
                    ArrayList<E> result = new ArrayList<E>(this.elements);
                    this.elements.clear();
                    ArrayList<E> arrayList = result;
                    return arrayList;
                }
                List<E> list = null;
                return list;
            }
            throw new IllegalStateException("queue is closed");
        }
        finally {
            this.lock.unlock();
        }
    }

    public E getElementBlocking() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.open && this.elements.isEmpty()) {
                this.nonEmpty.await();
            }
            if (this.open) {
                E e = this.elements.removeFirst();
                return e;
            }
            throw new IllegalStateException("queue is closed");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getElementBlocking(long timeoutMillis) throws InterruptedException {
        if (timeoutMillis == 0L) {
            return this.getElementBlocking();
        }
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("invalid timeout");
        }
        long deadline = System.nanoTime() + timeoutMillis * 1000000L;
        this.lock.lock();
        try {
            while (this.open && this.elements.isEmpty() && timeoutMillis > 0L) {
                this.nonEmpty.await(timeoutMillis, TimeUnit.MILLISECONDS);
                timeoutMillis = (deadline - System.nanoTime()) / 1000000L;
            }
            if (!this.open) {
                throw new IllegalStateException("queue is closed");
            }
            if (this.elements.isEmpty()) {
                E e = null;
                return e;
            }
            E e = this.elements.removeFirst();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<E> getBatchBlocking() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.open && this.elements.isEmpty()) {
                this.nonEmpty.await();
            }
            if (this.open) {
                ArrayList<E> result = new ArrayList<E>(this.elements);
                this.elements.clear();
                ArrayList<E> arrayList = result;
                return arrayList;
            }
            throw new IllegalStateException("queue is closed");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> getBatchBlocking(long timeoutMillis) throws InterruptedException {
        if (timeoutMillis == 0L) {
            return this.getBatchBlocking();
        }
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("invalid timeout");
        }
        long deadline = System.nanoTime() + timeoutMillis * 1000000L;
        this.lock.lock();
        try {
            while (this.open && this.elements.isEmpty() && timeoutMillis > 0L) {
                this.nonEmpty.await(timeoutMillis, TimeUnit.MILLISECONDS);
                timeoutMillis = (deadline - System.nanoTime()) / 1000000L;
            }
            if (!this.open) {
                throw new IllegalStateException("queue is closed");
            }
            if (this.elements.isEmpty()) {
                List list = Collections.emptyList();
                return list;
            }
            ArrayList<E> result = new ArrayList<E>(this.elements);
            this.elements.clear();
            ArrayList<E> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int hashCode() {
        int hashCode = 17;
        for (E element : this.elements) {
            hashCode = 31 * hashCode + element.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ClosableBlockingQueue.class) {
            ClosableBlockingQueue that = (ClosableBlockingQueue)obj;
            if (this.elements.size() == that.elements.size()) {
                Iterator<E> thisElements = this.elements.iterator();
                for (E thatNext : that.elements) {
                    E thisNext = thisElements.next();
                    if (thisNext != null ? thisNext.equals(thatNext) : thatNext == null) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.elements.toString();
    }
}

