/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;

public final class TypeSerializerUtils {
    public static TypeSerializerSnapshot<?>[] snapshotBackwardsCompatible(TypeSerializer<?> ... originatingSerializers) {
        return (TypeSerializerSnapshot[])Arrays.stream(originatingSerializers).map(s -> TypeSerializerUtils.configureForBackwardsCompatibility(s.snapshotConfiguration(), s)).toArray(TypeSerializerSnapshot[]::new);
    }

    private static <T> TypeSerializerSnapshot<T> configureForBackwardsCompatibility(TypeSerializerSnapshot<?> snapshot, TypeSerializer<?> serializer) {
        TypeSerializerSnapshot<?> typedSnapshot = snapshot;
        TypeSerializer<?> typedSerializer = serializer;
        if (snapshot instanceof TypeSerializerConfigSnapshot) {
            ((TypeSerializerConfigSnapshot)typedSnapshot).setPriorSerializer(typedSerializer);
        }
        return typedSnapshot;
    }

    private TypeSerializerUtils() {
    }
}

