/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.BigIntSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class BigDecSerializer
extends TypeSerializerSingleton<BigDecimal> {
    private static final long serialVersionUID = 1L;
    public static final BigDecSerializer INSTANCE = new BigDecSerializer();

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public BigDecimal createInstance() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal copy(BigDecimal from) {
        return from;
    }

    @Override
    public BigDecimal copy(BigDecimal from, BigDecimal reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BigDecimal record, DataOutputView target) throws IOException {
        if (record == null) {
            BigIntSerializer.writeBigInteger(null, target);
            return;
        }
        if (record == BigDecimal.ZERO) {
            BigIntSerializer.writeBigInteger(BigInteger.ZERO, target);
            target.writeInt(0);
            return;
        }
        if (record == BigDecimal.ONE) {
            BigIntSerializer.writeBigInteger(BigInteger.ONE, target);
            target.writeInt(0);
            return;
        }
        if (record == BigDecimal.TEN) {
            BigIntSerializer.writeBigInteger(BigInteger.TEN, target);
            target.writeInt(0);
            return;
        }
        BigIntSerializer.writeBigInteger(record.unscaledValue(), target);
        target.writeInt(record.scale());
    }

    @Override
    public BigDecimal deserialize(DataInputView source) throws IOException {
        return BigDecSerializer.readBigDecimal(source);
    }

    @Override
    public BigDecimal deserialize(BigDecimal reuse, DataInputView source) throws IOException {
        return BigDecSerializer.readBigDecimal(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        boolean isNull = BigIntSerializer.copyBigInteger(source, target);
        if (!isNull) {
            int scale = source.readInt();
            target.writeInt(scale);
        }
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BigDecSerializer;
    }

    public static BigDecimal readBigDecimal(DataInputView source) throws IOException {
        BigInteger unscaledValue = BigIntSerializer.readBigInteger(source);
        if (unscaledValue == null) {
            return null;
        }
        int scale = source.readInt();
        if (scale == 0) {
            if (unscaledValue == BigInteger.ZERO) {
                return BigDecimal.ZERO;
            }
            if (unscaledValue == BigInteger.ONE) {
                return BigDecimal.ONE;
            }
            if (unscaledValue == BigInteger.TEN) {
                return BigDecimal.TEN;
            }
        }
        return new BigDecimal(unscaledValue, scale);
    }

    @Override
    public TypeSerializerSnapshot<BigDecimal> snapshotConfiguration() {
        return new BigDecSerializerSnapshot();
    }

    public static final class BigDecSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<BigDecimal> {
        public BigDecSerializerSnapshot() {
            super(BigDecSerializer.class);
        }
    }
}

