/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.BooleanValue;

@Internal
public final class BooleanValueSerializer
extends TypeSerializerSingleton<BooleanValue> {
    private static final long serialVersionUID = 1L;
    public static final BooleanValueSerializer INSTANCE = new BooleanValueSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public BooleanValue createInstance() {
        return new BooleanValue();
    }

    @Override
    public BooleanValue copy(BooleanValue from) {
        BooleanValue result = new BooleanValue();
        result.setValue(from.getValue());
        return result;
    }

    @Override
    public BooleanValue copy(BooleanValue from, BooleanValue reuse) {
        reuse.setValue(from.getValue());
        return reuse;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void serialize(BooleanValue record, DataOutputView target) throws IOException {
        record.write(target);
    }

    @Override
    public BooleanValue deserialize(DataInputView source) throws IOException {
        return this.deserialize(new BooleanValue(), source);
    }

    @Override
    public BooleanValue deserialize(BooleanValue reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeBoolean(source.readBoolean());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BooleanValueSerializer;
    }

    @Override
    public TypeSerializerSnapshot<BooleanValue> snapshotConfiguration() {
        return new BooleanValueSerializerSnapshot();
    }

    public static final class BooleanValueSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<BooleanValue> {
        public BooleanValueSerializerSnapshot() {
            super(BooleanValueSerializer.class);
        }
    }
}

