/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class FloatSerializer
extends TypeSerializerSingleton<Float> {
    private static final long serialVersionUID = 1L;
    public static final FloatSerializer INSTANCE = new FloatSerializer();
    private static final Float ZERO = Float.valueOf(0.0f);

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Float createInstance() {
        return ZERO;
    }

    @Override
    public Float copy(Float from) {
        return from;
    }

    @Override
    public Float copy(Float from, Float reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(Float record, DataOutputView target) throws IOException {
        target.writeFloat(record.floatValue());
    }

    @Override
    public Float deserialize(DataInputView source) throws IOException {
        return Float.valueOf(source.readFloat());
    }

    @Override
    public Float deserialize(Float reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeFloat(source.readFloat());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof FloatSerializer;
    }

    @Override
    public TypeSerializerSnapshot<Float> snapshotConfiguration() {
        return new FloatSerializerSnapshot();
    }

    public static final class FloatSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Float> {
        public FloatSerializerSnapshot() {
            super(FloatSerializer.class);
        }
    }
}

