/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ConfigOption<T> {
    private static final String[] EMPTY = new String[0];
    private final String key;
    private final String[] deprecatedKeys;
    private final T defaultValue;
    private final Description description;

    ConfigOption(String key, T defaultValue) {
        this.key = Preconditions.checkNotNull(key);
        this.description = Description.builder().text("").build();
        this.defaultValue = defaultValue;
        this.deprecatedKeys = EMPTY;
    }

    @Deprecated
    ConfigOption(String key, String description, T defaultValue, String ... deprecatedKeys) {
        this.key = Preconditions.checkNotNull(key);
        this.description = Description.builder().text(description).build();
        this.defaultValue = defaultValue;
        this.deprecatedKeys = deprecatedKeys == null || deprecatedKeys.length == 0 ? EMPTY : deprecatedKeys;
    }

    ConfigOption(String key, Description description, T defaultValue, String ... deprecatedKeys) {
        this.key = Preconditions.checkNotNull(key);
        this.description = description;
        this.defaultValue = defaultValue;
        this.deprecatedKeys = deprecatedKeys == null || deprecatedKeys.length == 0 ? EMPTY : deprecatedKeys;
    }

    public ConfigOption<T> withDeprecatedKeys(String ... deprecatedKeys) {
        return new ConfigOption<T>(this.key, this.description, this.defaultValue, deprecatedKeys);
    }

    public ConfigOption<T> withDescription(String description) {
        return this.withDescription(Description.builder().text(description).build());
    }

    public ConfigOption<T> withDescription(Description description) {
        return new ConfigOption<T>(this.key, description, this.defaultValue, this.deprecatedKeys);
    }

    public String key() {
        return this.key;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public boolean hasDeprecatedKeys() {
        return this.deprecatedKeys != EMPTY;
    }

    public Iterable<String> deprecatedKeys() {
        return this.deprecatedKeys == EMPTY ? Collections.emptyList() : Arrays.asList(this.deprecatedKeys);
    }

    public Description description() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == ConfigOption.class) {
            ConfigOption that = (ConfigOption)o;
            return this.key.equals(that.key) && Arrays.equals(this.deprecatedKeys, that.deprecatedKeys) && (this.defaultValue == null ? that.defaultValue == null : that.defaultValue != null && this.defaultValue.equals(that.defaultValue));
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.key.hashCode() + 17 * Arrays.hashCode(this.deprecatedKeys) + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
    }

    public String toString() {
        return String.format("Key: '%s' , default: %s (deprecated keys: %s)", this.key, this.defaultValue, Arrays.toString(this.deprecatedKeys));
    }
}

