/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.WebOptions;

@Internal
public class RestOptions {
    public static final ConfigOption<String> BIND_ADDRESS = ConfigOptions.key("rest.bind-address").noDefaultValue().withDeprecatedKeys(WebOptions.ADDRESS.key(), ConfigConstants.DEFAULT_JOB_MANAGER_WEB_FRONTEND_ADDRESS.key()).withDescription("The address that the server binds itself.");
    public static final ConfigOption<String> ADDRESS = ConfigOptions.key("rest.address").noDefaultValue().withDeprecatedKeys(JobManagerOptions.ADDRESS.key()).withDescription("The address that should be used by clients to connect to the server.");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key("rest.port").defaultValue(8081).withDeprecatedKeys("web.port").withDescription("The port that the server listens on / the client connects to.");
    public static final ConfigOption<Long> AWAIT_LEADER_TIMEOUT = ConfigOptions.key("rest.await-leader-timeout").defaultValue(30000L).withDescription("The time in ms that the client waits for the leader address, e.g., Dispatcher or WebMonitorEndpoint");
    public static final ConfigOption<Integer> RETRY_MAX_ATTEMPTS = ConfigOptions.key("rest.retry.max-attempts").defaultValue(20).withDescription("The number of retries the client will attempt if a retryable operations fails.");
    public static final ConfigOption<Long> RETRY_DELAY = ConfigOptions.key("rest.retry.delay").defaultValue(3000L).withDescription(String.format("The time in ms that the client waits between retries (See also `%s`).", RETRY_MAX_ATTEMPTS.key()));
    public static final ConfigOption<Long> CONNECTION_TIMEOUT = ConfigOptions.key("rest.connection-timeout").defaultValue(15000L).withDescription("The maximum time in ms for the client to establish a TCP connection.");
    public static final ConfigOption<Long> IDLENESS_TIMEOUT = ConfigOptions.key("rest.idleness-timeout").defaultValue(300000L).withDescription("The maximum time in ms for a connection to stay idle before failing.");
    public static final ConfigOption<Integer> SERVER_MAX_CONTENT_LENGTH = ConfigOptions.key("rest.server.max-content-length").defaultValue(0x6400000).withDescription("The maximum content length in bytes that the server will handle.");
    public static final ConfigOption<Integer> CLIENT_MAX_CONTENT_LENGTH = ConfigOptions.key("rest.client.max-content-length").defaultValue(0x6400000).withDescription("The maximum content length in bytes that the client will handle.");
    public static final ConfigOption<Integer> SERVER_NUM_THREADS = ConfigOptions.key("rest.server.numThreads").defaultValue(4).withDescription("The number of threads for the asynchronous processing of requests.");
    public static final ConfigOption<Integer> SERVER_THREAD_PRIORITY = ConfigOptions.key("rest.server.thread-priority").defaultValue(5).withDescription("Thread priority of the REST server's executor for processing asynchronous requests. Lowering the thread priority will give Flink's main components more CPU time whereas increasing will allocate more time for the REST server's processing.");
}

