/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.local.LocalRecoverable;
import org.apache.flink.core.io.SimpleVersionedSerializer;

@Internal
class LocalRecoverableSerializer
implements SimpleVersionedSerializer<LocalRecoverable> {
    static final LocalRecoverableSerializer INSTANCE = new LocalRecoverableSerializer();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final int MAGIC_NUMBER = 510937943;

    private LocalRecoverableSerializer() {
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public byte[] serialize(LocalRecoverable obj) throws IOException {
        byte[] targetFileBytes = obj.targetFile().getAbsolutePath().getBytes(CHARSET);
        byte[] tempFileBytes = obj.tempFile().getAbsolutePath().getBytes(CHARSET);
        byte[] targetBytes = new byte[20 + targetFileBytes.length + tempFileBytes.length];
        ByteBuffer bb = ByteBuffer.wrap(targetBytes).order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(510937943);
        bb.putLong(obj.offset());
        bb.putInt(targetFileBytes.length);
        bb.putInt(tempFileBytes.length);
        bb.put(targetFileBytes);
        bb.put(tempFileBytes);
        return targetBytes;
    }

    @Override
    public LocalRecoverable deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: {
                return LocalRecoverableSerializer.deserializeV1(serialized);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private static LocalRecoverable deserializeV1(byte[] serialized) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(serialized).order(ByteOrder.LITTLE_ENDIAN);
        if (bb.getInt() != 510937943) {
            throw new IOException("Corrupt data: Unexpected magic number.");
        }
        long offset = bb.getLong();
        byte[] targetFileBytes = new byte[bb.getInt()];
        byte[] tempFileBytes = new byte[bb.getInt()];
        bb.get(targetFileBytes);
        bb.get(tempFileBytes);
        String targetPath = new String(targetFileBytes, CHARSET);
        String tempPath = new String(tempFileBytes, CHARSET);
        return new LocalRecoverable(new File(targetPath), new File(tempPath), offset);
    }
}

