/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SerializableOptional<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -3312769593551775940L;
    private static final SerializableOptional<?> EMPTY = new SerializableOptional<Object>(null);
    @Nullable
    private final T value;

    private SerializableOptional(@Nullable T value) {
        this.value = value;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public <R> Optional<R> map(Function<? super T, ? extends R> mapper) {
        if (this.value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value));
    }

    public static <T extends Serializable> SerializableOptional<T> of(@Nonnull T value) {
        return new SerializableOptional<T>(value);
    }

    public static <T extends Serializable> SerializableOptional<T> ofNullable(@Nullable T value) {
        if (value == null) {
            return SerializableOptional.empty();
        }
        return SerializableOptional.of(value);
    }

    public static <T extends Serializable> SerializableOptional<T> empty() {
        return EMPTY;
    }
}

