/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public interface CloseableIterator<T>
extends Iterator<T>,
AutoCloseable {
    public static final CloseableIterator<?> EMPTY_INSTANCE = CloseableIterator.adapterForIterator(Collections.emptyIterator());

    @Nonnull
    public static <T> CloseableIterator<T> adapterForIterator(@Nonnull Iterator<T> iterator) {
        return new IteratorAdapter<T>(iterator);
    }

    public static <T> CloseableIterator<T> empty() {
        return EMPTY_INSTANCE;
    }

    public static final class IteratorAdapter<E>
    implements CloseableIterator<E> {
        @Nonnull
        private final Iterator<E> delegate;

        IteratorAdapter(@Nonnull Iterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.delegate.forEachRemaining(action);
        }

        @Override
        public void close() {
        }
    }
}

