/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

public final class LambdaUtil {
    private LambdaUtil() {
        throw new AssertionError();
    }

    public static <T> void applyToAllWhileSuppressingExceptions(Iterable<T> inputs, ThrowingConsumer<T, ? extends Exception> throwingConsumer) throws Exception {
        if (inputs != null && throwingConsumer != null) {
            Exception exception = null;
            for (T input : inputs) {
                if (input == null) continue;
                try {
                    throwingConsumer.accept(input);
                }
                catch (Exception ex) {
                    exception = ExceptionUtils.firstOrSuppressed(ex, exception);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> void withContextClassLoader(ClassLoader cl, ThrowingRunnable<E> r) throws E {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(cl);
            r.run();
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, E extends Throwable> R withContextClassLoader(ClassLoader cl, SupplierWithException<R, E> s) throws E {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(cl);
            R r = s.get();
            return r;
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }
}

