/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.util.SerializableObject;

public class ResourceGuard
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SerializableObject lock = new SerializableObject();
    private volatile int leaseCount = 0;
    private volatile boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease acquireResource() throws IOException {
        SerializableObject serializableObject = this.lock;
        synchronized (serializableObject) {
            if (this.closed) {
                throw new IOException("Resource guard was already closed.");
            }
            ++this.leaseCount;
        }
        return new Lease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResource() {
        SerializableObject serializableObject = this.lock;
        synchronized (serializableObject) {
            --this.leaseCount;
            if (this.closed && this.leaseCount == 0) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SerializableObject serializableObject = this.lock;
        synchronized (serializableObject) {
            this.closed = true;
            while (this.leaseCount > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getLeaseCount() {
        return this.leaseCount;
    }

    public class Lease
    implements AutoCloseable {
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private Lease() {
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                ResourceGuard.this.releaseResource();
            }
        }
    }
}

