/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.rest.util;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;

/**
 * This class contains utilities for mapping requests and responses to/from JSON.
 */
public class RestMapperUtils {
	private static final ObjectMapper objectMapper;

	static {
		objectMapper = new ObjectMapper();
		objectMapper.enable(
			DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES,
			DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES,
			DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
		objectMapper.disable(
			SerializationFeature.FAIL_ON_EMPTY_BEANS);
	}

	/**
	 * Returns a preconfigured {@link ObjectMapper}.
	 *
	 * @return preconfigured object mapper
	 */
	public static ObjectMapper getStrictObjectMapper() {
		return objectMapper;
	}
}
