/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.snapshot;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;

@InterfaceAudience.Private
public class SnapshotDiff {
    private static String getSnapshotName(String name) {
        int i;
        if (".".equals(name)) {
            return "";
        }
        if (name.startsWith(".snapshot/")) {
            i = 0;
        } else if (name.startsWith("/.snapshot/")) {
            i = 1;
        } else {
            return name;
        }
        return name.substring(i + ".snapshot".length() + 1);
    }

    public static void main(String[] argv) throws IOException {
        Configuration conf;
        FileSystem fs;
        String description = "SnapshotDiff <snapshotDir> <from> <to>:\n\tGet the difference between two snapshots, \n\tor between a snapshot and the current tree of a directory.\n\tFor <from>/<to>, users can use \".\" to present the current status,\n\tand use \".snapshot/snapshot_name\" to present a snapshot,\n\twhere \".snapshot/\" can be omitted\n";
        if (argv.length != 3) {
            System.err.println("Usage: \n" + description);
            System.exit(1);
        }
        if (!((fs = FileSystem.get((Configuration)(conf = new Configuration()))) instanceof DistributedFileSystem)) {
            System.err.println("SnapshotDiff can only be used in DistributedFileSystem");
            System.exit(1);
        }
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        Path snapshotRoot = new Path(argv[0]);
        String fromSnapshot = SnapshotDiff.getSnapshotName(argv[1]);
        String toSnapshot = SnapshotDiff.getSnapshotName(argv[2]);
        try {
            SnapshotDiffReport diffReport = dfs.getSnapshotDiffReport(snapshotRoot, fromSnapshot, toSnapshot);
            System.out.println(diffReport.toString());
        }
        catch (IOException e) {
            String[] content = e.getLocalizedMessage().split("\n");
            System.err.println("snapshotDiff: " + content[0]);
        }
    }
}

