/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.ConstraintPlacementAlgorithm;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.ConstraintPlacementAlgorithmOutput;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.ConstraintPlacementAlgorithmOutputCollector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.PlacedSchedulingRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.SchedulingRequestWithPlacementAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.BatchedRequests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlacementDispatcher
implements ConstraintPlacementAlgorithmOutputCollector {
    private static final Logger LOG = LoggerFactory.getLogger(PlacementDispatcher.class);
    private ConstraintPlacementAlgorithm algorithm;
    private ExecutorService algorithmThreadPool;
    private Map<ApplicationId, List<PlacedSchedulingRequest>> placedRequests = new ConcurrentHashMap<ApplicationId, List<PlacedSchedulingRequest>>();
    private Map<ApplicationId, List<SchedulingRequestWithPlacementAttempt>> rejectedRequests = new ConcurrentHashMap<ApplicationId, List<SchedulingRequestWithPlacementAttempt>>();

    PlacementDispatcher() {
    }

    public void init(RMContext rmContext, ConstraintPlacementAlgorithm placementAlgorithm, int poolSize) {
        LOG.info("Initializing Constraint Placement Planner:");
        this.algorithm = placementAlgorithm;
        this.algorithm.init(rmContext);
        this.algorithmThreadPool = Executors.newFixedThreadPool(poolSize);
    }

    void dispatch(BatchedRequests batchedRequests) {
        PlacementDispatcher collector = this;
        Runnable placingTask = () -> {
            LOG.debug("Got [{}] requests to place from application [{}].. Attempt count [{}]", new Object[]{batchedRequests.getSchedulingRequests().size(), batchedRequests.getApplicationId(), batchedRequests.getPlacementAttempt()});
            this.algorithm.place(batchedRequests, collector);
        };
        this.algorithmThreadPool.submit(placingTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PlacedSchedulingRequest> pullPlacedRequests(ApplicationId applicationId) {
        List<PlacedSchedulingRequest> placedReqs = this.placedRequests.get(applicationId);
        if (placedReqs != null && !placedReqs.isEmpty()) {
            ArrayList<PlacedSchedulingRequest> retList = new ArrayList<PlacedSchedulingRequest>();
            List<PlacedSchedulingRequest> list = placedReqs;
            synchronized (list) {
                if (placedReqs.size() > 0) {
                    retList.addAll(placedReqs);
                    placedReqs.clear();
                }
            }
            return retList;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SchedulingRequestWithPlacementAttempt> pullRejectedRequests(ApplicationId applicationId) {
        List<SchedulingRequestWithPlacementAttempt> rejectedReqs = this.rejectedRequests.get(applicationId);
        if (rejectedReqs != null && !rejectedReqs.isEmpty()) {
            ArrayList<SchedulingRequestWithPlacementAttempt> retList = new ArrayList<SchedulingRequestWithPlacementAttempt>();
            List<SchedulingRequestWithPlacementAttempt> list = rejectedReqs;
            synchronized (list) {
                if (rejectedReqs.size() > 0) {
                    retList.addAll(rejectedReqs);
                    rejectedReqs.clear();
                }
            }
            return retList;
        }
        return Collections.emptyList();
    }

    void clearApplicationState(ApplicationId applicationId) {
        this.placedRequests.remove(applicationId);
        this.rejectedRequests.remove(applicationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(ConstraintPlacementAlgorithmOutput placement) {
        List list;
        if (!placement.getPlacedRequests().isEmpty()) {
            List processed;
            list = processed = this.placedRequests.computeIfAbsent(placement.getApplicationId(), k -> new ArrayList());
            synchronized (list) {
                LOG.debug("Planning Algorithm has placed for application [{}] the following [{}]", (Object)placement.getApplicationId(), placement.getPlacedRequests());
                for (PlacedSchedulingRequest esr : placement.getPlacedRequests()) {
                    processed.add(esr);
                }
            }
        }
        if (!placement.getRejectedRequests().isEmpty()) {
            List rejected = this.rejectedRequests.computeIfAbsent(placement.getApplicationId(), k -> new ArrayList());
            LOG.warn("Planning Algorithm has rejected for application [{}] the following [{}]", (Object)placement.getApplicationId(), placement.getRejectedRequests());
            list = rejected;
            synchronized (list) {
                rejected.addAll(placement.getRejectedRequests());
            }
        }
    }
}

