/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SimpleRegionNormalizer
implements RegionNormalizer {
    private static final Log LOG = LogFactory.getLog(SimpleRegionNormalizer.class);
    private static final int MIN_REGION_COUNT = 3;
    private MasterServices masterServices;
    private MasterRpcServices masterRpcServices;
    private static long[] skippedCount = new long[NormalizationPlan.PlanType.values().length];
    private Comparator<NormalizationPlan> planComparator = new Comparator<NormalizationPlan>(){

        @Override
        public int compare(NormalizationPlan plan, NormalizationPlan plan2) {
            if (plan instanceof SplitNormalizationPlan) {
                return -1;
            }
            if (plan2 instanceof SplitNormalizationPlan) {
                return 1;
            }
            return 0;
        }
    };

    @Override
    public void setMasterServices(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    @Override
    public void setMasterRpcServices(MasterRpcServices masterRpcServices) {
        this.masterRpcServices = masterRpcServices;
    }

    @Override
    public void planSkipped(RegionInfo hri, NormalizationPlan.PlanType type) {
        int n = type.ordinal();
        skippedCount[n] = skippedCount[n] + 1L;
    }

    @Override
    public long getSkippedCount(NormalizationPlan.PlanType type) {
        return skippedCount[type.ordinal()];
    }

    @Override
    public List<NormalizationPlan> computePlanForTable(TableName table) throws HBaseIOException {
        if (table == null || table.isSystemTable()) {
            LOG.debug((Object)("Normalization of system table " + table + " isn't allowed"));
            return null;
        }
        ArrayList<NormalizationPlan> plans = new ArrayList<NormalizationPlan>();
        List<RegionInfo> tableRegions = this.masterServices.getAssignmentManager().getRegionStates().getRegionsOfTable(table);
        if (tableRegions == null || tableRegions.size() < 3) {
            int nrRegions = tableRegions == null ? 0 : tableRegions.size();
            LOG.debug((Object)("Table " + table + " has " + nrRegions + " regions, required min number of regions for normalizer to run is " + 3 + ", not running normalizer"));
            return null;
        }
        LOG.debug((Object)("Computing normalization plan for table: " + table + ", number of regions: " + tableRegions.size()));
        long totalSizeMb = 0L;
        int acutalRegionCnt = 0;
        for (int i = 0; i < tableRegions.size(); ++i) {
            RegionInfo hri = tableRegions.get(i);
            long regionSize = this.getRegionSize(hri);
            if (regionSize <= 0L) continue;
            ++acutalRegionCnt;
            totalSizeMb += regionSize;
        }
        double avgRegionSize = acutalRegionCnt == 0 ? 0.0 : (double)totalSizeMb / (double)acutalRegionCnt;
        LOG.debug((Object)("Table " + table + ", total aggregated regions size: " + totalSizeMb));
        LOG.debug((Object)("Table " + table + ", average region size: " + avgRegionSize));
        int candidateIdx = 0;
        boolean splitEnabled = true;
        boolean mergeEnabled = true;
        try {
            splitEnabled = this.masterRpcServices.isSplitOrMergeEnabled(null, RequestConverter.buildIsSplitOrMergeEnabledRequest((MasterSwitchType)MasterSwitchType.SPLIT)).getEnabled();
        }
        catch (ServiceException e) {
            LOG.debug((Object)"Unable to determine whether split is enabled", (Throwable)e);
        }
        try {
            mergeEnabled = this.masterRpcServices.isSplitOrMergeEnabled(null, RequestConverter.buildIsSplitOrMergeEnabledRequest((MasterSwitchType)MasterSwitchType.MERGE)).getEnabled();
        }
        catch (ServiceException e) {
            LOG.debug((Object)"Unable to determine whether split is enabled", (Throwable)e);
        }
        while (candidateIdx < tableRegions.size()) {
            RegionInfo hri = tableRegions.get(candidateIdx);
            long regionSize = this.getRegionSize(hri);
            if ((double)regionSize > 2.0 * avgRegionSize) {
                if (splitEnabled) {
                    LOG.info((Object)("Table " + table + ", large region " + hri.getRegionNameAsString() + " has size " + regionSize + ", more than twice avg size, splitting"));
                    plans.add(new SplitNormalizationPlan(hri, null));
                }
            } else {
                if (candidateIdx == tableRegions.size() - 1) break;
                if (mergeEnabled) {
                    RegionInfo hri2 = tableRegions.get(candidateIdx + 1);
                    long regionSize2 = this.getRegionSize(hri2);
                    if (regionSize >= 0L && regionSize2 >= 0L && (double)(regionSize + regionSize2) < avgRegionSize) {
                        LOG.info((Object)("Table " + table + ", small region size: " + regionSize + " plus its neighbor size: " + regionSize2 + ", less than the avg size " + avgRegionSize + ", merging them"));
                        plans.add(new MergeNormalizationPlan(hri, hri2));
                        ++candidateIdx;
                    }
                }
            }
            ++candidateIdx;
        }
        if (plans.isEmpty()) {
            LOG.debug((Object)("No normalization needed, regions look good for table: " + table));
            return null;
        }
        Collections.sort(plans, this.planComparator);
        return plans;
    }

    private long getRegionSize(RegionInfo hri) {
        ServerName sn = this.masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
        RegionLoad regionLoad = (RegionLoad)this.masterServices.getServerManager().getLoad(sn).getRegionsLoad().get(hri.getRegionName());
        if (regionLoad == null) {
            LOG.debug((Object)(hri.getRegionNameAsString() + " was not found in RegionsLoad"));
            return -1L;
        }
        return regionLoad.getStorefileSizeMB();
    }
}

