/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TruncateTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.TruncateTableState> {
    private static final Log LOG = LogFactory.getLog(TruncateTableProcedure.class);
    private boolean preserveSplits;
    private List<RegionInfo> regions;
    private TableDescriptor tableDescriptor;
    private TableName tableName;

    public TruncateTableProcedure() {
    }

    public TruncateTableProcedure(MasterProcedureEnv env, TableName tableName, boolean preserveSplits) {
        this(env, tableName, preserveSplits, null);
    }

    public TruncateTableProcedure(MasterProcedureEnv env, TableName tableName, boolean preserveSplits, ProcedurePrepareLatch latch) {
        super(env, latch);
        this.tableName = tableName;
        this.preserveSplits = preserveSplits;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.TruncateTableState state) throws InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case TRUNCATE_TABLE_PRE_OPERATION: {
                    if (!this.prepareTruncate(env)) {
                        assert (this.isFailed()) : "the truncate should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    LOG.debug((Object)("waiting for '" + this.getTableName() + "' regions in transition"));
                    this.regions = env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName());
                    assert (this.regions != null && !this.regions.isEmpty()) : "unexpected 0 regions";
                    ProcedureSyncWait.waitRegionInTransition(env, this.regions);
                    this.preTruncate(env);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_REMOVE_FROM_META);
                    break;
                }
                case TRUNCATE_TABLE_REMOVE_FROM_META: {
                    this.tableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
                    DeleteTableProcedure.deleteFromMeta(env, this.getTableName(), this.regions);
                    DeleteTableProcedure.deleteAssignmentState(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_CLEAR_FS_LAYOUT);
                    break;
                }
                case TRUNCATE_TABLE_CLEAR_FS_LAYOUT: {
                    DeleteTableProcedure.deleteFromFs(env, this.getTableName(), this.regions, true);
                    this.regions = !this.preserveSplits ? Arrays.asList(ModifyRegionUtils.createRegionInfos(this.tableDescriptor, null)) : TruncateTableProcedure.recreateRegionInfo(this.regions);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_CREATE_FS_LAYOUT);
                    break;
                }
                case TRUNCATE_TABLE_CREATE_FS_LAYOUT: {
                    this.regions = CreateTableProcedure.createFsLayout(env, this.tableDescriptor, this.regions);
                    CreateTableProcedure.updateTableDescCache(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ADD_TO_META);
                    break;
                }
                case TRUNCATE_TABLE_ADD_TO_META: {
                    this.regions = CreateTableProcedure.addTableToMeta(env, this.tableDescriptor, this.regions);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ASSIGN_REGIONS);
                    break;
                }
                case TRUNCATE_TABLE_ASSIGN_REGIONS: {
                    CreateTableProcedure.setEnablingState(env, this.getTableName());
                    this.addChildProcedure(env.getAssignmentManager().createAssignProcedures(this.regions));
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_POST_OPERATION);
                    this.tableDescriptor = null;
                    this.regions = null;
                    break;
                }
                case TRUNCATE_TABLE_POST_OPERATION: {
                    CreateTableProcedure.setEnabledState(env, this.getTableName());
                    this.postTruncate(env);
                    LOG.debug((Object)("truncate '" + this.getTableName() + "' completed"));
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | HBaseException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-truncate-table", e);
            }
            LOG.warn((Object)("Retriable error trying to truncate table=" + this.getTableName() + " state=" + state), e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.TruncateTableState state) {
        if (state == MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected void completionCleanup(MasterProcedureEnv env) {
        this.releaseSyncLatch();
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.TruncateTableState state) {
        switch (state) {
            case TRUNCATE_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.TruncateTableState getState(int stateId) {
        return MasterProcedureProtos.TruncateTableState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.TruncateTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.TruncateTableState getInitialState() {
        return MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_PRE_OPERATION;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(" preserveSplits=");
        sb.append(this.preserveSplits);
        sb.append(")");
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.TruncateTableStateData.Builder state = MasterProcedureProtos.TruncateTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setPreserveSplits(this.preserveSplits);
        if (this.tableDescriptor != null) {
            state.setTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.tableDescriptor));
        } else {
            state.setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName));
        }
        if (this.regions != null) {
            for (RegionInfo hri : this.regions) {
                state.addRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)hri));
            }
        }
        serializer.serialize((Message)state.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.TruncateTableStateData state = (MasterProcedureProtos.TruncateTableStateData)serializer.deserialize(MasterProcedureProtos.TruncateTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(state.getUserInfo()));
        if (state.hasTableSchema()) {
            this.tableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)state.getTableSchema());
            this.tableName = this.tableDescriptor.getTableName();
        } else {
            this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)state.getTableName());
        }
        this.preserveSplits = state.getPreserveSplits();
        if (state.getRegionInfoCount() == 0) {
            this.regions = null;
        } else {
            this.regions = new ArrayList<RegionInfo>(state.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : state.getRegionInfoList()) {
                this.regions.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)hri));
            }
        }
    }

    private static List<RegionInfo> recreateRegionInfo(List<RegionInfo> regions) {
        ArrayList<RegionInfo> newRegions = new ArrayList<RegionInfo>(regions.size());
        for (RegionInfo hri : regions) {
            newRegions.add(RegionInfoBuilder.newBuilder((TableName)hri.getTable()).setStartKey(hri.getStartKey()).setEndKey(hri.getEndKey()).build());
        }
        return newRegions;
    }

    private boolean prepareTruncate(MasterProcedureEnv env) throws IOException {
        try {
            env.getMasterServices().checkTableModifiable(this.getTableName());
        }
        catch (TableNotDisabledException | TableNotFoundException e) {
            this.setFailure("master-truncate-table", e);
            return false;
        }
        return true;
    }

    private boolean preTruncate(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            TableName tableName = this.getTableName();
            cpHost.preTruncateTableAction(tableName, this.getUser());
        }
        return true;
    }

    private void postTruncate(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            TableName tableName = this.getTableName();
            cpHost.postCompletedTruncateTableAction(tableName, this.getUser());
        }
    }
}

