/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.wal.AbstractProtobufLogWriter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.wal.FSHLogProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ProtobufLogWriter
extends AbstractProtobufLogWriter
implements FSHLogProvider.Writer {
    private static final Log LOG = LogFactory.getLog(ProtobufLogWriter.class);
    protected FSDataOutputStream output;

    @Override
    public void append(WAL.Entry entry) throws IOException {
        entry.setCompressionContext(this.compressionContext);
        entry.getKey().getBuilder(this.compressor).setFollowingKvCount(entry.getEdit().size()).build().writeDelimitedTo((OutputStream)this.output);
        for (Cell cell : entry.getEdit().getCells()) {
            this.cellEncoder.write(cell);
        }
        this.length.set(this.output.getPos());
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            try {
                if (!this.trailerWritten) {
                    this.writeWALTrailer();
                }
                this.output.close();
            }
            catch (NullPointerException npe) {
                LOG.warn((Object)npe);
            }
            this.output = null;
        }
    }

    @Override
    public void sync() throws IOException {
        FSDataOutputStream fsdos = this.output;
        if (fsdos == null) {
            return;
        }
        fsdos.flush();
        fsdos.hflush();
    }

    public FSDataOutputStream getStream() {
        return this.output;
    }

    @Override
    protected void initOutput(FileSystem fs, Path path, boolean overwritable, int bufferSize, short replication, long blockSize) throws IOException {
        this.output = fs.createNonRecursive(path, overwritable, bufferSize, replication, blockSize, null);
    }

    @Override
    protected long writeMagicAndWALHeader(byte[] magic, WALProtos.WALHeader header) throws IOException {
        this.output.write(magic);
        header.writeDelimitedTo((OutputStream)this.output);
        return this.output.getPos();
    }

    @Override
    protected OutputStream getOutputStreamForCellEncoder() {
        return this.output;
    }

    @Override
    protected long writeWALTrailerAndMagic(WALProtos.WALTrailer trailer, byte[] magic) throws IOException {
        trailer.writeTo((OutputStream)this.output);
        this.output.writeInt(trailer.getSerializedSize());
        this.output.write(magic);
        return this.output.getPos();
    }
}

