/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AccessControlLists {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");
    public static final byte[] ACL_GLOBAL_NAME = ACL_TABLE_NAME.getName();
    public static final String ACL_LIST_FAMILY_STR = "l";
    public static final byte[] ACL_LIST_FAMILY = Bytes.toBytes((String)"l");
    public static final byte ACL_TAG_TYPE = 1;
    public static final char NAMESPACE_PREFIX = '@';
    public static final char ACL_KEY_DELIMITER = ',';
    private static final Log LOG = LogFactory.getLog(AccessControlLists.class);
    private static final int LIST_CODE = 61;
    private static final int WRITABLE_CODE = 14;
    private static final int WRITABLE_NOT_ENCODED = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUserPermission(Configuration conf, UserPermission userPerm, Table t, boolean mergeExistingPermissions) throws IOException {
        Permission.Action[] actions = userPerm.getActions();
        byte[] rowKey = AccessControlLists.userPermissionRowKey(userPerm);
        Put p = new Put(rowKey);
        byte[] key = AccessControlLists.userPermissionKey(userPerm);
        if (actions == null || actions.length == 0) {
            String msg = "No actions associated with user '" + Bytes.toString((byte[])userPerm.getUser()) + "'";
            LOG.warn((Object)msg);
            throw new IOException(msg);
        }
        TreeSet<Permission.Action> actionSet = new TreeSet<Permission.Action>();
        if (mergeExistingPermissions) {
            List<UserPermission> perms = AccessControlLists.getUserPermissions(conf, rowKey);
            UserPermission currentPerm = null;
            for (UserPermission perm : perms) {
                if (!Bytes.equals((byte[])perm.getUser(), (byte[])userPerm.getUser()) || (!userPerm.isGlobal() || !ACL_TABLE_NAME.equals((Object)perm.getTableName())) && !perm.tableFieldsEqual((TablePermission)userPerm)) continue;
                currentPerm = perm;
                break;
            }
            if (currentPerm != null && currentPerm.getActions() != null) {
                actionSet.addAll(Arrays.asList(currentPerm.getActions()));
            }
        }
        actionSet.addAll(Arrays.asList(actions));
        byte[] value = new byte[actionSet.size()];
        int index = 0;
        for (Permission.Action action : actionSet) {
            value[index++] = action.code();
        }
        p.addImmutable(ACL_LIST_FAMILY, key, value);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Writing permission with rowKey " + Bytes.toString((byte[])rowKey) + " " + Bytes.toString((byte[])key) + ": " + Bytes.toStringBinary((byte[])value)));
        }
        try {
            t.put(Collections.singletonList(p));
        }
        finally {
            t.close();
        }
    }

    static void addUserPermission(Configuration conf, UserPermission userPerm, Table t) throws IOException {
        AccessControlLists.addUserPermission(conf, userPerm, t, false);
    }

    static void removeUserPermission(Configuration conf, UserPermission userPerm, Table t) throws IOException {
        if (null == userPerm.getActions()) {
            AccessControlLists.removePermissionRecord(conf, userPerm, t);
        } else {
            List<UserPermission> permsList = AccessControlLists.getUserPermissions(conf, AccessControlLists.userPermissionRowKey(userPerm));
            ArrayList<Permission.Action> remainingActions = new ArrayList<Permission.Action>();
            List<Permission.Action> dropActions = Arrays.asList(userPerm.getActions());
            for (UserPermission perm : permsList) {
                if (!Bytes.toString((byte[])perm.getUser()).equals(Bytes.toString((byte[])userPerm.getUser()))) continue;
                for (Permission.Action oldAction : perm.getActions()) {
                    if (dropActions.contains(oldAction)) continue;
                    remainingActions.add(oldAction);
                }
                if (!remainingActions.isEmpty()) {
                    perm.setActions(remainingActions.toArray(new Permission.Action[remainingActions.size()]));
                    AccessControlLists.addUserPermission(conf, perm, t);
                    break;
                }
                AccessControlLists.removePermissionRecord(conf, userPerm, t);
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removed permission " + userPerm.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removePermissionRecord(Configuration conf, UserPermission userPerm, Table t) throws IOException {
        Delete d = new Delete(AccessControlLists.userPermissionRowKey(userPerm));
        d.addColumns(ACL_LIST_FAMILY, AccessControlLists.userPermissionKey(userPerm));
        try {
            t.delete(d);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTablePermissions(Configuration conf, TableName tableName, Table t) throws IOException {
        Delete d = new Delete(tableName.getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing permissions of removed table " + tableName));
        }
        try {
            t.delete(d);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeNamespacePermissions(Configuration conf, String namespace, Table t) throws IOException {
        Delete d = new Delete(Bytes.toBytes((String)AccessControlLists.toNamespaceEntry(namespace)));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing permissions of removed namespace " + namespace));
        }
        try {
            t.delete(d);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTablePermissions(TableName tableName, byte[] column, Table table, boolean closeTable) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        String columnName = Bytes.toString((byte[])column);
        scan.setFilter((Filter)new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(String.format("(%s%s%s)|(%s%s)$", Character.valueOf(','), columnName, Character.valueOf(','), Character.valueOf(','), columnName))));
        TreeSet<byte[]> qualifierSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        ResultScanner scanner = null;
        try {
            scanner = table.getScanner(scan);
            for (Result res : scanner) {
                for (byte[] q : res.getFamilyMap(ACL_LIST_FAMILY).navigableKeySet()) {
                    qualifierSet.add(q);
                }
            }
            if (qualifierSet.size() > 0) {
                Delete d = new Delete(tableName.getName());
                for (byte[] qualifier : qualifierSet) {
                    d.addColumns(ACL_LIST_FAMILY, qualifier);
                }
                table.delete(d);
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (closeTable) {
                table.close();
            }
        }
    }

    static void removeTablePermissions(Configuration conf, TableName tableName, byte[] column, Table t) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing permissions of removed column " + Bytes.toString((byte[])column) + " from table " + tableName));
        }
        AccessControlLists.removeTablePermissions(tableName, column, t, true);
    }

    static byte[] userPermissionRowKey(UserPermission userPerm) {
        byte[] row = userPerm.hasNamespace() ? Bytes.toBytes((String)AccessControlLists.toNamespaceEntry(userPerm.getNamespace())) : (userPerm.isGlobal() ? ACL_GLOBAL_NAME : userPerm.getTableName().getName());
        return row;
    }

    static byte[] userPermissionKey(UserPermission userPerm) {
        byte[] qualifier = userPerm.getQualifier();
        byte[] family = userPerm.getFamily();
        byte[] key = userPerm.getUser();
        if (family != null && family.length > 0) {
            key = Bytes.add((byte[])key, (byte[])Bytes.add((byte[])new byte[]{44}, (byte[])family));
            if (qualifier != null && qualifier.length > 0) {
                key = Bytes.add((byte[])key, (byte[])Bytes.add((byte[])new byte[]{44}, (byte[])qualifier));
            }
        }
        return key;
    }

    static boolean isAclRegion(Region region) {
        return ACL_TABLE_NAME.equals((Object)region.getTableDescriptor().getTableName());
    }

    static boolean isAclTable(TableDescriptor desc) {
        return ACL_TABLE_NAME.equals((Object)desc.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<byte[], ListMultimap<String, TablePermission>> loadAll(Region aclRegion) throws IOException {
        if (!AccessControlLists.isAclRegion(aclRegion)) {
            throw new IOException("Can only load permissions from " + ACL_TABLE_NAME);
        }
        TreeMap<byte[], ListMultimap<String, TablePermission>> allPerms = new TreeMap<byte[], ListMultimap<String, TablePermission>>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        try (RegionScanner iScanner = null;){
            boolean hasNext;
            iScanner = aclRegion.getScanner(scan);
            do {
                ArrayList<Cell> row = new ArrayList<Cell>();
                hasNext = iScanner.next(row);
                ArrayListMultimap perms = ArrayListMultimap.create();
                byte[] entry = null;
                for (Cell kv : row) {
                    Pair<String, TablePermission> permissionsOfUserOnTable;
                    if (entry == null) {
                        entry = CellUtil.cloneRow((Cell)kv);
                    }
                    if ((permissionsOfUserOnTable = AccessControlLists.parsePermissionRecord(entry, kv)) == null) continue;
                    String username = (String)permissionsOfUserOnTable.getFirst();
                    TablePermission permissions = (TablePermission)permissionsOfUserOnTable.getSecond();
                    perms.put((Object)username, (Object)permissions);
                }
                if (entry == null) continue;
                allPerms.put(entry, (ListMultimap<String, TablePermission>)perms);
            } while (hasNext);
        }
        return allPerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<byte[], ListMultimap<String, TablePermission>> loadAll(Configuration conf) throws IOException {
        TreeMap<byte[], ListMultimap<String, TablePermission>> allPerms = new TreeMap<byte[], ListMultimap<String, TablePermission>>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        ResultScanner scanner = null;
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Table table = connection.getTable(ACL_TABLE_NAME);){
            scanner = table.getScanner(scan);
            try {
                for (Result row : scanner) {
                    ListMultimap<String, TablePermission> resultPerms = AccessControlLists.parsePermissions(row.getRow(), row);
                    allPerms.put(row.getRow(), resultPerms);
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return allPerms;
    }

    public static ListMultimap<String, TablePermission> getTablePermissions(Configuration conf, TableName tableName) throws IOException {
        return AccessControlLists.getPermissions(conf, tableName != null ? tableName.getName() : null, null);
    }

    static ListMultimap<String, TablePermission> getNamespacePermissions(Configuration conf, String namespace) throws IOException {
        return AccessControlLists.getPermissions(conf, Bytes.toBytes((String)AccessControlLists.toNamespaceEntry(namespace)), null);
    }

    static ListMultimap<String, TablePermission> getPermissions(Configuration conf, byte[] entryName, Table t) throws IOException {
        Result row;
        ListMultimap<String, TablePermission> perms;
        block28: {
            if (entryName == null) {
                entryName = ACL_GLOBAL_NAME;
            }
            perms = ArrayListMultimap.create();
            Get get = new Get(entryName);
            get.addFamily(ACL_LIST_FAMILY);
            row = null;
            if (t == null) {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table table = connection.getTable(ACL_TABLE_NAME);){
                    row = table.get(get);
                    break block28;
                }
            }
            row = t.get(get);
        }
        if (!row.isEmpty()) {
            perms = AccessControlLists.parsePermissions(entryName, row);
        } else {
            LOG.info((Object)("No permissions found in " + ACL_TABLE_NAME + " for acl entry " + Bytes.toString((byte[])entryName)));
        }
        return perms;
    }

    static List<UserPermission> getUserTablePermissions(Configuration conf, TableName tableName) throws IOException {
        return AccessControlLists.getUserPermissions(conf, tableName == null ? null : tableName.getName());
    }

    static List<UserPermission> getUserNamespacePermissions(Configuration conf, String namespace) throws IOException {
        return AccessControlLists.getUserPermissions(conf, Bytes.toBytes((String)AccessControlLists.toNamespaceEntry(namespace)));
    }

    static List<UserPermission> getUserPermissions(Configuration conf, byte[] entryName) throws IOException {
        ListMultimap<String, TablePermission> allPerms = AccessControlLists.getPermissions(conf, entryName, null);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>();
        if (AccessControlLists.isNamespaceEntry(entryName)) {
            for (Map.Entry entry : allPerms.entries()) {
                UserPermission up = new UserPermission(Bytes.toBytes((String)((String)entry.getKey())), ((TablePermission)entry.getValue()).getNamespace(), ((TablePermission)entry.getValue()).getActions());
                perms.add(up);
            }
        } else {
            for (Map.Entry entry : allPerms.entries()) {
                UserPermission up = new UserPermission(Bytes.toBytes((String)((String)entry.getKey())), ((TablePermission)entry.getValue()).getTableName(), ((TablePermission)entry.getValue()).getFamily(), ((TablePermission)entry.getValue()).getQualifier(), ((TablePermission)entry.getValue()).getActions());
                perms.add(up);
            }
        }
        return perms;
    }

    private static ListMultimap<String, TablePermission> parsePermissions(byte[] entryName, Result result) {
        ArrayListMultimap perms = ArrayListMultimap.create();
        if (result != null && result.size() > 0) {
            for (Cell kv : result.rawCells()) {
                Pair<String, TablePermission> permissionsOfUserOnTable = AccessControlLists.parsePermissionRecord(entryName, kv);
                if (permissionsOfUserOnTable == null) continue;
                String username = (String)permissionsOfUserOnTable.getFirst();
                TablePermission permissions = (TablePermission)permissionsOfUserOnTable.getSecond();
                perms.put((Object)username, (Object)permissions);
            }
        }
        return perms;
    }

    private static Pair<String, TablePermission> parsePermissionRecord(byte[] entryName, Cell kv) {
        byte[] family = CellUtil.cloneFamily((Cell)kv);
        if (!Bytes.equals((byte[])family, (byte[])ACL_LIST_FAMILY)) {
            return null;
        }
        byte[] key = CellUtil.cloneQualifier((Cell)kv);
        byte[] value = CellUtil.cloneValue((Cell)kv);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Read acl: kv [" + Bytes.toStringBinary((byte[])key) + ": " + Bytes.toStringBinary((byte[])value) + "]"));
        }
        String username = Bytes.toString((byte[])key);
        if (AccessControlLists.isNamespaceEntry(entryName)) {
            return new Pair((Object)username, (Object)new TablePermission(Bytes.toString((byte[])AccessControlLists.fromNamespaceEntry(entryName)), value));
        }
        int idx = username.indexOf(44);
        byte[] permFamily = null;
        byte[] permQualifier = null;
        if (idx > 0 && idx < username.length() - 1) {
            String remainder = username.substring(idx + 1);
            username = username.substring(0, idx);
            idx = remainder.indexOf(44);
            if (idx > 0 && idx < remainder.length() - 1) {
                permFamily = Bytes.toBytes((String)remainder.substring(0, idx));
                permQualifier = Bytes.toBytes((String)remainder.substring(idx + 1));
            } else {
                permFamily = Bytes.toBytes((String)remainder);
            }
        }
        return new Pair((Object)username, (Object)new TablePermission(TableName.valueOf((byte[])entryName), permFamily, permQualifier, value));
    }

    public static byte[] writePermissionsAsBytes(ListMultimap<String, TablePermission> perms, Configuration conf) {
        return ProtobufUtil.prependPBMagic((byte[])AccessControlUtil.toUserTablePermissions(perms).toByteArray());
    }

    private static List<TablePermission> readWritablePermissions(DataInput in, Configuration conf) throws IOException, ClassNotFoundException {
        assert (WritableUtils.readVInt((DataInput)in) == 61);
        int length = in.readInt();
        ArrayList<TablePermission> list = new ArrayList<TablePermission>(length);
        for (int i = 0; i < length; ++i) {
            assert (WritableUtils.readVInt((DataInput)in) == 14);
            assert (WritableUtils.readVInt((DataInput)in) == 0);
            String className = Text.readString((DataInput)in);
            Class<Writable> clazz = conf.getClassByName(className).asSubclass(Writable.class);
            Writable instance = WritableFactories.newInstance(clazz, (Configuration)conf);
            instance.readFields(in);
            list.add((TablePermission)instance);
        }
        return list;
    }

    public static ListMultimap<String, TablePermission> readPermissions(byte[] data, Configuration conf) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix((byte[])data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)pblen, (int)(data.length - pblen));
                return AccessControlUtil.toUserTablePermissions((AccessControlProtos.UsersAndPermissions)builder.build());
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        ArrayListMultimap perms = ArrayListMultimap.create();
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            int length = in.readInt();
            for (int i = 0; i < length; ++i) {
                String user = Text.readString((DataInput)in);
                List<TablePermission> userPerms = AccessControlLists.readWritablePermissions(in, conf);
                perms.putAll((Object)user, userPerms);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new DeserializationException((Throwable)e);
        }
        return perms;
    }

    public static boolean isNamespaceEntry(String entryName) {
        return entryName != null && entryName.charAt(0) == '@';
    }

    public static boolean isNamespaceEntry(byte[] entryName) {
        return entryName != null && entryName.length != 0 && entryName[0] == 64;
    }

    public static String toNamespaceEntry(String namespace) {
        return '@' + namespace;
    }

    public static String fromNamespaceEntry(String namespace) {
        if (namespace.charAt(0) != '@') {
            throw new IllegalArgumentException("Argument is not a valid namespace entry");
        }
        return namespace.substring(1);
    }

    public static byte[] toNamespaceEntry(byte[] namespace) {
        byte[] ret = new byte[namespace.length + 1];
        ret[0] = 64;
        System.arraycopy(namespace, 0, ret, 1, namespace.length);
        return ret;
    }

    public static byte[] fromNamespaceEntry(byte[] namespace) {
        if (namespace[0] != 64) {
            throw new IllegalArgumentException("Argument is not a valid namespace entry: " + Bytes.toString((byte[])namespace));
        }
        return Arrays.copyOfRange(namespace, 1, namespace.length);
    }

    public static List<Permission> getCellPermissionsForUser(User user, Cell cell) throws IOException {
        if (cell.getTagsLength() == 0) {
            return null;
        }
        ArrayList results = Lists.newArrayList();
        Iterator tagsIterator = PrivateCellUtil.tagsIterator((Cell)cell);
        while (tagsIterator.hasNext()) {
            String[] groupNames;
            Tag tag = (Tag)tagsIterator.next();
            if (tag.getType() != 1) continue;
            AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
            if (tag.hasArray()) {
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])tag.getValueArray(), (int)tag.getValueOffset(), (int)tag.getValueLength());
            } else {
                ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])TagUtil.cloneValue((Tag)tag));
            }
            ListMultimap kvPerms = AccessControlUtil.toUsersAndPermissions((AccessControlProtos.UsersAndPermissions)builder.build());
            List userPerms = kvPerms.get((Object)user.getShortName());
            if (userPerms != null) {
                results.addAll(userPerms);
            }
            if ((groupNames = user.getGroupNames()) == null) continue;
            for (String group : groupNames) {
                List groupPerms = kvPerms.get((Object)AuthUtil.toGroupEntry((String)group));
                if (results == null) continue;
                results.addAll(groupPerms);
            }
        }
        return results;
    }
}

