/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Message;
import com.google.protobuf.Service;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.RawCellBuilder;
import org.apache.hadoop.hbase.RawCellBuilderFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SharedConnection;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.CoprocessorServiceBackwardCompatiblity;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.MetricsCoprocessor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.regionserver.CustomizedScanInfoBuilder;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.CoprocessorClassLoader;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.map.ReferenceMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionCoprocessorHost
extends CoprocessorHost<RegionCoprocessor, RegionCoprocessorEnvironment> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionCoprocessorHost.class);
    private static final ReferenceMap<String, ConcurrentMap<String, Object>> SHARED_DATA_MAP = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
    private final boolean hasCustomPostScannerFilterRow;
    RegionServerServices rsServices;
    HRegion region;
    private CoprocessorHost.ObserverGetter<RegionCoprocessor, RegionObserver> regionObserverGetter = RegionCoprocessor::getRegionObserver;
    private CoprocessorHost.ObserverGetter<RegionCoprocessor, EndpointObserver> endpointObserverGetter = RegionCoprocessor::getEndpointObserver;

    public boolean hasCustomPostScannerFilterRow() {
        return this.hasCustomPostScannerFilterRow;
    }

    public RegionCoprocessorHost(HRegion region, RegionServerServices rsServices, Configuration conf) {
        super(rsServices);
        this.conf = conf;
        this.rsServices = rsServices;
        this.region = region;
        this.pathPrefix = Integer.toString(this.region.getRegionInfo().hashCode());
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.region.classes");
        if (!region.getRegionInfo().getTable().isSystemTable()) {
            this.loadSystemCoprocessors(conf, "hbase.coprocessor.user.region.classes");
        }
        this.loadTableCoprocessors(conf);
        boolean hasCustomPostScannerFilterRow = false;
        block4: for (RegionCoprocessorEnvironment env : this.coprocEnvironments) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            for (Class<?> clazz = ((RegionCoprocessor)env.getInstance()).getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    clazz.getDeclaredMethod("postScannerFilterRow", ObserverContext.class, InternalScanner.class, Cell.class, Boolean.TYPE);
                    hasCustomPostScannerFilterRow = true;
                    break block4;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        clazz.getDeclaredMethod("postScannerFilterRow", ObserverContext.class, InternalScanner.class, byte[].class, Integer.TYPE, Short.TYPE, Boolean.TYPE);
                        hasCustomPostScannerFilterRow = true;
                        break block4;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        continue;
                    }
                }
            }
        }
        this.hasCustomPostScannerFilterRow = hasCustomPostScannerFilterRow;
    }

    static List<TableCoprocessorAttribute> getTableCoprocessorAttrsFromSchema(Configuration conf, TableDescriptor htd) {
        return htd.getCoprocessorDescriptors().stream().map(cp -> {
            Configuration ourConf;
            Path path = cp.getJarPath().map(p -> new Path(p)).orElse(null);
            if (!cp.getProperties().isEmpty()) {
                ourConf = new Configuration(false);
                HBaseConfiguration.merge((Configuration)ourConf, (Configuration)conf);
                cp.getProperties().forEach((k, v) -> ourConf.set(k, v));
            } else {
                ourConf = conf;
            }
            return new TableCoprocessorAttribute(path, cp.getClassName(), cp.getPriority(), ourConf);
        }).collect(Collectors.toList());
    }

    public static void testTableCoprocessorAttrs(Configuration conf, TableDescriptor htd) throws IOException {
        String pathPrefix = UUID.randomUUID().toString();
        for (TableCoprocessorAttribute attr : RegionCoprocessorHost.getTableCoprocessorAttrsFromSchema(conf, htd)) {
            if (attr.getPriority() < 0) {
                throw new IOException("Priority for coprocessor " + attr.getClassName() + " cannot be less than 0");
            }
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = attr.getPath() != null ? CoprocessorClassLoader.getClassLoader((Path)attr.getPath(), (ClassLoader)CoprocessorHost.class.getClassLoader(), (String)pathPrefix, (Configuration)conf) : CoprocessorHost.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                if (cl instanceof CoprocessorClassLoader) {
                    String[] includedClassPrefixes = null;
                    if (conf.get("hbase.coprocessor.classloader.included.classes") != null) {
                        String prefixes = attr.conf.get("hbase.coprocessor.classloader.included.classes");
                        includedClassPrefixes = prefixes.split(";");
                    }
                    ((CoprocessorClassLoader)cl).loadClass(attr.getClassName(), includedClassPrefixes);
                    continue;
                }
                cl.loadClass(attr.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Class " + attr.getClassName() + " cannot be loaded", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    void loadTableCoprocessors(Configuration conf) {
        boolean coprocessorsEnabled = conf.getBoolean("hbase.coprocessor.enabled", true);
        boolean tableCoprocessorsEnabled = conf.getBoolean("hbase.coprocessor.user.enabled", true);
        if (!coprocessorsEnabled || !tableCoprocessorsEnabled) {
            return;
        }
        ArrayList<RegionCoprocessorEnvironment> configured = new ArrayList<RegionCoprocessorEnvironment>();
        for (TableCoprocessorAttribute attr : RegionCoprocessorHost.getTableCoprocessorAttrsFromSchema(conf, this.region.getTableDescriptor())) {
            try {
                RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)this.load(attr.getPath(), attr.getClassName(), attr.getPriority(), attr.getConf());
                if (env == null) continue;
                configured.add(env);
                LOG.info("Loaded coprocessor " + attr.getClassName() + " from HTD of " + this.region.getTableDescriptor().getTableName().getNameAsString() + " successfully.");
            }
            catch (Throwable t) {
                if (conf.getBoolean("hbase.coprocessor.abortonerror", true)) {
                    this.abortServer(attr.getClassName(), t);
                    continue;
                }
                LOG.error("Failed to load coprocessor " + attr.getClassName(), t);
            }
        }
        this.coprocEnvironments.addAll(configured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionEnvironment createEnvironment(RegionCoprocessor instance, int priority, int seq, Configuration conf) {
        ConcurrentMap classData;
        for (Service service : instance.getServices()) {
            this.region.registerService(service);
        }
        ReferenceMap<String, ConcurrentMap<String, Object>> referenceMap = SHARED_DATA_MAP;
        synchronized (referenceMap) {
            classData = (ConcurrentMap)SHARED_DATA_MAP.computeIfAbsent((Object)instance.getClass().getName(), k -> new ConcurrentHashMap());
        }
        return instance.getClass().isAnnotationPresent(CoreCoprocessor.class) ? new RegionEnvironmentForCoreCoprocessors(instance, priority, seq, conf, this.region, this.rsServices, classData) : new RegionEnvironment(instance, priority, seq, conf, this.region, this.rsServices, classData);
    }

    @Override
    public RegionCoprocessor checkAndGetInstance(Class<?> implClass) throws InstantiationException, IllegalAccessException {
        try {
            if (RegionCoprocessor.class.isAssignableFrom(implClass)) {
                return implClass.asSubclass(RegionCoprocessor.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (CoprocessorService.class.isAssignableFrom(implClass)) {
                CoprocessorService cs = implClass.asSubclass(CoprocessorService.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return new CoprocessorServiceBackwardCompatiblity.RegionCoprocessorService(cs);
            }
            LOG.error("{} is not of type RegionCoprocessor. Check the configuration of {}", (Object)implClass.getName(), (Object)"hbase.coprocessor.region.classes");
            return null;
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw (InstantiationException)new InstantiationException(implClass.getName()).initCause(e);
        }
    }

    public void preOpen() throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preOpen(this);
            }
        });
    }

    public void postOpen() {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        try {
            this.execOperation(new RegionObserverOperationWithoutResult(){

                @Override
                public void call(RegionObserver observer) throws IOException {
                    observer.postOpen(this);
                }
            });
        }
        catch (IOException e) {
            LOG.warn(e.toString(), (Throwable)e);
        }
    }

    public void preClose(final boolean abortRequested) throws IOException {
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preClose(this, abortRequested);
            }
        });
    }

    public void postClose(final boolean abortRequested) {
        try {
            this.execOperation(new RegionObserverOperationWithoutResult(){

                @Override
                public void call(RegionObserver observer) throws IOException {
                    observer.postClose(this, abortRequested);
                }

                @Override
                public void postEnvCall() {
                    RegionCoprocessorHost.this.shutdown(this.getEnvironment());
                }
            });
        }
        catch (IOException e) {
            LOG.warn(e.toString(), (Throwable)e);
        }
    }

    public boolean preCompactSelection(final HStore store, final List<HStoreFile> candidates, final CompactionLifeCycleTracker tracker, User user) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return false;
        }
        boolean bypassable = true;
        return this.execOperation(new RegionObserverOperationWithoutResult(user, bypassable){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preCompactSelection(this, store, candidates, tracker);
            }
        });
    }

    public void postCompactSelection(final HStore store, final List<HStoreFile> selected, final CompactionLifeCycleTracker tracker, final CompactionRequest request, User user) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(user){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postCompactSelection(this, store, selected, tracker, request);
            }
        });
    }

    public ScanInfo preCompactScannerOpen(final HStore store, final ScanType scanType, final CompactionLifeCycleTracker tracker, final CompactionRequest request, User user) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return store.getScanInfo();
        }
        final CustomizedScanInfoBuilder builder = new CustomizedScanInfoBuilder(store.getScanInfo());
        this.execOperation(new RegionObserverOperationWithoutResult(user){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preCompactScannerOpen(this, store, scanType, builder, tracker, request);
            }
        });
        return builder.build();
    }

    public InternalScanner preCompact(final HStore store, InternalScanner scanner, final ScanType scanType, final CompactionLifeCycleTracker tracker, final CompactionRequest request, User user) throws IOException {
        InternalScanner defaultResult = scanner;
        if (this.coprocEnvironments.isEmpty()) {
            return defaultResult;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, InternalScanner>(this.regionObserverGetter, defaultResult, user){

            @Override
            public InternalScanner call(RegionObserver observer) throws IOException {
                InternalScanner scanner = observer.preCompact(this, store, (InternalScanner)this.getResult(), scanType, tracker, request);
                if (scanner == null) {
                    throw new CoprocessorException("Null Scanner return disallowed!");
                }
                return scanner;
            }
        });
    }

    public void postCompact(final HStore store, final HStoreFile resultFile, final CompactionLifeCycleTracker tracker, final CompactionRequest request, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(user){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postCompact(this, store, resultFile, tracker, request);
            }
        });
    }

    public ScanInfo preFlushScannerOpen(final HStore store, final FlushLifeCycleTracker tracker) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return store.getScanInfo();
        }
        final CustomizedScanInfoBuilder builder = new CustomizedScanInfoBuilder(store.getScanInfo());
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preFlushScannerOpen(this, store, builder, tracker);
            }
        });
        return builder.build();
    }

    public InternalScanner preFlush(final HStore store, InternalScanner scanner, final FlushLifeCycleTracker tracker) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return scanner;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, InternalScanner>(this.regionObserverGetter, scanner){

            @Override
            public InternalScanner call(RegionObserver observer) throws IOException {
                InternalScanner scanner = observer.preFlush(this, store, (InternalScanner)this.getResult(), tracker);
                if (scanner == null) {
                    throw new CoprocessorException("Null Scanner return disallowed!");
                }
                return scanner;
            }
        });
    }

    public void preFlush(final FlushLifeCycleTracker tracker) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preFlush(this, tracker);
            }
        });
    }

    public void postFlush(final FlushLifeCycleTracker tracker) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postFlush(this, tracker);
            }
        });
    }

    public void preMemStoreCompaction(final HStore store) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preMemStoreCompaction(this, store);
            }
        });
    }

    public ScanInfo preMemStoreCompactionCompactScannerOpen(final HStore store) throws IOException {
        final CustomizedScanInfoBuilder builder = new CustomizedScanInfoBuilder(store.getScanInfo());
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preMemStoreCompactionCompactScannerOpen(this, store, builder);
            }
        });
        return builder.build();
    }

    public InternalScanner preMemStoreCompactionCompact(final HStore store, InternalScanner scanner) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return scanner;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, InternalScanner>(this.regionObserverGetter, scanner){

            @Override
            public InternalScanner call(RegionObserver observer) throws IOException {
                return observer.preMemStoreCompactionCompact(this, store, (InternalScanner)this.getResult());
            }
        });
    }

    public void postMemStoreCompaction(final HStore store) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postMemStoreCompaction(this, store);
            }
        });
    }

    public void postFlush(final HStore store, final HStoreFile storeFile, final FlushLifeCycleTracker tracker) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postFlush(this, store, storeFile, tracker);
            }
        });
    }

    public boolean preGet(final Get get, final List<Cell> results) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return false;
        }
        boolean bypassable = true;
        return this.execOperation(new RegionObserverOperationWithoutResult(bypassable){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preGetOp(this, get, results);
            }
        });
    }

    public void postGet(final Get get, final List<Cell> results) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postGetOp(this, get, results);
            }
        });
    }

    public Boolean preExists(final Get get) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preExists(this, get, (Boolean)this.getResult());
            }
        });
    }

    public boolean postExists(final Get get, boolean result) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return result;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(result)){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.postExists(this, get, (Boolean)this.getResult());
            }
        });
    }

    public boolean prePut(final Put put, final WALEdit edit, final Durability durability) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return false;
        }
        boolean bypassable = true;
        return this.execOperation(new RegionObserverOperationWithoutResult(bypassable){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.prePut(this, put, edit, durability);
            }
        });
    }

    @Deprecated
    public boolean prePrepareTimeStampForDeleteVersion(final Mutation mutation, final Cell kv, final byte[] byteNow, final Get get) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return false;
        }
        boolean bypassable = true;
        return this.execOperation(new RegionObserverOperationWithoutResult(bypassable){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.prePrepareTimeStampForDeleteVersion(this, mutation, kv, byteNow, get);
            }
        });
    }

    public void postPut(final Put put, final WALEdit edit, final Durability durability) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postPut(this, put, edit, durability);
            }
        });
    }

    public boolean preDelete(final Delete delete, final WALEdit edit, final Durability durability) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return false;
        }
        boolean bypassable = true;
        return this.execOperation(new RegionObserverOperationWithoutResult(bypassable){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preDelete(this, delete, edit, durability);
            }
        });
    }

    public void postDelete(final Delete delete, final WALEdit edit, final Durability durability) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postDelete(this, delete, edit, durability);
            }
        });
    }

    public void preBatchMutate(final MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preBatchMutate(this, miniBatchOp);
            }
        });
    }

    public void postBatchMutate(final MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postBatchMutate(this, miniBatchOp);
            }
        });
    }

    public void postBatchMutateIndispensably(final MiniBatchOperationInProgress<Mutation> miniBatchOp, final boolean success) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postBatchMutateIndispensably(this, miniBatchOp, success);
            }
        });
    }

    public Boolean preCheckAndPut(final byte[] row, final byte[] family, final byte[] qualifier, final CompareOperator op, final ByteArrayComparable comparator, final Put put) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preCheckAndPut(this, row, family, qualifier, op, comparator, put, (Boolean)this.getResult());
            }
        });
    }

    public Boolean preCheckAndPut(final byte[] row, final Filter filter, final Put put) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preCheckAndPut(this, row, filter, put, (Boolean)this.getResult());
            }
        });
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Null is legit")
    public Boolean preCheckAndPutAfterRowLock(final byte[] row, final byte[] family, final byte[] qualifier, final CompareOperator op, final ByteArrayComparable comparator, final Put put) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preCheckAndPutAfterRowLock(this, row, family, qualifier, op, comparator, put, (Boolean)this.getResult());
            }
        });
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Null is legit")
    public Boolean preCheckAndPutAfterRowLock(final byte[] row, final Filter filter, final Put put) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preCheckAndPutAfterRowLock(this, row, filter, put, (Boolean)this.getResult());
            }
        });
    }

    public boolean postCheckAndPut(final byte[] row, final byte[] family, final byte[] qualifier, final CompareOperator op, final ByteArrayComparable comparator, final Put put, boolean result) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return result;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(result)){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.postCheckAndPut(this, row, family, qualifier, op, comparator, put, (Boolean)this.getResult());
            }
        });
    }

    public boolean postCheckAndPut(final byte[] row, final Filter filter, final Put put, boolean result) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return result;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(result)){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.postCheckAndPut(this, row, filter, put, (Boolean)this.getResult());
            }
        });
    }

    public Boolean preCheckAndDelete(final byte[] row, final byte[] family, final byte[] qualifier, final CompareOperator op, final ByteArrayComparable comparator, final Delete delete) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preCheckAndDelete(this, row, family, qualifier, op, comparator, delete, (Boolean)this.getResult());
            }
        });
    }

    public Boolean preCheckAndDelete(final byte[] row, final Filter filter, final Delete delete) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preCheckAndDelete(this, row, filter, delete, (Boolean)this.getResult());
            }
        });
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Null is legit")
    public Boolean preCheckAndDeleteAfterRowLock(final byte[] row, final byte[] family, final byte[] qualifier, final CompareOperator op, final ByteArrayComparable comparator, final Delete delete) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preCheckAndDeleteAfterRowLock(this, row, family, qualifier, op, comparator, delete, (Boolean)this.getResult());
            }
        });
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Null is legit")
    public Boolean preCheckAndDeleteAfterRowLock(final byte[] row, final Filter filter, final Delete delete) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preCheckAndDeleteAfterRowLock(this, row, filter, delete, (Boolean)this.getResult());
            }
        });
    }

    public boolean postCheckAndDelete(final byte[] row, final byte[] family, final byte[] qualifier, final CompareOperator op, final ByteArrayComparable comparator, final Delete delete, boolean result) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return result;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(result)){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.postCheckAndDelete(this, row, family, qualifier, op, comparator, delete, (Boolean)this.getResult());
            }
        });
    }

    public boolean postCheckAndDelete(final byte[] row, final Filter filter, final Delete delete, boolean result) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return result;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(result)){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.postCheckAndDelete(this, row, filter, delete, (Boolean)this.getResult());
            }
        });
    }

    public Result preAppend(final Append append) throws IOException {
        boolean bypassable = true;
        Result defaultResult = null;
        if (this.coprocEnvironments.isEmpty()) {
            return defaultResult;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Result>(this.regionObserverGetter, defaultResult, bypassable){

            @Override
            public Result call(RegionObserver observer) throws IOException {
                return observer.preAppend(this, append);
            }
        });
    }

    public Result preAppendAfterRowLock(final Append append) throws IOException {
        boolean bypassable = true;
        Result defaultResult = null;
        if (this.coprocEnvironments.isEmpty()) {
            return defaultResult;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Result>(this.regionObserverGetter, defaultResult, bypassable){

            @Override
            public Result call(RegionObserver observer) throws IOException {
                return observer.preAppendAfterRowLock(this, append);
            }
        });
    }

    public Result preIncrement(final Increment increment) throws IOException {
        boolean bypassable = true;
        Result defaultResult = null;
        if (this.coprocEnvironments.isEmpty()) {
            return defaultResult;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Result>(this.regionObserverGetter, defaultResult, bypassable){

            @Override
            public Result call(RegionObserver observer) throws IOException {
                return observer.preIncrement(this, increment);
            }
        });
    }

    public Result preIncrementAfterRowLock(final Increment increment) throws IOException {
        boolean bypassable = true;
        Result defaultResult = null;
        if (this.coprocEnvironments.isEmpty()) {
            return defaultResult;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Result>(this.regionObserverGetter, defaultResult, bypassable){

            @Override
            public Result call(RegionObserver observer) throws IOException {
                return observer.preIncrementAfterRowLock(this, increment);
            }
        });
    }

    public Result postAppend(final Append append, final Result result) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return result;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Result>(this.regionObserverGetter, result){

            @Override
            public Result call(RegionObserver observer) throws IOException {
                return observer.postAppend(this, append, result);
            }
        });
    }

    public Result postIncrement(final Increment increment, Result result) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return result;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Result>(this.regionObserverGetter, result){

            @Override
            public Result call(RegionObserver observer) throws IOException {
                return observer.postIncrement(this, increment, (Result)this.getResult());
            }
        });
    }

    public void preScannerOpen(final Scan scan) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preScannerOpen(this, scan);
            }
        });
    }

    public RegionScanner postScannerOpen(final Scan scan, RegionScanner s) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return s;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, RegionScanner>(this.regionObserverGetter, s){

            @Override
            public RegionScanner call(RegionObserver observer) throws IOException {
                return observer.postScannerOpen(this, scan, (RegionScanner)this.getResult());
            }
        });
    }

    public Boolean preScannerNext(final InternalScanner s, final List<Result> results, final int limit) throws IOException {
        boolean bypassable = true;
        boolean defaultResult = false;
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult), bypassable){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.preScannerNext(this, s, results, limit, (Boolean)this.getResult());
            }
        });
    }

    public boolean postScannerNext(final InternalScanner s, final List<Result> results, final int limit, boolean hasMore) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return hasMore;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(hasMore)){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.postScannerNext(this, s, results, limit, (Boolean)this.getResult());
            }
        });
    }

    public boolean postScannerFilterRow(final InternalScanner s, final Cell curRowCell) throws IOException {
        boolean defaultResult = true;
        if (!this.hasCustomPostScannerFilterRow) {
            return defaultResult;
        }
        if (this.coprocEnvironments.isEmpty()) {
            return defaultResult;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, Boolean>(this.regionObserverGetter, Boolean.valueOf(defaultResult)){

            @Override
            public Boolean call(RegionObserver observer) throws IOException {
                return observer.postScannerFilterRow(this, s, curRowCell, (Boolean)this.getResult());
            }
        });
    }

    public boolean preScannerClose(final InternalScanner s) throws IOException {
        return this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(true){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preScannerClose(this, s);
            }
        });
    }

    public void postScannerClose(final InternalScanner s) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postScannerClose(this, s);
            }
        });
    }

    public ScanInfo preStoreScannerOpen(final HStore store, Scan scan) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return store.getScanInfo();
        }
        final CustomizedScanInfoBuilder builder = new CustomizedScanInfoBuilder(store.getScanInfo(), scan);
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preStoreScannerOpen(this, store, builder);
            }
        });
        return builder.build();
    }

    public void preReplayWALs(final RegionInfo info, final Path edits) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(true){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preReplayWALs(this, info, edits);
            }
        });
    }

    public void postReplayWALs(final RegionInfo info, final Path edits) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postReplayWALs(this, info, edits);
            }
        });
    }

    @Deprecated
    public boolean preWALRestore(final RegionInfo info, final WALKey logKey, final WALEdit logEdit) throws IOException {
        return this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(true){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preWALRestore(this, info, logKey, logEdit);
            }
        });
    }

    @Deprecated
    public void postWALRestore(final RegionInfo info, final WALKey logKey, final WALEdit logEdit) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postWALRestore(this, info, logKey, logEdit);
            }
        });
    }

    public void preBulkLoadHFile(final List<Pair<byte[], String>> familyPaths) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preBulkLoadHFile(this, familyPaths);
            }
        });
    }

    public boolean preCommitStoreFile(final byte[] family, final List<Pair<Path, Path>> pairs) throws IOException {
        return this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preCommitStoreFile(this, family, pairs);
            }
        });
    }

    public void postCommitStoreFile(final byte[] family, final Path srcPath, final Path dstPath) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postCommitStoreFile(this, family, srcPath, dstPath);
            }
        });
    }

    public void postBulkLoadHFile(final List<Pair<byte[], String>> familyPaths, final Map<byte[], List<Path>> map) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postBulkLoadHFile(this, familyPaths, map);
            }
        });
    }

    public void postStartRegionOperation(final Region.Operation op) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postStartRegionOperation(this, op);
            }
        });
    }

    public void postCloseRegionOperation(final Region.Operation op) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.postCloseRegionOperation(this, op);
            }
        });
    }

    public StoreFileReader preStoreFileReaderOpen(final FileSystem fs, final Path p, final FSDataInputStreamWrapper in, final long size, final CacheConfig cacheConf, final Reference r) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return null;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, StoreFileReader>(this.regionObserverGetter, null){

            @Override
            public StoreFileReader call(RegionObserver observer) throws IOException {
                return observer.preStoreFileReaderOpen(this, fs, p, in, size, cacheConf, r, (StoreFileReader)this.getResult());
            }
        });
    }

    public StoreFileReader postStoreFileReaderOpen(final FileSystem fs, final Path p, final FSDataInputStreamWrapper in, final long size, final CacheConfig cacheConf, final Reference r, StoreFileReader reader) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return reader;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, StoreFileReader>(this.regionObserverGetter, reader){

            @Override
            public StoreFileReader call(RegionObserver observer) throws IOException {
                return observer.postStoreFileReaderOpen(this, fs, p, in, size, cacheConf, r, (StoreFileReader)this.getResult());
            }
        });
    }

    public List<Pair<Cell, Cell>> postIncrementBeforeWAL(final Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return cellPairs;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, List<Pair<Cell, Cell>>>(this.regionObserverGetter, cellPairs){

            @Override
            public List<Pair<Cell, Cell>> call(RegionObserver observer) throws IOException {
                return observer.postIncrementBeforeWAL(this, mutation, (List)this.getResult());
            }
        });
    }

    public List<Pair<Cell, Cell>> postAppendBeforeWAL(final Mutation mutation, List<Pair<Cell, Cell>> cellPairs) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return cellPairs;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, List<Pair<Cell, Cell>>>(this.regionObserverGetter, cellPairs){

            @Override
            public List<Pair<Cell, Cell>> call(RegionObserver observer) throws IOException {
                return observer.postAppendBeforeWAL(this, mutation, (List)this.getResult());
            }
        });
    }

    public void preWALAppend(final WALKey key, final WALEdit edit) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new RegionObserverOperationWithoutResult(){

            @Override
            public void call(RegionObserver observer) throws IOException {
                observer.preWALAppend(this, key, edit);
            }
        });
    }

    public Message preEndpointInvocation(final Service service, final String methodName, Message request) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return request;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<EndpointObserver, Message>(this.endpointObserverGetter, request){

            @Override
            public Message call(EndpointObserver observer) throws IOException {
                return observer.preEndpointInvocation(this, service, methodName, (Message)this.getResult());
            }
        });
    }

    public void postEndpointInvocation(final Service service, final String methodName, final Message request, final Message.Builder responseBuilder) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new CoprocessorHost.ObserverOperationWithoutResult<EndpointObserver>(this.endpointObserverGetter){

            @Override
            public void call(EndpointObserver observer) throws IOException {
                observer.postEndpointInvocation(this, service, methodName, request, responseBuilder);
            }
        });
    }

    @Deprecated
    public DeleteTracker postInstantiateDeleteTracker(DeleteTracker result) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return result;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionObserver, DeleteTracker>(this.regionObserverGetter, result){

            @Override
            public DeleteTracker call(RegionObserver observer) throws IOException {
                return observer.postInstantiateDeleteTracker(this, (DeleteTracker)this.getResult());
            }
        });
    }

    public void prePrepareBulkLoad(User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new BulkLoadObserverOperation(user){

            @Override
            protected void call(BulkLoadObserver observer) throws IOException {
                observer.prePrepareBulkLoad(this);
            }
        });
    }

    public void preCleanupBulkLoad(User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new BulkLoadObserverOperation(user){

            @Override
            protected void call(BulkLoadObserver observer) throws IOException {
                observer.preCleanupBulkLoad(this);
            }
        });
    }

    abstract class BulkLoadObserverOperation
    extends CoprocessorHost.ObserverOperationWithoutResult<BulkLoadObserver> {
        public BulkLoadObserverOperation(User user) {
            super(RegionCoprocessor::getBulkLoadObserver, user);
        }
    }

    abstract class RegionObserverOperationWithoutResult
    extends CoprocessorHost.ObserverOperationWithoutResult<RegionObserver> {
        public RegionObserverOperationWithoutResult() {
            super(RegionCoprocessorHost.this.regionObserverGetter);
        }

        public RegionObserverOperationWithoutResult(User user) {
            super(RegionCoprocessorHost.this.regionObserverGetter, user);
        }

        public RegionObserverOperationWithoutResult(boolean bypassable) {
            super(RegionCoprocessorHost.this.regionObserverGetter, null, bypassable);
        }

        public RegionObserverOperationWithoutResult(User user, boolean bypassable) {
            super(RegionCoprocessorHost.this.regionObserverGetter, user, bypassable);
        }
    }

    static class TableCoprocessorAttribute {
        private Path path;
        private String className;
        private int priority;
        private Configuration conf;

        public TableCoprocessorAttribute(Path path, String className, int priority, Configuration conf) {
            this.path = path;
            this.className = className;
            this.priority = priority;
            this.conf = conf;
        }

        public Path getPath() {
            return this.path;
        }

        public String getClassName() {
            return this.className;
        }

        public int getPriority() {
            return this.priority;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }

    private static class RegionEnvironmentForCoreCoprocessors
    extends RegionEnvironment
    implements HasRegionServerServices {
        private final RegionServerServices rsServices;

        public RegionEnvironmentForCoreCoprocessors(RegionCoprocessor impl, int priority, int seq, Configuration conf, Region region, RegionServerServices services, ConcurrentMap<String, Object> sharedData) {
            super(impl, priority, seq, conf, region, services, sharedData);
            this.rsServices = services;
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.rsServices;
        }
    }

    private static class RegionEnvironment
    extends BaseEnvironment<RegionCoprocessor>
    implements RegionCoprocessorEnvironment {
        private Region region;
        ConcurrentMap<String, Object> sharedData;
        private final MetricRegistry metricRegistry;
        private final RegionServerServices services;

        public RegionEnvironment(RegionCoprocessor impl, int priority, int seq, Configuration conf, Region region, RegionServerServices services, ConcurrentMap<String, Object> sharedData) {
            super(impl, priority, seq, conf);
            this.region = region;
            this.sharedData = sharedData;
            this.services = services;
            this.metricRegistry = MetricsCoprocessor.createRegistryForRegionCoprocessor(impl.getClass().getName());
        }

        @Override
        public Region getRegion() {
            return this.region;
        }

        @Override
        public OnlineRegions getOnlineRegions() {
            return this.services;
        }

        @Override
        public Connection getConnection() {
            return this.services != null ? new SharedConnection(this.services.getConnection()) : null;
        }

        @Override
        public Connection createConnection(Configuration conf) throws IOException {
            return this.services != null ? this.services.createConnection(conf) : null;
        }

        @Override
        public ServerName getServerName() {
            return this.services != null ? this.services.getServerName() : null;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            MetricsCoprocessor.removeRegistry(this.metricRegistry);
        }

        @Override
        public ConcurrentMap<String, Object> getSharedData() {
            return this.sharedData;
        }

        @Override
        public RegionInfo getRegionInfo() {
            return this.region.getRegionInfo();
        }

        @Override
        public MetricRegistry getMetricRegistryForRegionServer() {
            return this.metricRegistry;
        }

        @Override
        public RawCellBuilder getCellBuilder() {
            return RawCellBuilderFactory.create();
        }
    }
}

