/*
 * Copyright 2014 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.xml;


/**
 * XML attributes, it is part of {@link XmlElement}
 */
public class XmlAttribute {

    private final String type;
    private final String name;
    private final String prefix;
    private final String namespace;
    private final String value;

    public XmlAttribute(String type, String name, String prefix, String namespace, String value) {
        this.type = type;
        this.name = name;
        this.prefix = prefix;
        this.namespace = namespace;
        this.value = value;
    }

    public String type() {
        return type;
    }

    public String name() {
        return name;
    }

    public String prefix() {
        return prefix;
    }

    public String namespace() {
        return namespace;
    }

    public String value() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) { return true; }
        if (o == null || getClass() != o.getClass()) { return false; }

        XmlAttribute that = (XmlAttribute) o;

        if (!name.equals(that.name)) { return false; }
        if (namespace != null ? !namespace.equals(that.namespace) : that.namespace != null) { return false; }
        if (prefix != null ? !prefix.equals(that.prefix) : that.prefix != null) { return false; }
        if (type != null ? !type.equals(that.type) : that.type != null) { return false; }
        if (value != null ? !value.equals(that.value) : that.value != null) { return false; }

        return true;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + name.hashCode();
        result = 31 * result + (prefix != null ? prefix.hashCode() : 0);
        result = 31 * result + (namespace != null ? namespace.hashCode() : 0);
        result = 31 * result + (value != null ? value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "XmlAttribute{" +
                "type='" + type + '\'' +
                ", name='" + name + '\'' +
                ", prefix='" + prefix + '\'' +
                ", namespace='" + namespace + '\'' +
                ", value='" + value + '\'' +
                '}';
    }
}
