/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeLoadBalancer;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.compute.ComputeTaskContinuousMapper;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.compute.gridify.GridifyArgument;
import org.apache.ignite.compute.gridify.GridifyNodeFilter;
import org.apache.ignite.internal.util.gridify.GridifyArgumentBuilder;
import org.apache.ignite.internal.util.gridify.GridifyJobAdapter;
import org.apache.ignite.internal.util.gridify.GridifyRangeArgument;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoadBalancerResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.resources.TaskContinuousMapperResource;
import org.apache.ignite.resources.TaskSessionResource;

public class GridifyDefaultRangeTask
extends ComputeTaskAdapter<GridifyRangeArgument, Collection<?>>
implements GridPeerDeployAware {
    private static final long serialVersionUID = 0L;
    private final transient Class<?> p2pCls;
    @IgniteInstanceResource
    private Ignite ignite;
    @TaskSessionResource
    private ComputeTaskSession ses;
    @LoggerResource
    private IgniteLogger log;
    @LoadBalancerResource
    private ComputeLoadBalancer balancer;
    @TaskContinuousMapperResource
    private ComputeTaskContinuousMapper mapper;
    private GridifyNodeFilter nodeFilter;
    private int splitSize;
    private int threshold;
    private boolean limitedSplit;

    public GridifyDefaultRangeTask(Class<?> cls, GridifyNodeFilter nodeFilter, int threshold, int splitSize, boolean limitedSplit) {
        assert (cls != null);
        this.p2pCls = cls;
        this.nodeFilter = nodeFilter;
        this.threshold = threshold;
        this.splitSize = splitSize;
        this.limitedSplit = limitedSplit;
    }

    @Override
    public Class<?> deployClass() {
        return this.p2pCls;
    }

    @Override
    public ClassLoader classLoader() {
        return U.detectClassLoader(this.p2pCls);
    }

    @Override
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, GridifyRangeArgument arg) {
        assert (!subgrid.isEmpty()) : "Subgrid should not be empty: " + subgrid;
        assert (this.ignite != null) : "Grid instance could not be injected";
        if (this.splitSize < this.threshold && this.splitSize != 0 && this.threshold != 0) {
            throw new IgniteException("Incorrect Gridify annotation parameters. Value for parameter 'splitSize' should not be less than parameter 'threshold' [splitSize=" + this.splitSize + ", threshold=" + this.threshold + ']');
        }
        LinkedList<ClusterNode> exclNodes = new LinkedList<ClusterNode>();
        if (this.nodeFilter != null) {
            for (ClusterNode node : subgrid) {
                if (this.nodeFilter.apply(node, this.ses)) continue;
                exclNodes.add(node);
            }
            if (exclNodes.size() == subgrid.size()) {
                throw new IgniteException("Failed to execute on grid where all nodes excluded.");
            }
        }
        int inputPerNode = this.splitSize;
        if (this.splitSize <= 0) {
            if (this.threshold > 0 && arg.getInputSize() == -1) {
                inputPerNode = this.threshold;
            } else {
                assert (arg.getInputSize() != -1);
                int gridSize = subgrid.size() - exclNodes.size();
                gridSize = gridSize <= 0 ? subgrid.size() : gridSize;
                inputPerNode = this.calculateInputSizePerNode(gridSize, arg.getInputSize(), this.threshold, this.limitedSplit);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Calculated input elements size per node [inputSize=" + arg.getInputSize() + ", gridSize=" + gridSize + ", threshold=" + this.threshold + ", limitedSplit=" + this.limitedSplit + ", inputPerNode=" + inputPerNode + ']');
                }
            }
        }
        GridifyArgumentBuilder argBuilder = new GridifyArgumentBuilder();
        Iterator<?> inputIter = arg.getInputIterator();
        while (inputIter.hasNext()) {
            LinkedList nodeInput = new LinkedList();
            for (int i = 0; i < inputPerNode && inputIter.hasNext(); ++i) {
                nodeInput.add(inputIter.next());
            }
            GridifyArgument jobArg = argBuilder.createJobArgument(arg, nodeInput);
            GridifyJobAdapter job = new GridifyJobAdapter(jobArg);
            this.mapper.send(job, this.balancer.getBalancedNode(job, exclNodes));
        }
        return null;
    }

    @Override
    public final Collection<?> reduce(List<ComputeJobResult> results) {
        assert (results.size() >= 1);
        ArrayList data = new ArrayList(results.size());
        for (ComputeJobResult res : results) {
            if (res.getException() != null) {
                throw res.getException();
            }
            data.add(res.getData());
        }
        return data;
    }

    private int calculateInputSizePerNode(int gridSize, int inputSize, int threshold, boolean limitedSplit) {
        if (threshold > 0) {
            assert (inputSize > threshold);
            int inputPerNode = (int)Math.ceil((double)inputSize / (double)gridSize);
            while (inputSize % inputPerNode <= threshold) {
                ++inputPerNode;
            }
            return inputPerNode;
        }
        if (limitedSplit && inputSize <= gridSize) {
            return inputSize;
        }
        int inputPerNode = (int)Math.ceil((double)inputSize / (double)gridSize);
        while (inputSize % inputPerNode == 1) {
            ++inputPerNode;
        }
        return inputPerNode;
    }
}

