/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.AddressResolver;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class BasicAddressResolver
implements AddressResolver {
    private final Map<InetAddress, InetAddress> inetAddrMap;
    private final Map<InetSocketAddress, InetSocketAddress> inetSockAddrMap;

    public BasicAddressResolver(Map<String, String> addrMap) throws UnknownHostException {
        if (addrMap == null || addrMap.isEmpty()) {
            throw new IllegalArgumentException("At least one address mapping is required.");
        }
        this.inetAddrMap = U.newHashMap(addrMap.size());
        this.inetSockAddrMap = U.newHashMap(addrMap.size());
        for (Map.Entry<String, String> e : addrMap.entrySet()) {
            String from = e.getKey();
            String to = e.getValue();
            if (F.isEmpty(from) || F.isEmpty(to)) {
                throw new IllegalArgumentException("Invalid address mapping: " + e);
            }
            String[] fromArr = from.split(":");
            String[] toArr = to.split(":");
            assert (fromArr.length > 0);
            assert (toArr.length > 0);
            if (fromArr.length == 1) {
                if (toArr.length != 1) {
                    throw new IllegalArgumentException("Invalid address mapping: " + e);
                }
                this.inetAddrMap.put(InetAddress.getByName(fromArr[0]), InetAddress.getByName(toArr[0]));
                continue;
            }
            if (fromArr.length == 2) {
                if (toArr.length != 2) {
                    throw new IllegalArgumentException("Invalid address mapping: " + e);
                }
                this.inetSockAddrMap.put(new InetSocketAddress(fromArr[0], Integer.parseInt(fromArr[1])), new InetSocketAddress(toArr[0], Integer.parseInt(toArr[1])));
                continue;
            }
            throw new IllegalArgumentException("Invalid address mapping: " + e);
        }
    }

    @Override
    public Collection<InetSocketAddress> getExternalAddresses(InetSocketAddress addr) throws IgniteCheckedException {
        InetSocketAddress inetSockAddr = this.inetSockAddrMap.get(addr);
        if (inetSockAddr != null) {
            return Collections.singletonList(inetSockAddr);
        }
        InetAddress inetAddr = this.inetAddrMap.get(addr.getAddress());
        if (inetAddr != null) {
            return Collections.singletonList(new InetSocketAddress(inetAddr, addr.getPort()));
        }
        return Collections.emptyList();
    }
}

