/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs.mapreduce.records;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.igfs.IgfsInputStream;
import org.apache.ignite.igfs.mapreduce.IgfsFileRange;
import org.apache.ignite.igfs.mapreduce.IgfsRecordResolver;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgfsFixedLengthRecordResolver
implements IgfsRecordResolver,
Externalizable {
    private static final long serialVersionUID = 0L;
    private long recLen;

    public IgfsFixedLengthRecordResolver() {
    }

    public IgfsFixedLengthRecordResolver(long recLen) {
        this.recLen = recLen;
    }

    @Override
    public IgfsFileRange resolveRecords(IgniteFileSystem fs, IgfsInputStream stream, IgfsFileRange suggestedRecord) throws IgniteException, IOException {
        long suggestedEnd = suggestedRecord.start() + suggestedRecord.length();
        long startRem = suggestedRecord.start() % this.recLen;
        long endRem = suggestedEnd % this.recLen;
        long start = Math.min(suggestedRecord.start() + (startRem != 0L ? this.recLen - startRem : 0L), stream.length());
        long end = Math.min(suggestedEnd + (endRem != 0L ? this.recLen - endRem : 0L), stream.length());
        assert (end >= start);
        return start != end ? new IgfsFileRange(suggestedRecord.path(), start, end - start) : null;
    }

    public String toString() {
        return S.toString(IgfsFixedLengthRecordResolver.class, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.recLen);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.recLen = in.readLong();
    }
}

