/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteState;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.Ignition;
import org.apache.ignite.IgnitionListener;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.ExecutorConfiguration;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.configuration.MemoryPolicyConfiguration;
import org.apache.ignite.configuration.PersistentStoreConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionMXBeanAdapter;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.igfs.IgfsThreadFactory;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.CA;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.logger.LoggerNodeIdAware;
import org.apache.ignite.logger.java.JavaLogger;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.mxbean.IgnitionMXBean;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.checkpoint.noop.NoopCheckpointSpi;
import org.apache.ignite.spi.collision.noop.NoopCollisionSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.deployment.local.LocalDeploymentSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.ignite.spi.eventstorage.NoopEventStorageSpi;
import org.apache.ignite.spi.failover.always.AlwaysFailoverSpi;
import org.apache.ignite.spi.indexing.noop.NoopIndexingSpi;
import org.apache.ignite.spi.loadbalancing.LoadBalancingSpi;
import org.apache.ignite.spi.loadbalancing.roundrobin.RoundRobinLoadBalancingSpi;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class IgnitionEx {
    public static final String DFLT_CFG = "config/default-config.xml";
    private static final ConcurrentMap<Object, IgniteNamedInstance> grids = new ConcurrentHashMap<Object, IgniteNamedInstance>();
    private static final Map<Object, IgniteState> gridStates = new ConcurrentHashMap<Object, IgniteState>();
    private static final Object dfltGridMux = new Object();
    private static volatile IgniteNamedInstance dfltGrid;
    private static volatile IgniteState dfltGridState;
    private static final Collection<IgnitionListener> lsnrs;
    private static ThreadLocal<Boolean> daemon;
    private static ThreadLocal<Boolean> clientMode;

    private IgnitionEx() {
    }

    public static void setDaemon(boolean daemon) {
        IgnitionEx.daemon.set(daemon);
    }

    public static boolean isDaemon() {
        return daemon.get();
    }

    public static void setClientMode(boolean clientMode) {
        IgnitionEx.clientMode.set(clientMode);
    }

    public static boolean isClientMode() {
        return clientMode.get() == null ? false : clientMode.get();
    }

    public static IgniteState state() {
        return IgnitionEx.state(null);
    }

    public static IgniteState state(@Nullable String name) {
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null) {
            IgniteState state = name != null ? gridStates.get(name) : dfltGridState;
            return state != null ? state : IgniteState.STOPPED;
        }
        return grid.state();
    }

    public static boolean stop(boolean cancel) {
        return IgnitionEx.stop(null, cancel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stop(@Nullable String name, boolean cancel, boolean stopNotStarted) {
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid != null && stopNotStarted && grid.startLatch.getCount() != 0L) {
            grid.starterThreadInterrupted = true;
            grid.starterThread.interrupt();
        }
        if (grid != null && grid.state() == IgniteState.STARTED) {
            boolean fireEvt;
            grid.stop(cancel);
            if (name != null) {
                fireEvt = grids.remove(name, grid);
            } else {
                Object object = dfltGridMux;
                synchronized (object) {
                    boolean bl = fireEvt = dfltGrid == grid;
                    if (fireEvt) {
                        dfltGrid = null;
                    }
                }
            }
            if (fireEvt) {
                IgnitionEx.notifyStateChange(grid.getName(), grid.state());
            }
            return true;
        }
        U.warn(null, "Ignoring stopping Ignite instance that was already stopped or never started: " + name);
        return false;
    }

    public static boolean stop(final @Nullable String name, boolean cancel, boolean stopNotStarted, final long timeoutMs) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.schedule(new Runnable(){

            @Override
            public void run() {
                if (IgnitionEx.state(name) == IgniteState.STARTED) {
                    U.error(null, "Unable to gracefully stop node within timeout " + timeoutMs + " milliseconds. Killing node...");
                    System.exit(130);
                }
            }
        }, timeoutMs, TimeUnit.MILLISECONDS);
        boolean success = IgnitionEx.stop(name, cancel, stopNotStarted);
        executor.shutdownNow();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll(boolean cancel) {
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null) {
            boolean fireEvt;
            dfltGrid0.stop(cancel);
            Object object = dfltGridMux;
            synchronized (object) {
                boolean bl = fireEvt = dfltGrid == dfltGrid0;
                if (fireEvt) {
                    dfltGrid = null;
                }
            }
            if (fireEvt) {
                IgnitionEx.notifyStateChange(dfltGrid0.getName(), dfltGrid0.state());
            }
        }
        for (IgniteNamedInstance grid : grids.values()) {
            grid.stop(cancel);
            boolean fireEvt = grids.remove(grid.getName(), grid);
            if (!fireEvt) continue;
            IgnitionEx.notifyStateChange(grid.getName(), grid.state());
        }
    }

    public static void restart(boolean cancel) {
        String file = System.getProperty("IGNITE_SUCCESS_FILE");
        if (file == null) {
            U.warn(null, "Cannot restart node when restart not enabled.");
        } else {
            try {
                new File(file).createNewFile();
            }
            catch (IOException e) {
                U.error(null, "Failed to create restart marker file (restart aborted): " + e.getMessage());
                return;
            }
            U.log(null, "Restarting node. Will exit (250).");
            System.setProperty("IGNITE_RESTART_CODE", Integer.toString(250));
            IgnitionEx.stopAll(cancel);
            System.exit(250);
        }
    }

    public static void kill(boolean cancel) {
        IgnitionEx.stopAll(cancel);
        System.exit(130);
    }

    public static Ignite start() throws IgniteCheckedException {
        return IgnitionEx.start((GridSpringResourceContext)null);
    }

    public static Ignite start(@Nullable GridSpringResourceContext springCtx) throws IgniteCheckedException {
        URL url = U.resolveIgniteUrl(DFLT_CFG);
        if (url != null) {
            return IgnitionEx.start(DFLT_CFG, null, springCtx, null);
        }
        U.warn(null, "Default Spring XML file not found (is IGNITE_HOME set?): config/default-config.xml");
        return ((IgniteNamedInstance)IgnitionEx.start0(new GridStartContext(new IgniteConfiguration(), null, springCtx), true).get1()).grid();
    }

    public static Ignite start(IgniteConfiguration cfg) throws IgniteCheckedException {
        return (Ignite)IgnitionEx.start(cfg, null, true).get1();
    }

    public static Ignite start(IgniteConfiguration cfg, boolean failIfStarted) throws IgniteCheckedException {
        return (Ignite)IgnitionEx.start(cfg, null, failIfStarted).get1();
    }

    public static T2<Ignite, Boolean> getOrStart(IgniteConfiguration cfg) throws IgniteException {
        try {
            return IgnitionEx.start(cfg, null, false);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static Ignite start(IgniteConfiguration cfg, @Nullable GridSpringResourceContext springCtx) throws IgniteCheckedException {
        A.notNull(cfg, "cfg");
        return ((IgniteNamedInstance)IgnitionEx.start0(new GridStartContext(cfg, null, springCtx), true).get1()).grid();
    }

    public static T2<Ignite, Boolean> start(IgniteConfiguration cfg, @Nullable GridSpringResourceContext springCtx, boolean failIfStarted) throws IgniteCheckedException {
        A.notNull(cfg, "cfg");
        T2<IgniteNamedInstance, Boolean> res = IgnitionEx.start0(new GridStartContext(cfg, null, springCtx), failIfStarted);
        return new T2<Ignite, Boolean>(((IgniteNamedInstance)res.get1()).grid(), (Boolean)res.get2());
    }

    public static Ignite start(@Nullable String springCfgPath) throws IgniteCheckedException {
        return springCfgPath == null ? IgnitionEx.start() : IgnitionEx.start(springCfgPath, null);
    }

    public static Ignite start(@Nullable String springCfgPath, @Nullable String igniteInstanceName) throws IgniteCheckedException {
        if (springCfgPath == null) {
            IgniteConfiguration cfg = new IgniteConfiguration();
            if (cfg.getIgniteInstanceName() == null && !F.isEmpty(igniteInstanceName)) {
                cfg.setIgniteInstanceName(igniteInstanceName);
            }
            return IgnitionEx.start(cfg);
        }
        return IgnitionEx.start(springCfgPath, igniteInstanceName, null, null);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(URL springCfgUrl) throws IgniteCheckedException {
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadConfigurations(springCfgUrl, new String[0]);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(InputStream springCfgStream) throws IgniteCheckedException {
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadConfigurations(springCfgStream, new String[0]);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(String springCfgPath) throws IgniteCheckedException {
        A.notNull(springCfgPath, "springCfgPath");
        return IgnitionEx.loadConfigurations(IgniteUtils.resolveSpringUrl(springCfgPath));
    }

    public static IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext> loadConfiguration(URL springCfgUrl) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> t = IgnitionEx.loadConfigurations(springCfgUrl);
        return F.t(F.first((Iterable)t.get1()), t.get2());
    }

    public static IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext> loadConfiguration(String springCfgPath) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> t = IgnitionEx.loadConfigurations(springCfgPath);
        return F.t(F.first((Iterable)t.get1()), t.get2());
    }

    public static Ignite start(String springCfgPath, @Nullable String igniteInstanceName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        URL url = U.resolveSpringUrl(springCfgPath);
        return IgnitionEx.start(url, igniteInstanceName, springCtx, ldr);
    }

    public static Ignite start(URL springCfgUrl) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgUrl, null, null, null);
    }

    public static Ignite start(URL springCfgUrl, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgUrl, null, null, ldr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ignite start(URL springCfgUrl, @Nullable String igniteInstanceName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap;
        A.notNull(springCfgUrl, "springCfgUrl");
        boolean isLog4jUsed = U.gridClassLoader().getResource("org/apache/log4j/Appender.class") != null;
        IgniteBiTuple<Object, Object> t = null;
        if (isLog4jUsed) {
            try {
                t = U.addLog4jNoOpLogger();
            }
            catch (IgniteCheckedException ignore) {
                isLog4jUsed = false;
            }
        }
        Collection<Handler> savedHnds = null;
        if (!isLog4jUsed) {
            savedHnds = U.addJavaNoOpLogger();
        }
        try {
            cfgMap = IgnitionEx.loadConfigurations(springCfgUrl);
        }
        finally {
            if (isLog4jUsed && t != null) {
                U.removeLog4jNoOpLogger(t);
            }
            if (!isLog4jUsed) {
                U.removeJavaNoOpLogger(savedHnds);
            }
        }
        return IgnitionEx.startConfigurations(cfgMap, springCfgUrl, igniteInstanceName, springCtx, ldr);
    }

    public static Ignite start(InputStream springCfgStream) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgStream, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ignite start(InputStream springCfgStream, @Nullable String igniteInstanceName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap;
        A.notNull(springCfgStream, "springCfgUrl");
        boolean isLog4jUsed = U.gridClassLoader().getResource("org/apache/log4j/Appender.class") != null;
        IgniteBiTuple<Object, Object> t = null;
        if (isLog4jUsed) {
            try {
                t = U.addLog4jNoOpLogger();
            }
            catch (IgniteCheckedException ignore) {
                isLog4jUsed = false;
            }
        }
        Collection<Handler> savedHnds = null;
        if (!isLog4jUsed) {
            savedHnds = U.addJavaNoOpLogger();
        }
        try {
            cfgMap = IgnitionEx.loadConfigurations(springCfgStream);
        }
        finally {
            if (isLog4jUsed && t != null) {
                U.removeLog4jNoOpLogger(t);
            }
            if (!isLog4jUsed) {
                U.removeJavaNoOpLogger(savedHnds);
            }
        }
        return IgnitionEx.startConfigurations(cfgMap, null, igniteInstanceName, springCtx, ldr);
    }

    private static Ignite startConfigurations(IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap, URL springCfgUrl, @Nullable String igniteInstanceName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        ArrayList<IgniteNamedInstance> grids = new ArrayList<IgniteNamedInstance>(cfgMap.size());
        try {
            for (IgniteConfiguration cfg : cfgMap.get1()) {
                IgniteNamedInstance grid;
                assert (cfg != null);
                if (cfg.getIgniteInstanceName() == null && !F.isEmpty(igniteInstanceName)) {
                    cfg.setIgniteInstanceName(igniteInstanceName);
                }
                if (ldr != null && cfg.getClassLoader() == null) {
                    cfg.setClassLoader(ldr);
                }
                if ((grid = (IgniteNamedInstance)IgnitionEx.start0(new GridStartContext(cfg, springCfgUrl, springCtx == null ? cfgMap.get2() : springCtx), true).get1()) == null) continue;
                grids.add(grid);
            }
        }
        catch (IgniteCheckedException e) {
            for (IgniteNamedInstance grid : grids) {
                try {
                    grid.stop(true);
                }
                catch (Exception e1) {
                    U.error(grid.log, "Error when stopping grid: " + grid, e1);
                }
            }
            throw e;
        }
        IgniteNamedInstance res = !grids.isEmpty() ? (IgniteNamedInstance)grids.get(0) : null;
        return res != null ? res.grid() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static T2<IgniteNamedInstance, Boolean> start0(GridStartContext startCtx, boolean failIfStarted) throws IgniteCheckedException {
        IgniteNamedInstance old;
        assert (startCtx != null);
        String name = startCtx.config().getIgniteInstanceName();
        if (name != null && name.isEmpty()) {
            throw new IgniteCheckedException("Non default Ignite instances cannot have empty string name.");
        }
        IgniteNamedInstance grid = new IgniteNamedInstance(name);
        if (name != null) {
            old = grids.putIfAbsent(name, grid);
        } else {
            Object object = dfltGridMux;
            synchronized (object) {
                old = dfltGrid;
                if (old == null) {
                    dfltGrid = grid;
                }
            }
        }
        if (old != null) {
            if (failIfStarted) {
                if (name == null) {
                    throw new IgniteCheckedException("Default Ignite instance has already been started.");
                }
                throw new IgniteCheckedException("Ignite instance with this name has already been started: " + name);
            }
            return new T2<IgniteNamedInstance, Boolean>(old, false);
        }
        if (startCtx.config().getWarmupClosure() != null) {
            startCtx.config().getWarmupClosure().apply(startCtx.config());
        }
        startCtx.single(grids.size() == 1);
        boolean success = false;
        try {
            try {
                grid.start(startCtx);
            }
            catch (IgniteInterruptedCheckedException e) {
                if (grid.starterThreadInterrupted) {
                    Thread.interrupted();
                }
                throw e;
            }
            IgnitionEx.notifyStateChange(name, IgniteState.STARTED);
            success = true;
        }
        finally {
            if (!success) {
                if (name != null) {
                    grids.remove(name, grid);
                } else {
                    Object object = dfltGridMux;
                    synchronized (object) {
                        if (dfltGrid == grid) {
                            dfltGrid = null;
                        }
                    }
                }
                grid = null;
            }
        }
        if (grid == null) {
            throw new IgniteCheckedException("Failed to start grid with provided configuration.");
        }
        return new T2<IgniteNamedInstance, Boolean>(grid, true);
    }

    public static <T> T loadSpringBean(String springXmlPath, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlPath, "springXmlPath");
        A.notNull(beanName, "beanName");
        URL url = U.resolveSpringUrl(springXmlPath);
        assert (url != null);
        return IgnitionEx.loadSpringBean(url, beanName);
    }

    public static <T> T loadSpringBean(URL springXmlUrl, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlUrl, "springXmlUrl");
        A.notNull(beanName, "beanName");
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadBean(springXmlUrl, beanName);
    }

    public static <T> T loadSpringBean(InputStream springXmlStream, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlStream, "springXmlPath");
        A.notNull(beanName, "beanName");
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadBean(springXmlStream, beanName);
    }

    public static Ignite grid() throws IgniteIllegalStateException {
        return IgnitionEx.grid((String)null);
    }

    public static List<Ignite> allGrids() {
        return IgnitionEx.allGrids(true);
    }

    public static List<Ignite> allGridsx() {
        return IgnitionEx.allGrids(false);
    }

    private static List<Ignite> allGrids(boolean wait) {
        ArrayList<Ignite> allIgnites = new ArrayList<Ignite>(grids.size() + 1);
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g = wait ? grid.grid() : grid.gridx();
            if (g == null) continue;
            allIgnites.add(g);
        }
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null) {
            IgniteKernal g;
            IgniteKernal igniteKernal = g = wait ? dfltGrid0.grid() : dfltGrid0.gridx();
            if (g != null) {
                allIgnites.add(g);
            }
        }
        return allIgnites;
    }

    public static Ignite grid(UUID locNodeId) throws IgniteIllegalStateException {
        IgniteKernal g;
        A.notNull(locNodeId, "locNodeId");
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null && (g = dfltGrid0.grid()) != null && g.getLocalNodeId().equals(locNodeId)) {
            return g;
        }
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g2 = grid.grid();
            if (g2 == null || !g2.getLocalNodeId().equals(locNodeId)) continue;
            return g2;
        }
        throw new IgniteIllegalStateException("Grid instance with given local node ID was not properly started or was stopped: " + locNodeId);
    }

    public static IgniteKernal gridxx(UUID locNodeId) {
        IgniteKernal g;
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null && (g = dfltGrid0.grid()) != null && g.getLocalNodeId().equals(locNodeId)) {
            return g;
        }
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g2 = grid.grid();
            if (g2 == null || !g2.getLocalNodeId().equals(locNodeId)) continue;
            return g2;
        }
        return null;
    }

    public static Ignite grid(@Nullable String name) throws IgniteIllegalStateException {
        IgniteKernal res;
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null || (res = grid.grid()) == null) {
            throw new IgniteIllegalStateException("Ignite instance with provided name doesn't exist. Did you call Ignition.start(..) to start an Ignite instance? [name=" + name + ']');
        }
        return res;
    }

    public static IgniteKernal localIgnite() throws IllegalArgumentException {
        String name = U.getCurrentIgniteName();
        if (U.isCurrentIgniteNameSet(name)) {
            return IgnitionEx.gridx(name);
        }
        if (Thread.currentThread() instanceof IgniteThread) {
            return IgnitionEx.gridx(((IgniteThread)Thread.currentThread()).getIgniteInstanceName());
        }
        throw new IllegalArgumentException("Ignite instance name thread local must be set or this method should be accessed under " + IgniteThread.class.getName());
    }

    public static IgniteKernal gridx(@Nullable String name) {
        IgniteKernal res;
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null || (res = grid.gridx()) == null) {
            throw new IgniteIllegalStateException("Ignite instance with provided name doesn't exist. Did you call Ignition.start(..) to start an Ignite instance? [name=" + name + ']');
        }
        return res;
    }

    public static void addListener(IgnitionListener lsnr) {
        A.notNull(lsnr, "lsnr");
        lsnrs.add(lsnr);
    }

    public static boolean removeListener(IgnitionListener lsnr) {
        A.notNull(lsnr, "lsnr");
        return lsnrs.remove(lsnr);
    }

    private static void notifyStateChange(@Nullable String igniteInstanceName, IgniteState state) {
        if (igniteInstanceName != null) {
            gridStates.put(igniteInstanceName, state);
        } else {
            dfltGridState = state;
        }
        for (IgnitionListener lsnr : lsnrs) {
            lsnr.onStateChange(igniteInstanceName, state);
        }
    }

    private static void convertLegacyDataStorageConfigurationToNew(IgniteConfiguration cfg) throws IgniteCheckedException {
        PersistentStoreConfiguration psCfg = cfg.getPersistentStoreConfiguration();
        boolean persistenceEnabled = psCfg != null;
        DataStorageConfiguration dsCfg = new DataStorageConfiguration();
        MemoryConfiguration memCfg = cfg.getMemoryConfiguration() != null ? cfg.getMemoryConfiguration() : new MemoryConfiguration();
        dsCfg.setConcurrencyLevel(memCfg.getConcurrencyLevel());
        dsCfg.setPageSize(memCfg.getPageSize());
        dsCfg.setSystemRegionInitialSize(memCfg.getSystemCacheInitialSize());
        dsCfg.setSystemRegionMaxSize(memCfg.getSystemCacheMaxSize());
        ArrayList<DataRegionConfiguration> optionalDataRegions = new ArrayList<DataRegionConfiguration>();
        boolean customDfltPlc = false;
        if (memCfg.getMemoryPolicies() != null) {
            for (MemoryPolicyConfiguration mpc : memCfg.getMemoryPolicies()) {
                DataRegionConfiguration region = new DataRegionConfiguration();
                region.setPersistenceEnabled(persistenceEnabled);
                if (mpc.getInitialSize() != 0L) {
                    region.setInitialSize(mpc.getInitialSize());
                }
                region.setEmptyPagesPoolSize(mpc.getEmptyPagesPoolSize());
                region.setEvictionThreshold(mpc.getEvictionThreshold());
                region.setMaxSize(mpc.getMaxSize());
                region.setName(mpc.getName());
                region.setPageEvictionMode(mpc.getPageEvictionMode());
                region.setMetricsRateTimeInterval(mpc.getRateTimeInterval());
                region.setMetricsSubIntervalCount(mpc.getSubIntervals());
                region.setSwapPath(mpc.getSwapFilePath());
                region.setMetricsEnabled(mpc.isMetricsEnabled());
                if (persistenceEnabled) {
                    region.setCheckpointPageBufferSize(psCfg.getCheckpointingPageBufferSize());
                }
                if (mpc.getName() == null) {
                    throw new IgniteCheckedException(new IllegalArgumentException("User-defined MemoryPolicyConfiguration must have non-null and non-empty name."));
                }
                if (mpc.getName().equals(memCfg.getDefaultMemoryPolicyName())) {
                    customDfltPlc = true;
                    dsCfg.setDefaultDataRegionConfiguration(region);
                    continue;
                }
                optionalDataRegions.add(region);
            }
        }
        if (!optionalDataRegions.isEmpty()) {
            dsCfg.setDataRegionConfigurations(optionalDataRegions.toArray(new DataRegionConfiguration[optionalDataRegions.size()]));
        }
        if (!customDfltPlc) {
            if (!"default".equals(memCfg.getDefaultMemoryPolicyName())) {
                throw new IgniteCheckedException(new IllegalArgumentException("User-defined default MemoryPolicy name must be presented among configured MemoryPolices: " + memCfg.getDefaultMemoryPolicyName()));
            }
            dsCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(memCfg.getDefaultMemoryPolicySize()).setName(memCfg.getDefaultMemoryPolicyName()).setPersistenceEnabled(persistenceEnabled));
        } else if (memCfg.getDefaultMemoryPolicySize() != MemoryConfiguration.DFLT_MEMORY_POLICY_MAX_SIZE) {
            throw new IgniteCheckedException(new IllegalArgumentException("User-defined MemoryPolicy configuration and defaultMemoryPolicySize properties are set at the same time."));
        }
        if (persistenceEnabled) {
            dsCfg.setCheckpointFrequency(psCfg.getCheckpointingFrequency());
            dsCfg.setCheckpointThreads(psCfg.getCheckpointingThreads());
            dsCfg.setCheckpointWriteOrder(psCfg.getCheckpointWriteOrder());
            dsCfg.setFileIOFactory(psCfg.getFileIOFactory());
            dsCfg.setLockWaitTime(psCfg.getLockWaitTime());
            dsCfg.setStoragePath(psCfg.getPersistentStorePath());
            dsCfg.setMetricsRateTimeInterval(psCfg.getRateTimeInterval());
            dsCfg.setMetricsSubIntervalCount(psCfg.getSubIntervals());
            dsCfg.setWalThreadLocalBufferSize(psCfg.getTlbSize());
            dsCfg.setWalArchivePath(psCfg.getWalArchivePath());
            dsCfg.setWalAutoArchiveAfterInactivity(psCfg.getWalAutoArchiveAfterInactivity());
            dsCfg.setWalFlushFrequency(psCfg.getWalFlushFrequency());
            dsCfg.setWalFsyncDelayNanos(psCfg.getWalFsyncDelayNanos());
            dsCfg.setWalHistorySize(psCfg.getWalHistorySize());
            dsCfg.setWalMode(psCfg.getWalMode());
            dsCfg.setWalRecordIteratorBufferSize(psCfg.getWalRecordIteratorBufferSize());
            dsCfg.setWalSegments(psCfg.getWalSegments());
            dsCfg.setWalSegmentSize(psCfg.getWalSegmentSize());
            dsCfg.setWalPath(psCfg.getWalStorePath());
            dsCfg.setAlwaysWriteFullPages(psCfg.isAlwaysWriteFullPages());
            dsCfg.setMetricsEnabled(psCfg.isMetricsEnabled());
            dsCfg.setWriteThrottlingEnabled(psCfg.isWriteThrottlingEnabled());
        }
        cfg.setDataStorageConfiguration(dsCfg);
    }

    static {
        lsnrs = new GridConcurrentHashSet<IgnitionListener>(4);
        daemon = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        clientMode = new ThreadLocal();
        int majorJavaVer = U.majorJavaVersion(U.jdkVersion());
        if (majorJavaVer < 7) {
            throw new IllegalStateException("Ignite requires Java 1.7.0_71 or above. Current Java version is not supported: " + U.jdkVersion());
        }
        String jreVer = U.jreVersion();
        if (jreVer.startsWith("1.7")) {
            int upd = jreVer.indexOf(95);
            int beta = jreVer.indexOf(45);
            if (beta < 0) {
                beta = jreVer.length();
            }
            if (upd > 0 && beta > 0) {
                try {
                    int update = Integer.parseInt(jreVer.substring(upd + 1, beta));
                    boolean forceJ7 = IgniteSystemProperties.getBoolean("IGNITE_FORCE_START_JAVA7", false);
                    if (update < 71 && !forceJ7) {
                        throw new IllegalStateException("Ignite requires Java 1.7.0_71 or above. Current Java version is not supported: " + jreVer);
                    }
                    if (forceJ7) {
                        System.err.println("Ignite requires Java 1.7.0_71 or above. Start on your own risk.");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        UUID.randomUUID();
    }

    private static final class IgniteNamedInstance {
        private static final Map<MBeanServer, GridMBeanServerData> mbeans = new HashMap<MBeanServer, GridMBeanServerData>();
        private static final String[] EMPTY_STR_ARR = new String[0];
        private final String name;
        private volatile IgniteKernal grid;
        private ThreadPoolExecutor execSvc;
        private ThreadPoolExecutor svcExecSvc;
        private ThreadPoolExecutor sysExecSvc;
        private StripedExecutor stripedExecSvc;
        private ThreadPoolExecutor mgmtExecSvc;
        private ThreadPoolExecutor p2pExecSvc;
        private ThreadPoolExecutor igfsExecSvc;
        private StripedExecutor dataStreamerExecSvc;
        private ThreadPoolExecutor restExecSvc;
        private ThreadPoolExecutor utilityCacheExecSvc;
        private ThreadPoolExecutor affExecSvc;
        private ThreadPoolExecutor idxExecSvc;
        private IgniteStripedThreadPoolExecutor callbackExecSvc;
        private ThreadPoolExecutor qryExecSvc;
        private ThreadPoolExecutor schemaExecSvc;
        private Map<String, ThreadPoolExecutor> customExecSvcs;
        private volatile IgniteState state = IgniteState.STOPPED;
        private Thread shutdownHook;
        private IgniteLogger log;
        private final AtomicBoolean startGuard = new AtomicBoolean();
        private final CountDownLatch startLatch = new CountDownLatch(1);
        private Thread starterThread;
        private boolean starterThreadInterrupted;

        IgniteNamedInstance(@Nullable String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        IgniteKernal grid() {
            if (this.starterThread != Thread.currentThread()) {
                U.awaitQuiet(this.startLatch);
            }
            return this.grid;
        }

        public IgniteKernal gridx() {
            return this.grid;
        }

        IgniteState state() {
            if (this.starterThread != Thread.currentThread()) {
                U.awaitQuiet(this.startLatch);
            }
            return this.state;
        }

        private void ensureMultiInstanceSupport(IgniteSpi spi) throws IgniteCheckedException {
            IgniteSpiMultipleInstancesSupport ann = U.getAnnotation(spi.getClass(), IgniteSpiMultipleInstancesSupport.class);
            if (ann == null || !ann.value()) {
                throw new IgniteCheckedException("SPI implementation doesn't support multiple grid instances in the same VM: " + spi);
            }
        }

        private void ensureMultiInstanceSupport(IgniteSpi[] spis) throws IgniteCheckedException {
            for (IgniteSpi spi : spis) {
                this.ensureMultiInstanceSupport(spi);
            }
        }

        synchronized void start(GridStartContext startCtx) throws IgniteCheckedException {
            if (this.startGuard.compareAndSet(false, true)) {
                try {
                    this.starterThread = Thread.currentThread();
                    this.start0(startCtx);
                }
                catch (Exception e) {
                    if (this.log != null) {
                        this.stopExecutors(this.log);
                    }
                    throw e;
                }
                finally {
                    this.startLatch.countDown();
                }
            } else {
                U.awaitQuiet(this.startLatch);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void start0(GridStartContext startCtx) throws IgniteCheckedException {
            assert (this.grid == null) : "Grid is already started: " + this.name;
            IgniteConfiguration cfg = startCtx.config() != null ? startCtx.config() : new IgniteConfiguration();
            IgniteConfiguration myCfg = this.initializeConfiguration(cfg);
            if (startCtx.configUrl() != null) {
                System.setProperty("IGNITE_CONFIG_URL", startCtx.configUrl().toString());
            }
            if (!startCtx.single()) {
                this.ensureMultiInstanceSupport(myCfg.getDeploymentSpi());
                this.ensureMultiInstanceSupport(myCfg.getCommunicationSpi());
                this.ensureMultiInstanceSupport(myCfg.getDiscoverySpi());
                this.ensureMultiInstanceSupport(myCfg.getCheckpointSpi());
                this.ensureMultiInstanceSupport(myCfg.getEventStorageSpi());
                this.ensureMultiInstanceSupport(myCfg.getCollisionSpi());
                this.ensureMultiInstanceSupport(myCfg.getFailoverSpi());
                this.ensureMultiInstanceSupport(myCfg.getLoadBalancingSpi());
            }
            IgniteNamedInstance.validateThreadPoolSize(cfg.getPublicThreadPoolSize(), "public");
            Thread.UncaughtExceptionHandler oomeHnd = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (grid != null && X.hasCause(e, OutOfMemoryError.class)) {
                        grid.context().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                    }
                }
            };
            this.execSvc = new IgniteThreadPoolExecutor("pub", cfg.getIgniteInstanceName(), cfg.getPublicThreadPoolSize(), cfg.getPublicThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), 0, oomeHnd);
            this.execSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getServiceThreadPoolSize(), "service");
            this.svcExecSvc = new IgniteThreadPoolExecutor("svc", cfg.getGridName(), cfg.getServiceThreadPoolSize(), cfg.getServiceThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), 11, oomeHnd);
            this.svcExecSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getSystemThreadPoolSize(), "system");
            this.sysExecSvc = new IgniteThreadPoolExecutor("sys", cfg.getIgniteInstanceName(), cfg.getSystemThreadPoolSize(), cfg.getSystemThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), 2, oomeHnd);
            this.sysExecSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getStripedPoolSize(), "stripedPool");
            this.stripedExecSvc = new StripedExecutor(cfg.getStripedPoolSize(), cfg.getIgniteInstanceName(), "sys", this.log, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable t) {
                    if (grid != null) {
                        grid.context().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, t));
                    }
                }
            });
            IgniteNamedInstance.validateThreadPoolSize(cfg.getManagementThreadPoolSize(), "management");
            this.mgmtExecSvc = new IgniteThreadPoolExecutor("mgmt", cfg.getIgniteInstanceName(), cfg.getManagementThreadPoolSize(), cfg.getManagementThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), 3, oomeHnd);
            this.mgmtExecSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getPeerClassLoadingThreadPoolSize(), "peer class loading");
            this.p2pExecSvc = new IgniteThreadPoolExecutor("p2p", cfg.getIgniteInstanceName(), cfg.getPeerClassLoadingThreadPoolSize(), cfg.getPeerClassLoadingThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), 1, oomeHnd);
            this.p2pExecSvc.allowCoreThreadTimeOut(true);
            this.dataStreamerExecSvc = new StripedExecutor(cfg.getDataStreamerThreadPoolSize(), cfg.getIgniteInstanceName(), "data-streamer", this.log, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable t) {
                    if (grid != null) {
                        grid.context().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, t));
                    }
                }
            }, true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getIgfsThreadPoolSize(), "IGFS");
            this.igfsExecSvc = new IgniteThreadPoolExecutor(cfg.getIgfsThreadPoolSize(), cfg.getIgfsThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), new IgfsThreadFactory(cfg.getIgniteInstanceName(), "igfs"));
            this.igfsExecSvc.allowCoreThreadTimeOut(true);
            IgniteNamedInstance.validateThreadPoolSize(cfg.getAsyncCallbackPoolSize(), "async callback");
            this.callbackExecSvc = new IgniteStripedThreadPoolExecutor(cfg.getAsyncCallbackPoolSize(), cfg.getIgniteInstanceName(), "callback", oomeHnd);
            if (myCfg.getConnectorConfiguration() != null) {
                IgniteNamedInstance.validateThreadPoolSize(myCfg.getConnectorConfiguration().getThreadPoolSize(), "connector");
                this.restExecSvc = new IgniteThreadPoolExecutor("rest", myCfg.getIgniteInstanceName(), myCfg.getConnectorConfiguration().getThreadPoolSize(), myCfg.getConnectorConfiguration().getThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), -1, oomeHnd);
                this.restExecSvc.allowCoreThreadTimeOut(true);
            }
            IgniteNamedInstance.validateThreadPoolSize(myCfg.getUtilityCacheThreadPoolSize(), "utility cache");
            this.utilityCacheExecSvc = new IgniteThreadPoolExecutor("utility", cfg.getIgniteInstanceName(), myCfg.getUtilityCacheThreadPoolSize(), myCfg.getUtilityCacheThreadPoolSize(), myCfg.getUtilityCacheKeepAliveTime(), new LinkedBlockingQueue<Runnable>(), 5, oomeHnd);
            this.utilityCacheExecSvc.allowCoreThreadTimeOut(true);
            this.affExecSvc = new IgniteThreadPoolExecutor("aff", cfg.getIgniteInstanceName(), 1, 1, 60000L, new LinkedBlockingQueue<Runnable>(), 4, oomeHnd);
            this.affExecSvc.allowCoreThreadTimeOut(true);
            if (IgniteComponentType.INDEXING.inClassPath()) {
                int cpus = Runtime.getRuntime().availableProcessors();
                this.idxExecSvc = new IgniteThreadPoolExecutor("idx", cfg.getIgniteInstanceName(), cpus, cpus * 2, 3000L, new LinkedBlockingQueue<Runnable>(1000), 7, oomeHnd);
            }
            IgniteNamedInstance.validateThreadPoolSize(cfg.getQueryThreadPoolSize(), "query");
            this.qryExecSvc = new IgniteThreadPoolExecutor("query", cfg.getIgniteInstanceName(), cfg.getQueryThreadPoolSize(), cfg.getQueryThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), 10, oomeHnd);
            this.qryExecSvc.allowCoreThreadTimeOut(true);
            this.schemaExecSvc = new IgniteThreadPoolExecutor("schema", cfg.getIgniteInstanceName(), 2, 2, 60000L, new LinkedBlockingQueue<Runnable>(), 12, oomeHnd);
            this.schemaExecSvc.allowCoreThreadTimeOut(true);
            if (!F.isEmpty(cfg.getExecutorConfiguration())) {
                IgniteNamedInstance.validateCustomExecutorsConfiguration(cfg.getExecutorConfiguration());
                this.customExecSvcs = new HashMap<String, ThreadPoolExecutor>();
                for (ExecutorConfiguration execCfg : cfg.getExecutorConfiguration()) {
                    IgniteThreadPoolExecutor exec = new IgniteThreadPoolExecutor(execCfg.getName(), cfg.getIgniteInstanceName(), execCfg.getSize(), execCfg.getSize(), 60000L, new LinkedBlockingQueue<Runnable>(), -1, oomeHnd);
                    this.customExecSvcs.put(execCfg.getName(), exec);
                }
            }
            this.registerFactoryMbean(myCfg.getMBeanServer());
            boolean started = false;
            try {
                IgniteKernal grid0;
                this.grid = grid0 = new IgniteKernal(startCtx.springContext());
                grid0.start(myCfg, this.utilityCacheExecSvc, this.execSvc, this.svcExecSvc, this.sysExecSvc, this.stripedExecSvc, this.p2pExecSvc, this.mgmtExecSvc, this.igfsExecSvc, this.dataStreamerExecSvc, this.restExecSvc, this.affExecSvc, this.idxExecSvc, this.callbackExecSvc, this.qryExecSvc, this.schemaExecSvc, this.customExecSvcs, new CA(){

                    @Override
                    public void apply() {
                        startLatch.countDown();
                    }
                });
                this.state = IgniteState.STARTED;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Grid factory started ok: " + this.name);
                }
                started = true;
            }
            catch (IgniteCheckedException e) {
                this.unregisterFactoryMBean();
                throw e;
            }
            catch (Throwable e) {
                this.unregisterFactoryMBean();
                if (!(e instanceof Error)) throw new IgniteCheckedException("Unexpected exception when starting grid.", e);
                throw e;
            }
            finally {
                if (!started) {
                    this.grid = null;
                }
            }
            if (!IgniteSystemProperties.getBoolean("IGNITE_NO_SHUTDOWN_HOOK", false)) {
                try {
                    this.shutdownHook = new Thread(){

                        @Override
                        public void run() {
                            if (log.isInfoEnabled()) {
                                log.info("Invoking shutdown hook...");
                            }
                            this.stop(true);
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug("Shutdown hook is installed.");
                    return;
                }
                catch (IllegalStateException e) {
                    this.stop(true);
                    throw new IgniteCheckedException("Failed to install shutdown hook.", e);
                }
            } else {
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Shutdown hook has not been installed because environment or system property IGNITE_NO_SHUTDOWN_HOOK is set.");
            }
        }

        private static void validateThreadPoolSize(int poolSize, String poolName) throws IgniteCheckedException {
            if (poolSize <= 0) {
                throw new IgniteCheckedException("Invalid " + poolName + " thread pool size" + " (must be greater than 0), actual value: " + poolSize);
            }
        }

        private static void validateCustomExecutorsConfiguration(ExecutorConfiguration[] cfgs) throws IgniteCheckedException {
            if (cfgs == null) {
                return;
            }
            HashSet<String> names = new HashSet<String>(cfgs.length);
            for (ExecutorConfiguration cfg : cfgs) {
                if (F.isEmpty(cfg.getName())) {
                    throw new IgniteCheckedException("Custom executor name cannot be null or empty.");
                }
                if (!names.add(cfg.getName())) {
                    throw new IgniteCheckedException("Duplicate custom executor name: " + cfg.getName());
                }
                if (cfg.getSize() > 0) continue;
                throw new IgniteCheckedException("Custom executor size must be positive [name=" + cfg.getName() + ", size=" + cfg.getSize() + ']');
            }
        }

        private IgniteConfiguration initializeConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
            FileSystemConfiguration[] igfsCfgs;
            Marshaller marsh;
            String depModeName;
            File ggHomeFile;
            IgniteConfiguration myCfg = new IgniteConfiguration(cfg);
            String ggHome = cfg.getIgniteHome();
            if (ggHome == null) {
                ggHome = U.getIgniteHome();
            } else {
                U.setIgniteHome(ggHome);
            }
            String workDir = U.workDirectory(cfg.getWorkDirectory(), ggHome);
            myCfg.setWorkDirectory(workDir);
            assert (F.eq(this.name, cfg.getIgniteInstanceName()));
            UUID nodeId = cfg.getNodeId() != null ? cfg.getNodeId() : UUID.randomUUID();
            myCfg.setNodeId(nodeId);
            IgniteLogger cfgLog = this.initLogger(cfg.getGridLogger(), nodeId, workDir);
            assert (cfgLog != null);
            cfgLog = new GridLoggerProxy(cfgLog, null, this.name, U.id8(nodeId));
            this.log = cfgLog.getLogger(G.class);
            myCfg.setGridLogger(cfgLog);
            if (!(ggHome == null || (ggHomeFile = new File(ggHome)).exists() && ggHomeFile.isDirectory())) {
                throw new IgniteCheckedException("Invalid Ignite installation home folder: " + ggHome);
            }
            myCfg.setIgniteHome(ggHome);
            SegmentationPolicy segPlc = cfg.getSegmentationPolicy();
            if (!F.isEmpty(cfg.getSegmentationResolvers()) && segPlc == SegmentationPolicy.RESTART_JVM && !cfg.isWaitForSegmentOnStart()) {
                U.warn(this.log, "Found potential configuration problem (forgot to enable waiting for segmenton start?) [segPlc=" + (Object)((Object)segPlc) + ", wait=false]");
            }
            myCfg.setTransactionConfiguration(myCfg.getTransactionConfiguration() != null ? new TransactionConfiguration(myCfg.getTransactionConfiguration()) : null);
            myCfg.setConnectorConfiguration(myCfg.getConnectorConfiguration() != null ? new ConnectorConfiguration(myCfg.getConnectorConfiguration()) : null);
            String locHost = IgniteSystemProperties.getString("IGNITE_LOCAL_HOST");
            myCfg.setLocalHost(F.isEmpty(locHost) ? myCfg.getLocalHost() : locHost);
            if (((Boolean)daemon.get()).booleanValue()) {
                myCfg.setDaemon(true);
            }
            if (myCfg.isClientMode() == null) {
                Boolean threadClient = (Boolean)clientMode.get();
                if (threadClient == null) {
                    myCfg.setClientMode(IgniteSystemProperties.getBoolean("IGNITE_CACHE_CLIENT", false));
                } else {
                    myCfg.setClientMode(threadClient);
                }
            }
            if (!F.isEmpty(depModeName = IgniteSystemProperties.getString("IGNITE_DEPLOYMENT_MODE_OVERRIDE"))) {
                if (!F.isEmpty(myCfg.getCacheConfiguration())) {
                    U.quietAndInfo(this.log, "Skipping deployment mode override for caches (custom closure execution may not work for console Visor)");
                } else {
                    try {
                        DeploymentMode depMode = DeploymentMode.valueOf(depModeName);
                        if (myCfg.getDeploymentMode() != depMode) {
                            myCfg.setDeploymentMode(depMode);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new IgniteCheckedException("Failed to override deployment mode using system property (are there any misspellings?)[name=IGNITE_DEPLOYMENT_MODE_OVERRIDE, value=" + depModeName + ']', e);
                    }
                }
            }
            if (myCfg.getUserAttributes() == null) {
                myCfg.setUserAttributes(Collections.emptyMap());
            }
            if (myCfg.getMBeanServer() == null && !U.IGNITE_MBEANS_DISABLED) {
                myCfg.setMBeanServer(ManagementFactory.getPlatformMBeanServer());
            }
            if ((marsh = myCfg.getMarshaller()) == null) {
                if (!BinaryMarshaller.available()) {
                    U.warn(this.log, "OptimizedMarshaller is not supported on this JVM (only recent 1.6 and 1.7 versions HotSpot VMs are supported). To enable fast marshalling upgrade to recent 1.6 or 1.7 HotSpot VM release. Switching to standard JDK marshalling - object serialization performance will be significantly slower.", "To enable fast marshalling upgrade to recent 1.6 or 1.7 HotSpot VM release.");
                    marsh = new JdkMarshaller();
                } else {
                    marsh = new BinaryMarshaller();
                }
            }
            MarshallerUtils.setNodeName(marsh, cfg.getIgniteInstanceName());
            myCfg.setMarshaller(marsh);
            if (myCfg.getPeerClassLoadingLocalClassPathExclude() == null) {
                myCfg.setPeerClassLoadingLocalClassPathExclude(EMPTY_STR_ARR);
            }
            if ((igfsCfgs = myCfg.getFileSystemConfiguration()) != null) {
                FileSystemConfiguration[] clone = (FileSystemConfiguration[])igfsCfgs.clone();
                for (int i = 0; i < igfsCfgs.length; ++i) {
                    clone[i] = new FileSystemConfiguration(igfsCfgs[i]);
                }
                myCfg.setFileSystemConfiguration(clone);
            }
            this.initializeDefaultSpi(myCfg);
            GridDiscoveryManager.initCommunicationErrorResolveConfiguration(myCfg);
            this.initializeDefaultCacheConfiguration(myCfg);
            ExecutorConfiguration[] execCfgs = myCfg.getExecutorConfiguration();
            if (execCfgs != null) {
                ExecutorConfiguration[] clone = (ExecutorConfiguration[])execCfgs.clone();
                for (int i = 0; i < execCfgs.length; ++i) {
                    clone[i] = new ExecutorConfiguration(execCfgs[i]);
                }
                myCfg.setExecutorConfiguration(clone);
            }
            this.initializeDataStorageConfiguration(myCfg);
            return myCfg;
        }

        private void initializeDataStorageConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
            if (cfg.getDataStorageConfiguration() != null && (cfg.getMemoryConfiguration() != null || cfg.getPersistentStoreConfiguration() != null)) {
                throw new IgniteCheckedException("Data storage can be configured with either legacy (MemoryConfiguration, PersistentStoreConfiguration) or new (DataStorageConfiguration) classes, but not both.");
            }
            if (cfg.getMemoryConfiguration() != null || cfg.getPersistentStoreConfiguration() != null) {
                IgnitionEx.convertLegacyDataStorageConfigurationToNew(cfg);
            }
            if (!cfg.isClientMode().booleanValue() && cfg.getDataStorageConfiguration() == null) {
                cfg.setDataStorageConfiguration(new DataStorageConfiguration());
            }
        }

        public void initializeDefaultCacheConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
            CacheConfiguration[] userCaches;
            ArrayList<CacheConfiguration> cacheCfgs = new ArrayList<CacheConfiguration>();
            cacheCfgs.add(IgniteNamedInstance.utilitySystemCache());
            if (IgniteComponentType.HADOOP.inClassPath()) {
                cacheCfgs.add(CU.hadoopSystemCache());
            }
            if ((userCaches = cfg.getCacheConfiguration()) != null && userCaches.length > 0) {
                if (!U.discoOrdered(cfg.getDiscoverySpi()) && !U.relaxDiscoveryOrdered()) {
                    throw new IgniteCheckedException("Discovery SPI implementation does not support node ordering and cannot be used with cache (use SPI with @DiscoverySpiOrderSupport annotation, like TcpDiscoverySpi)");
                }
                for (CacheConfiguration ccfg : userCaches) {
                    if (CU.isHadoopSystemCache(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"ignite-hadoop-mr-sys-cache\" because it is reserved for internal purposes.");
                    }
                    if (CU.isUtilityCache(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"ignite-sys-cache\" because it is reserved for internal purposes.");
                    }
                    if (IgfsUtils.matchIgfsCacheName(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot start with \"igfs-internal-\" because it is reserved for IGFS internal purposes.");
                    }
                    if (DataStructuresProcessor.isDataStructureCache(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"" + ccfg.getName() + "\" because it is reserved for data structures.");
                    }
                    cacheCfgs.add(ccfg);
                }
            }
            cfg.setCacheConfiguration(cacheCfgs.toArray(new CacheConfiguration[cacheCfgs.size()]));
            assert (cfg.getCacheConfiguration() != null);
            IgfsUtils.prepareCacheConfigurations(cfg);
        }

        private void initializeDefaultSpi(IgniteConfiguration cfg) {
            TcpDiscoverySpi tcpDisco;
            if (cfg.getDiscoverySpi() == null) {
                cfg.setDiscoverySpi(new TcpDiscoverySpi());
            }
            if (cfg.getDiscoverySpi() instanceof TcpDiscoverySpi && (tcpDisco = (TcpDiscoverySpi)cfg.getDiscoverySpi()).getIpFinder() == null) {
                tcpDisco.setIpFinder(new TcpDiscoveryMulticastIpFinder());
            }
            if (cfg.getCommunicationSpi() == null) {
                cfg.setCommunicationSpi(new TcpCommunicationSpi());
            }
            if (cfg.getDeploymentSpi() == null) {
                cfg.setDeploymentSpi(new LocalDeploymentSpi());
            }
            if (cfg.getEventStorageSpi() == null) {
                cfg.setEventStorageSpi(new NoopEventStorageSpi());
            }
            if (cfg.getCheckpointSpi() == null) {
                cfg.setCheckpointSpi(new NoopCheckpointSpi());
            }
            if (cfg.getCollisionSpi() == null) {
                cfg.setCollisionSpi(new NoopCollisionSpi());
            }
            if (cfg.getFailoverSpi() == null) {
                cfg.setFailoverSpi(new AlwaysFailoverSpi());
            }
            if (cfg.getLoadBalancingSpi() == null) {
                cfg.setLoadBalancingSpi(new RoundRobinLoadBalancingSpi());
            } else {
                ArrayList<LoadBalancingSpi> spis = new ArrayList<LoadBalancingSpi>();
                boolean dfltLoadBalancingSpi = false;
                for (LoadBalancingSpi spi : cfg.getLoadBalancingSpi()) {
                    spis.add(spi);
                    if (dfltLoadBalancingSpi || !(spi instanceof RoundRobinLoadBalancingSpi)) continue;
                    dfltLoadBalancingSpi = true;
                }
                if (!dfltLoadBalancingSpi) {
                    spis.add(new RoundRobinLoadBalancingSpi());
                }
                cfg.setLoadBalancingSpi(spis.toArray(new LoadBalancingSpi[spis.size()]));
            }
            if (cfg.getIndexingSpi() == null) {
                cfg.setIndexingSpi(new NoopIndexingSpi());
            }
        }

        private IgniteLogger initLogger(@Nullable IgniteLogger cfgLog, UUID nodeId, String workDir) throws IgniteCheckedException {
            try {
                Exception log4jInitErr = null;
                if (cfgLog == null) {
                    Class<?> log4jCls;
                    try {
                        log4jCls = Class.forName("org.apache.ignite.logger.log4j.Log4JLogger");
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError ignored) {
                        log4jCls = null;
                    }
                    if (log4jCls != null) {
                        try {
                            boolean configured;
                            URL url = U.resolveIgniteUrl("config/ignite-log4j.xml");
                            if (url == null) {
                                File cfgFile = new File("config/ignite-log4j.xml");
                                if (!cfgFile.exists()) {
                                    cfgFile = new File("../config/ignite-log4j.xml");
                                }
                                if (cfgFile.exists()) {
                                    try {
                                        url = cfgFile.toURI().toURL();
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (url != null && (configured = ((Boolean)log4jCls.getMethod("isConfigured", new Class[0]).invoke(null, new Object[0])).booleanValue())) {
                                url = null;
                            }
                            if (url != null) {
                                Constructor<?> ctor = log4jCls.getConstructor(URL.class);
                                cfgLog = (IgniteLogger)ctor.newInstance(url);
                            } else {
                                cfgLog = (IgniteLogger)log4jCls.newInstance();
                            }
                        }
                        catch (Exception e) {
                            log4jInitErr = e;
                        }
                    }
                    if (log4jCls == null || log4jInitErr != null) {
                        cfgLog = new JavaLogger();
                    }
                }
                if (cfgLog instanceof JavaLogger) {
                    ((JavaLogger)cfgLog).setWorkDirectory(workDir);
                }
                if (cfgLog instanceof LoggerNodeIdAware) {
                    ((LoggerNodeIdAware)((Object)cfgLog)).setNodeId(nodeId);
                }
                if (log4jInitErr != null) {
                    U.warn(cfgLog, "Failed to initialize Log4JLogger (falling back to standard java logging): " + log4jInitErr.getCause());
                }
                return cfgLog;
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to create logger.", e);
            }
        }

        private static CacheConfiguration utilitySystemCache() {
            CacheConfiguration cache = new CacheConfiguration();
            cache.setName("ignite-sys-cache");
            cache.setCacheMode(CacheMode.REPLICATED);
            cache.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            cache.setRebalanceMode(CacheRebalanceMode.SYNC);
            cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            cache.setAffinity(new RendezvousAffinityFunction(false, 100));
            cache.setNodeFilter(CacheConfiguration.ALL_NODES);
            cache.setRebalanceOrder(-2);
            cache.setCopyOnRead(false);
            return cache;
        }

        void stop(boolean cancel) {
            assert (this.startGuard.get());
            this.stop0(cancel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void stop0(boolean cancel) {
            IgniteKernal grid0;
            block15: {
                grid0 = this.grid;
                if (grid0 == null) {
                    if (this.log != null) {
                        U.warn(this.log, "Attempting to stop an already stopped Ignite instance (ignore): " + this.name);
                    }
                    return;
                }
                if (this.shutdownHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                        this.shutdownHook = null;
                        if (this.log != null && this.log.isDebugEnabled()) {
                            this.log.debug("Shutdown hook is removed.");
                        }
                    }
                    catch (IllegalStateException e) {
                        if (this.log == null || !this.log.isDebugEnabled()) break block15;
                        this.log.debug("Shutdown is in progress (ignoring): " + e.getMessage());
                    }
                }
            }
            this.unregisterFactoryMBean();
            try {
                FailureContext failure;
                grid0.stop(cancel);
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug("Ignite instance stopped ok: " + this.name);
                }
                this.state = !grid0.context().invalid() ? IgniteState.STOPPED : ((failure = grid0.context().failure().failureContext()).type() == FailureType.SEGMENTATION ? IgniteState.STOPPED_ON_SEGMENTATION : IgniteState.STOPPED_ON_FAILURE);
            }
            catch (Throwable e) {
                try {
                    FailureContext failure;
                    U.error(this.log, "Failed to properly stop grid instance due to undeclared exception.", e);
                    if (e instanceof Error) {
                        throw e;
                    }
                    this.state = !grid0.context().invalid() ? IgniteState.STOPPED : ((failure = grid0.context().failure().failureContext()).type() == FailureType.SEGMENTATION ? IgniteState.STOPPED_ON_SEGMENTATION : IgniteState.STOPPED_ON_FAILURE);
                }
                catch (Throwable throwable) {
                    FailureContext failure;
                    this.state = !grid0.context().invalid() ? IgniteState.STOPPED : ((failure = grid0.context().failure().failureContext()).type() == FailureType.SEGMENTATION ? IgniteState.STOPPED_ON_SEGMENTATION : IgniteState.STOPPED_ON_FAILURE);
                    this.grid = null;
                    if (this.log != null) {
                        this.stopExecutors(this.log);
                    }
                    this.log = null;
                    throw throwable;
                }
                this.grid = null;
                if (this.log != null) {
                    this.stopExecutors(this.log);
                }
                this.log = null;
            }
            this.grid = null;
            if (this.log != null) {
                this.stopExecutors(this.log);
            }
            this.log = null;
        }

        private void stopExecutors(IgniteLogger log) {
            boolean interrupted = Thread.interrupted();
            try {
                this.stopExecutors0(log);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void stopExecutors0(IgniteLogger log) {
            assert (log != null);
            U.shutdownNow(this.getClass(), this.execSvc, log);
            this.execSvc = null;
            U.shutdownNow(this.getClass(), this.sysExecSvc, log);
            this.sysExecSvc = null;
            U.shutdownNow(this.getClass(), this.qryExecSvc, log);
            this.qryExecSvc = null;
            U.shutdownNow(this.getClass(), this.schemaExecSvc, log);
            this.schemaExecSvc = null;
            U.shutdownNow(this.getClass(), this.stripedExecSvc, log);
            this.stripedExecSvc = null;
            U.shutdownNow(this.getClass(), this.mgmtExecSvc, log);
            this.mgmtExecSvc = null;
            U.shutdownNow(this.getClass(), this.p2pExecSvc, log);
            this.p2pExecSvc = null;
            U.shutdownNow(this.getClass(), this.dataStreamerExecSvc, log);
            this.dataStreamerExecSvc = null;
            U.shutdownNow(this.getClass(), this.igfsExecSvc, log);
            this.igfsExecSvc = null;
            if (this.restExecSvc != null) {
                U.shutdownNow(this.getClass(), this.restExecSvc, log);
            }
            this.restExecSvc = null;
            U.shutdownNow(this.getClass(), this.utilityCacheExecSvc, log);
            this.utilityCacheExecSvc = null;
            U.shutdownNow(this.getClass(), this.affExecSvc, log);
            this.affExecSvc = null;
            U.shutdownNow(this.getClass(), this.idxExecSvc, log);
            this.idxExecSvc = null;
            U.shutdownNow(this.getClass(), this.callbackExecSvc, log);
            this.callbackExecSvc = null;
            if (!F.isEmpty(this.customExecSvcs)) {
                for (ThreadPoolExecutor exec : this.customExecSvcs.values()) {
                    U.shutdownNow(this.getClass(), exec, log);
                }
                this.customExecSvcs = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerFactoryMbean(MBeanServer srv) throws IgniteCheckedException {
            if (U.IGNITE_MBEANS_DISABLED) {
                return;
            }
            assert (srv != null);
            Map<MBeanServer, GridMBeanServerData> map = mbeans;
            synchronized (map) {
                GridMBeanServerData data = mbeans.get(srv);
                if (data == null) {
                    try {
                        IgnitionMXBeanAdapter mbean = new IgnitionMXBeanAdapter();
                        ObjectName objName = U.makeMBeanName(null, "Kernal", Ignition.class.getSimpleName());
                        if (!srv.queryMBeans(objName, null).isEmpty()) {
                            throw new IgniteCheckedException("MBean was already registered: " + objName);
                        }
                        objName = U.registerMBean(srv, null, "Kernal", Ignition.class.getSimpleName(), mbean, IgnitionMXBean.class);
                        data = new GridMBeanServerData(objName);
                        mbeans.put(srv, data);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Registered MBean: " + objName);
                        }
                    }
                    catch (JMException e) {
                        throw new IgniteCheckedException("Failed to register MBean.", e);
                    }
                }
                assert (data != null);
                data.addIgniteInstance(this.name);
                data.setCounter(data.getCounter() + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterFactoryMBean() {
            if (U.IGNITE_MBEANS_DISABLED) {
                return;
            }
            Map<MBeanServer, GridMBeanServerData> map = mbeans;
            synchronized (map) {
                Iterator<Map.Entry<MBeanServer, GridMBeanServerData>> iter = mbeans.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<MBeanServer, GridMBeanServerData> entry = iter.next();
                    if (!entry.getValue().containsIgniteInstance(this.name)) continue;
                    GridMBeanServerData data = entry.getValue();
                    assert (data != null);
                    if (data.getCounter() == 1) {
                        try {
                            entry.getKey().unregisterMBean(data.getMbean());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Unregistered MBean: " + data.getMbean());
                            }
                        }
                        catch (JMException e) {
                            U.error(this.log, "Failed to unregister MBean.", e);
                        }
                        iter.remove();
                        continue;
                    }
                    data.setCounter(data.getCounter() - 1);
                    data.removeIgniteInstance(this.name);
                }
            }
        }

        private static class GridMBeanServerData {
            private Collection<String> igniteInstanceNames = new HashSet<String>();
            private ObjectName mbean;
            private int cnt;

            GridMBeanServerData(ObjectName mbean) {
                assert (mbean != null);
                this.mbean = mbean;
            }

            public void addIgniteInstance(String igniteInstanceName) {
                this.igniteInstanceNames.add(igniteInstanceName);
            }

            public void removeIgniteInstance(String igniteInstanceName) {
                this.igniteInstanceNames.remove(igniteInstanceName);
            }

            public boolean containsIgniteInstance(String igniteInstanceName) {
                return this.igniteInstanceNames.contains(igniteInstanceName);
            }

            public ObjectName getMbean() {
                return this.mbean;
            }

            public int getCounter() {
                return this.cnt;
            }

            public void setCounter(int cnt) {
                this.cnt = cnt;
            }
        }
    }

    private static final class GridStartContext {
        private IgniteConfiguration cfg;
        private URL cfgUrl;
        private GridSpringResourceContext springCtx;
        private boolean single;

        GridStartContext(IgniteConfiguration cfg, @Nullable URL cfgUrl, @Nullable GridSpringResourceContext springCtx) {
            assert (cfg != null);
            this.cfg = cfg;
            this.cfgUrl = cfgUrl;
            this.springCtx = springCtx;
        }

        public boolean single() {
            return this.single;
        }

        public void single(boolean single) {
            this.single = single;
        }

        IgniteConfiguration config() {
            return this.cfg;
        }

        void config(IgniteConfiguration cfg) {
            this.cfg = cfg;
        }

        URL configUrl() {
            return this.cfgUrl;
        }

        void configUrl(URL cfgUrl) {
            this.cfgUrl = cfgUrl;
        }

        public GridSpringResourceContext springContext() {
            return this.springCtx;
        }
    }
}

