/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CacheGroupAffinityMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsAbstractMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionCountersMap2;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionHistorySuppliersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionsToReloadMap;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsFullMessage
extends GridDhtPartitionsAbstractMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectTransient
    private Map<Integer, GridDhtPartitionFullMap> parts;
    @GridDirectMap(keyType=Integer.class, valueType=Integer.class)
    private Map<Integer, Integer> dupPartsData;
    private byte[] partsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private IgniteDhtPartitionCountersMap partCntrs;
    private byte[] partCntrsBytes;
    @GridToStringInclude
    @GridDirectTransient
    private IgniteDhtPartitionCountersMap2 partCntrs2;
    private byte[] partCntrsBytes2;
    @GridToStringInclude
    @GridDirectTransient
    private IgniteDhtPartitionHistorySuppliersMap partHistSuppliers;
    private byte[] partHistSuppliersBytes;
    @GridToStringInclude
    @GridDirectTransient
    private IgniteDhtPartitionsToReloadMap partsToReload;
    private byte[] partsToReloadBytes;
    private AffinityTopologyVersion topVer;
    @GridToStringInclude
    @GridDirectTransient
    private Map<UUID, Exception> errs;
    private byte[] errsBytes;
    @GridDirectTransient
    private transient boolean compress;
    private AffinityTopologyVersion resTopVer;
    @GridDirectMap(keyType=Integer.class, valueType=CacheGroupAffinityMessage.class)
    private Map<Integer, CacheGroupAffinityMessage> joinedNodeAff;
    @GridDirectMap(keyType=Integer.class, valueType=CacheGroupAffinityMessage.class)
    private Map<Integer, CacheGroupAffinityMessage> idealAffDiff;

    public GridDhtPartitionsFullMessage() {
    }

    public GridDhtPartitionsFullMessage(@Nullable GridDhtPartitionExchangeId id, @Nullable GridCacheVersion lastVer, @NotNull AffinityTopologyVersion topVer, @Nullable IgniteDhtPartitionHistorySuppliersMap partHistSuppliers, @Nullable IgniteDhtPartitionsToReloadMap partsToReload) {
        super(id, lastVer);
        assert (id == null || topVer.equals(id.topologyVersion()));
        this.topVer = topVer;
        this.partHistSuppliers = partHistSuppliers;
        this.partsToReload = partsToReload;
    }

    @Override
    void copyStateTo(GridDhtPartitionsAbstractMessage msg) {
        super.copyStateTo(msg);
        GridDhtPartitionsFullMessage cp = (GridDhtPartitionsFullMessage)msg;
        cp.parts = this.parts;
        cp.dupPartsData = this.dupPartsData;
        cp.partsBytes = this.partsBytes;
        cp.partCntrs = this.partCntrs;
        cp.partCntrsBytes = this.partCntrsBytes;
        cp.partCntrs2 = this.partCntrs2;
        cp.partCntrsBytes2 = this.partCntrsBytes2;
        cp.partHistSuppliers = this.partHistSuppliers;
        cp.partHistSuppliersBytes = this.partHistSuppliersBytes;
        cp.partsToReload = this.partsToReload;
        cp.partsToReloadBytes = this.partsToReloadBytes;
        cp.topVer = this.topVer;
        cp.errs = this.errs;
        cp.errsBytes = this.errsBytes;
        cp.compress = this.compress;
        cp.resTopVer = this.resTopVer;
        cp.joinedNodeAff = this.joinedNodeAff;
        cp.idealAffDiff = this.idealAffDiff;
    }

    GridDhtPartitionsFullMessage copy() {
        GridDhtPartitionsFullMessage cp = new GridDhtPartitionsFullMessage();
        this.copyStateTo(cp);
        return cp;
    }

    public void resultTopologyVersion(AffinityTopologyVersion resTopVer) {
        this.resTopVer = resTopVer;
    }

    public AffinityTopologyVersion resultTopologyVersion() {
        return this.resTopVer;
    }

    @Nullable
    public Map<Integer, CacheGroupAffinityMessage> joinedNodeAffinity() {
        return this.joinedNodeAff;
    }

    void joinedNodeAffinity(Map<Integer, CacheGroupAffinityMessage> joinedNodeAff) {
        this.joinedNodeAff = joinedNodeAff;
    }

    @Nullable
    public Map<Integer, CacheGroupAffinityMessage> idealAffinityDiff() {
        return this.idealAffDiff;
    }

    void idealAffinityDiff(Map<Integer, CacheGroupAffinityMessage> idealAffDiff) {
        this.idealAffDiff = idealAffDiff;
    }

    @Override
    public int handlerId() {
        return 0;
    }

    public void compress(boolean compress) {
        this.compress = compress;
    }

    public Map<Integer, GridDhtPartitionFullMap> partitions() {
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionFullMap>();
        }
        return this.parts;
    }

    public boolean containsGroup(int grpId) {
        return this.parts != null && this.parts.containsKey(grpId);
    }

    public void addFullPartitionsMap(int grpId, GridDhtPartitionFullMap fullMap, @Nullable Integer dupDataCache) {
        assert (fullMap != null);
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionFullMap>();
        }
        if (!this.parts.containsKey(grpId)) {
            this.parts.put(grpId, fullMap);
            if (dupDataCache != null) {
                assert (this.compress);
                assert (this.parts.containsKey(dupDataCache));
                if (this.dupPartsData == null) {
                    this.dupPartsData = new HashMap<Integer, Integer>();
                }
                this.dupPartsData.put(grpId, dupDataCache);
            }
        }
    }

    public void addPartitionUpdateCounters(int grpId, Map<Integer, T2<Long, Long>> cntrMap) {
        if (this.partCntrs == null) {
            this.partCntrs = new IgniteDhtPartitionCountersMap();
        }
        this.partCntrs.putIfAbsent(grpId, cntrMap);
    }

    public void addPartitionUpdateCounters(int grpId, CachePartitionFullCountersMap cntrMap) {
        if (this.partCntrs2 == null) {
            this.partCntrs2 = new IgniteDhtPartitionCountersMap2();
        }
        this.partCntrs2.putIfAbsent(grpId, cntrMap);
    }

    public CachePartitionFullCountersMap partitionUpdateCounters(int grpId, int partsCnt) {
        if (this.partCntrs2 != null) {
            return this.partCntrs2.get(grpId);
        }
        if (this.partCntrs == null) {
            return null;
        }
        Map<Integer, T2<Long, Long>> map = this.partCntrs.get(grpId);
        return map != null ? CachePartitionFullCountersMap.fromCountersMap(map, partsCnt) : null;
    }

    public IgniteDhtPartitionHistorySuppliersMap partitionHistorySuppliers() {
        if (this.partHistSuppliers == null) {
            return IgniteDhtPartitionHistorySuppliersMap.empty();
        }
        return this.partHistSuppliers;
    }

    public Set<Integer> partsToReload(UUID nodeId, int grpId) {
        if (this.partsToReload == null) {
            return Collections.emptySet();
        }
        return this.partsToReload.get(nodeId, grpId);
    }

    @Nullable
    Map<UUID, Exception> getErrorsMap() {
        return this.errs;
    }

    void setErrorsMap(Map<UUID, Exception> errs) {
        this.errs = new HashMap<UUID, Exception>(errs);
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        boolean marshal;
        super.prepareMarshal(ctx);
        boolean bl = marshal = !F.isEmpty(this.parts) && this.partsBytes == null || this.partCntrs != null && !this.partCntrs.empty() && this.partCntrsBytes == null || this.partCntrs2 != null && !this.partCntrs2.empty() && this.partCntrsBytes2 == null || this.partHistSuppliers != null && this.partHistSuppliersBytes == null || this.partsToReload != null && this.partsToReloadBytes == null || !F.isEmpty(this.errs) && this.errsBytes == null;
        if (marshal) {
            byte[] partsBytes0 = null;
            byte[] partCntrsBytes0 = null;
            byte[] partCntrsBytes20 = null;
            byte[] partHistSuppliersBytes0 = null;
            byte[] partsToReloadBytes0 = null;
            byte[] errsBytes0 = null;
            if (!F.isEmpty(this.parts) && this.partsBytes == null) {
                partsBytes0 = U.marshal(ctx, this.parts);
            }
            if (this.partCntrs != null && !this.partCntrs.empty() && this.partCntrsBytes == null) {
                partCntrsBytes0 = U.marshal(ctx, (Object)this.partCntrs);
            }
            if (this.partCntrs2 != null && !this.partCntrs2.empty() && this.partCntrsBytes2 == null) {
                partCntrsBytes20 = U.marshal(ctx, (Object)this.partCntrs2);
            }
            if (this.partHistSuppliers != null && this.partHistSuppliersBytes == null) {
                partHistSuppliersBytes0 = U.marshal(ctx, (Object)this.partHistSuppliers);
            }
            if (this.partsToReload != null && this.partsToReloadBytes == null) {
                partsToReloadBytes0 = U.marshal(ctx, (Object)this.partsToReload);
            }
            if (!F.isEmpty(this.errs) && this.errsBytes == null) {
                errsBytes0 = U.marshal(ctx, this.errs);
            }
            if (this.compress) {
                assert (!this.compressed());
                try {
                    byte[] partsBytesZip = U.zip(partsBytes0);
                    byte[] partCntrsBytesZip = U.zip(partCntrsBytes0);
                    byte[] partCntrsBytes2Zip = U.zip(partCntrsBytes20);
                    byte[] partHistSuppliersBytesZip = U.zip(partHistSuppliersBytes0);
                    byte[] partsToReloadBytesZip = U.zip(partsToReloadBytes0);
                    byte[] exsBytesZip = U.zip(errsBytes0);
                    partsBytes0 = partsBytesZip;
                    partCntrsBytes0 = partCntrsBytesZip;
                    partCntrsBytes20 = partCntrsBytes2Zip;
                    partHistSuppliersBytes0 = partHistSuppliersBytesZip;
                    partsToReloadBytes0 = partsToReloadBytesZip;
                    errsBytes0 = exsBytesZip;
                    this.compressed(true);
                }
                catch (IgniteCheckedException e) {
                    U.error(ctx.logger(this.getClass()), "Failed to compress partitions data: " + e, e);
                }
            }
            this.partsBytes = partsBytes0;
            this.partCntrsBytes = partCntrsBytes0;
            this.partCntrsBytes2 = partCntrsBytes20;
            this.partHistSuppliersBytes = partHistSuppliersBytes0;
            this.partsToReloadBytes = partsToReloadBytes0;
            this.errsBytes = errsBytes0;
        }
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.partsBytes != null && this.parts == null) {
            this.parts = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.partsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
            if (this.dupPartsData != null) {
                assert (this.parts != null);
                for (Map.Entry<Integer, Integer> e : this.dupPartsData.entrySet()) {
                    GridDhtPartitionFullMap map1 = this.parts.get(e.getKey());
                    GridDhtPartitionFullMap map2 = this.parts.get(e.getValue());
                    assert (map1 != null) : e.getKey();
                    assert (map2 != null) : e.getValue();
                    assert (map1.size() == map2.size());
                    for (Map.Entry e0 : map2.entrySet()) {
                        GridDhtPartitionMap partMap1 = (GridDhtPartitionMap)map1.get(e0.getKey());
                        assert (partMap1 != null && partMap1.map().isEmpty()) : partMap1;
                        assert (!partMap1.hasMovingPartitions()) : partMap1;
                        GridDhtPartitionMap partMap2 = (GridDhtPartitionMap)e0.getValue();
                        assert (partMap2 != null);
                        for (Map.Entry<Integer, GridDhtPartitionState> stateEntry : partMap2.entrySet()) {
                            partMap1.put(stateEntry.getKey(), stateEntry.getValue());
                        }
                    }
                }
            }
        }
        if (this.parts == null) {
            this.parts = new HashMap<Integer, GridDhtPartitionFullMap>();
        }
        if (this.partCntrsBytes != null && this.partCntrs == null) {
            this.partCntrs = this.compressed() ? (IgniteDhtPartitionCountersMap)U.unmarshalZip(ctx.marshaller(), this.partCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (IgniteDhtPartitionCountersMap)U.unmarshal(ctx, this.partCntrsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partCntrsBytes2 != null && this.partCntrs2 == null) {
            this.partCntrs2 = this.compressed() ? (IgniteDhtPartitionCountersMap2)U.unmarshalZip(ctx.marshaller(), this.partCntrsBytes2, U.resolveClassLoader(ldr, ctx.gridConfig())) : (IgniteDhtPartitionCountersMap2)U.unmarshal(ctx, this.partCntrsBytes2, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partHistSuppliersBytes != null && this.partHistSuppliers == null) {
            this.partHistSuppliers = this.compressed() ? (IgniteDhtPartitionHistorySuppliersMap)U.unmarshalZip(ctx.marshaller(), this.partHistSuppliersBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (IgniteDhtPartitionHistorySuppliersMap)U.unmarshal(ctx, this.partHistSuppliersBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partsToReloadBytes != null && this.partsToReload == null) {
            this.partsToReload = this.compressed() ? (IgniteDhtPartitionsToReloadMap)U.unmarshalZip(ctx.marshaller(), this.partsToReloadBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (IgniteDhtPartitionsToReloadMap)U.unmarshal(ctx, this.partsToReloadBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.partCntrs == null) {
            this.partCntrs = new IgniteDhtPartitionCountersMap();
        }
        if (this.errsBytes != null && this.errs == null) {
            this.errs = this.compressed() ? (Map)U.unmarshalZip(ctx.marshaller(), this.errsBytes, U.resolveClassLoader(ldr, ctx.gridConfig())) : (Map)U.unmarshal(ctx, this.errsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.errs == null) {
            this.errs = new HashMap<UUID, Exception>();
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 5: {
                if (!writer.writeMap("dupPartsData", this.dupPartsData, MessageCollectionItemType.INT, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeByteArray("errsBytes", this.errsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMap("idealAffDiff", this.idealAffDiff, MessageCollectionItemType.INT, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeMap("joinedNodeAff", this.joinedNodeAff, MessageCollectionItemType.INT, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeByteArray("partCntrsBytes", this.partCntrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeByteArray("partCntrsBytes2", this.partCntrsBytes2)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeByteArray("partHistSuppliersBytes", this.partHistSuppliersBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeByteArray("partsBytes", this.partsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeByteArray("partsToReloadBytes", this.partsToReloadBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeMessage("resTopVer", this.resTopVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 5: {
                this.dupPartsData = reader.readMap("dupPartsData", MessageCollectionItemType.INT, MessageCollectionItemType.INT, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.errsBytes = reader.readByteArray("errsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.idealAffDiff = reader.readMap("idealAffDiff", MessageCollectionItemType.INT, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.joinedNodeAff = reader.readMap("joinedNodeAff", MessageCollectionItemType.INT, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.partCntrsBytes = reader.readByteArray("partCntrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.partCntrsBytes2 = reader.readByteArray("partCntrsBytes2");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.partHistSuppliersBytes = reader.readByteArray("partHistSuppliersBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.partsBytes = reader.readByteArray("partsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.partsToReloadBytes = reader.readByteArray("partsToReloadBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.resTopVer = (AffinityTopologyVersion)reader.readMessage("resTopVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionsFullMessage.class);
    }

    @Override
    public short directType() {
        return 46;
    }

    @Override
    public byte fieldsCount() {
        return 16;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionsFullMessage.class, this, "partCnt", this.parts != null ? this.parts.size() : 0, "super", super.toString());
    }
}

