/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridStringBuilder;

public class DataPageIO
extends AbstractDataPageIO<CacheDataRow> {
    public static final IOVersions<DataPageIO> VERSIONS = new IOVersions((PageIO[])new DataPageIO[]{new DataPageIO(1)});

    protected DataPageIO(int ver) {
        super(1, ver);
    }

    @Override
    protected void writeFragmentData(CacheDataRow row, ByteBuffer buf, int rowOff, int payloadSize) throws IgniteCheckedException {
        int keySize = row.key().valueBytesLength(null);
        int valSize = row.value().valueBytesLength(null);
        int written = this.writeFragment(row, buf, rowOff, payloadSize, EntryPart.CACHE_ID, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.KEY, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.EXPIRE_TIME, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.VALUE, keySize, valSize);
        written += this.writeFragment(row, buf, rowOff + written, payloadSize - written, EntryPart.VERSION, keySize, valSize);
        assert (written == payloadSize);
    }

    private int writeFragment(CacheDataRow row, ByteBuffer buf, int rowOff, int payloadSize, EntryPart type, int keySize, int valSize) throws IgniteCheckedException {
        int curLen;
        int prevLen;
        if (payloadSize == 0) {
            return 0;
        }
        int cacheIdSize = row.cacheId() == 0 ? 0 : 4;
        switch (type) {
            case CACHE_ID: {
                prevLen = 0;
                curLen = cacheIdSize;
                break;
            }
            case KEY: {
                prevLen = cacheIdSize;
                curLen = cacheIdSize + keySize;
                break;
            }
            case EXPIRE_TIME: {
                prevLen = cacheIdSize + keySize;
                curLen = cacheIdSize + keySize + 8;
                break;
            }
            case VALUE: {
                prevLen = cacheIdSize + keySize + 8;
                curLen = cacheIdSize + keySize + valSize + 8;
                break;
            }
            case VERSION: {
                prevLen = cacheIdSize + keySize + valSize + 8;
                curLen = cacheIdSize + keySize + valSize + CacheVersionIO.size(row.version(), false) + 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown entry part type: " + (Object)((Object)type));
            }
        }
        if (curLen <= rowOff) {
            return 0;
        }
        int len = Math.min(curLen - rowOff, payloadSize);
        if (type == EntryPart.EXPIRE_TIME) {
            this.writeExpireTimeFragment(buf, row.expireTime(), rowOff, len, prevLen);
        } else if (type == EntryPart.CACHE_ID) {
            this.writeCacheIdFragment(buf, row.cacheId(), rowOff, len, prevLen);
        } else if (type != EntryPart.VERSION) {
            CacheObject co = type == EntryPart.KEY ? row.key() : row.value();
            co.putValue(buf, rowOff - prevLen, len);
        } else {
            this.writeVersionFragment(buf, row.version(), rowOff, len, prevLen);
        }
        return len;
    }

    private void writeVersionFragment(ByteBuffer buf, GridCacheVersion ver, int rowOff, int len, int prevLen) {
        int verSize = CacheVersionIO.size(ver, false);
        assert (len <= verSize) : len;
        if (verSize == len) {
            CacheVersionIO.write(buf, ver, false);
        } else {
            ByteBuffer verBuf = ByteBuffer.allocate(verSize);
            verBuf.order(buf.order());
            CacheVersionIO.write(verBuf, ver, false);
            buf.put(verBuf.array(), rowOff - prevLen, len);
        }
    }

    private void writeExpireTimeFragment(ByteBuffer buf, long expireTime, int rowOff, int len, int prevLen) {
        int size = 8;
        if (size <= len) {
            buf.putLong(expireTime);
        } else {
            ByteBuffer timeBuf = ByteBuffer.allocate(size);
            timeBuf.order(buf.order());
            timeBuf.putLong(expireTime);
            buf.put(timeBuf.array(), rowOff - prevLen, len);
        }
    }

    private void writeCacheIdFragment(ByteBuffer buf, int cacheId, int rowOff, int len, int prevLen) {
        if (cacheId == 0) {
            return;
        }
        int size = 4;
        if (size <= len) {
            buf.putInt(cacheId);
        } else {
            ByteBuffer cacheIdBuf = ByteBuffer.allocate(size);
            cacheIdBuf.order(buf.order());
            cacheIdBuf.putInt(cacheId);
            buf.put(cacheIdBuf.array(), rowOff - prevLen, len);
        }
    }

    @Override
    protected void writeRowData(long pageAddr, int dataOff, int payloadSize, CacheDataRow row, boolean newRow) throws IgniteCheckedException {
        int cacheIdSize;
        long addr = pageAddr + (long)dataOff;
        int n = cacheIdSize = row.cacheId() != 0 ? 4 : 0;
        if (newRow) {
            PageUtils.putShort(addr, 0, (short)payloadSize);
            addr += 2L;
            if (cacheIdSize != 0) {
                PageUtils.putInt(addr, 0, row.cacheId());
                addr += (long)cacheIdSize;
            }
            addr += (long)row.key().putValue(addr);
        } else {
            addr += (long)(2 + cacheIdSize + row.key().valueBytesLength(null));
        }
        addr += (long)row.value().putValue(addr);
        CacheVersionIO.write(addr, row.version(), false);
        PageUtils.putLong(addr += (long)CacheVersionIO.size(row.version(), false), 0, row.expireTime());
    }

    @Override
    protected void writeRowData(long pageAddr, int dataOff, byte[] payload) {
        PageUtils.putShort(pageAddr, dataOff, (short)payload.length);
        PageUtils.putBytes(pageAddr, dataOff += 2, payload);
    }

    @Override
    public int getRowSize(CacheDataRow row) throws IgniteCheckedException {
        return DataPageIO.getRowSize(row, row.cacheId() != 0);
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("DataPageIO [\n");
        this.printPageLayout(addr, pageSize, sb);
        sb.a("\n]");
    }

    public static int getRowSize(CacheDataRow row, boolean withCacheId) throws IgniteCheckedException {
        KeyCacheObject key = row.key();
        CacheObject val = row.value();
        int keyLen = key.valueBytesLength(null);
        int valLen = val.valueBytesLength(null);
        return keyLen + valLen + CacheVersionIO.size(row.version(), false) + 8 + (withCacheId ? 4 : 0);
    }

    private static enum EntryPart {
        KEY,
        VALUE,
        VERSION,
        EXPIRE_TIME,
        CACHE_ID;

    }
}

