/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.datastructures.SetItemKey;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class GridCacheSetItemKey
implements SetItemKey,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid setId;
    @GridToStringInclude(sensitive=true)
    private Object item;

    public GridCacheSetItemKey() {
    }

    GridCacheSetItemKey(IgniteUuid setId, Object item) {
        this.setId = setId;
        this.item = item;
    }

    @Override
    public IgniteUuid setId() {
        return this.setId;
    }

    @Override
    public Object item() {
        return this.item;
    }

    public int hashCode() {
        int res = this.setId.hashCode();
        res = 31 * res + this.item.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridCacheSetItemKey that = (GridCacheSetItemKey)o;
        return this.setId.equals(that.setId) && this.item.equals(that.item);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.setId);
        out.writeObject(this.item);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setId = U.readGridUuid(in);
        this.item = in.readObject();
    }

    public String toString() {
        return S.toString(GridCacheSetItemKey.class, this);
    }
}

