/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.marshaller;

import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.marshaller.MappingAcceptedMessage;
import org.apache.ignite.internal.processors.marshaller.MarshallerMappingItem;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class MappingProposedMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final UUID origNodeId;
    @GridToStringInclude
    private final MarshallerMappingItem mappingItem;
    private ProposalStatus status = ProposalStatus.SUCCESSFUL;
    private String conflictingClsName;

    MappingProposedMessage(MarshallerMappingItem mappingItem, UUID origNodeId) {
        assert (origNodeId != null);
        this.mappingItem = mappingItem;
        this.origNodeId = origNodeId;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        if (this.status == ProposalStatus.SUCCESSFUL) {
            return new MappingAcceptedMessage(this.mappingItem);
        }
        return null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean stopProcess() {
        return false;
    }

    @Override
    @Nullable
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        throw new UnsupportedOperationException();
    }

    MarshallerMappingItem mappingItem() {
        return this.mappingItem;
    }

    UUID origNodeId() {
        return this.origNodeId;
    }

    boolean inConflict() {
        return this.status == ProposalStatus.IN_CONFLICT;
    }

    public boolean duplicated() {
        return this.status == ProposalStatus.DUPLICATED;
    }

    void conflictingWithClass(String conflClsName) {
        this.status = ProposalStatus.IN_CONFLICT;
        this.conflictingClsName = conflClsName;
    }

    void markDuplicated() {
        this.status = ProposalStatus.DUPLICATED;
    }

    String conflictingClassName() {
        return this.conflictingClsName;
    }

    public String toString() {
        return S.toString(MappingProposedMessage.class, this);
    }

    private static enum ProposalStatus {
        SUCCESSFUL,
        IN_CONFLICT,
        DUPLICATED;

    }
}

