/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class JdbcBatchExecuteRequest
extends JdbcRequest {
    private String schemaName;
    @GridToStringInclude(sensitive=true)
    private List<JdbcQuery> queries;
    private boolean lastStreamBatch;

    public JdbcBatchExecuteRequest() {
        super((byte)6);
    }

    protected JdbcBatchExecuteRequest(byte type) {
        super(type);
    }

    public JdbcBatchExecuteRequest(String schemaName, List<JdbcQuery> queries, boolean lastStreamBatch) {
        super((byte)6);
        assert (lastStreamBatch || !F.isEmpty(queries));
        this.schemaName = schemaName;
        this.queries = queries;
        this.lastStreamBatch = lastStreamBatch;
    }

    protected JdbcBatchExecuteRequest(byte type, String schemaName, List<JdbcQuery> queries, boolean lastStreamBatch) {
        super(type);
        assert (lastStreamBatch || !F.isEmpty(queries));
        this.schemaName = schemaName;
        this.queries = queries;
        this.lastStreamBatch = lastStreamBatch;
    }

    @Nullable
    public String schemaName() {
        return this.schemaName;
    }

    public List<JdbcQuery> queries() {
        return this.queries;
    }

    public boolean isLastStreamBatch() {
        return this.lastStreamBatch;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer) throws BinaryObjectException {
        super.writeBinary(writer);
        writer.writeString(this.schemaName);
        if (!F.isEmpty(this.queries)) {
            writer.writeInt(this.queries.size());
            for (JdbcQuery q : this.queries) {
                q.writeBinary(writer);
            }
        } else {
            writer.writeInt(0);
        }
        writer.writeBoolean(this.lastStreamBatch);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader) throws BinaryObjectException {
        super.readBinary(reader);
        this.schemaName = reader.readString();
        int n = reader.readInt();
        this.queries = new ArrayList<JdbcQuery>(n);
        for (int i = 0; i < n; ++i) {
            JdbcQuery qry = new JdbcQuery();
            qry.readBinary(reader);
            this.queries.add(qry);
        }
        try {
            if (reader.available() > 0) {
                this.lastStreamBatch = reader.readBoolean();
            }
        }
        catch (IOException e) {
            throw new BinaryObjectException(e);
        }
    }

    public String toString() {
        return S.toString(JdbcBatchExecuteRequest.class, this);
    }
}

