/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcTableMeta;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcMetaTablesResult
extends JdbcResult {
    private List<JdbcTableMeta> meta;

    JdbcMetaTablesResult() {
        super((byte)7);
    }

    JdbcMetaTablesResult(List<JdbcTableMeta> meta) {
        super((byte)7);
        this.meta = meta;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer) throws BinaryObjectException {
        super.writeBinary(writer);
        if (F.isEmpty(this.meta)) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.meta.size());
            for (JdbcTableMeta m : this.meta) {
                m.writeBinary(writer);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader) throws BinaryObjectException {
        super.readBinary(reader);
        int size = reader.readInt();
        if (size == 0) {
            this.meta = Collections.emptyList();
        } else {
            this.meta = new ArrayList<JdbcTableMeta>(size);
            for (int i = 0; i < size; ++i) {
                JdbcTableMeta m = new JdbcTableMeta();
                m.readBinary(reader);
                this.meta.add(m);
            }
        }
    }

    public List<JdbcTableMeta> meta() {
        return this.meta;
    }

    public String toString() {
        return S.toString(JdbcMetaTablesResult.class, this);
    }
}

