/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;

public class ValidateIndexesPartitionResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long updateCntr;
    private long size;
    private boolean isPrimary;
    @GridToStringInclude
    private Object consistentId;
    @GridToStringExclude
    private List<IndexValidationIssue> issues = new ArrayList<IndexValidationIssue>(10);

    public ValidateIndexesPartitionResult() {
    }

    public ValidateIndexesPartitionResult(long updateCntr, long size, boolean isPrimary, Object consistentId) {
        this.updateCntr = updateCntr;
        this.size = size;
        this.isPrimary = isPrimary;
        this.consistentId = consistentId;
    }

    public long updateCntr() {
        return this.updateCntr;
    }

    public long size() {
        return this.size;
    }

    public boolean primary() {
        return this.isPrimary;
    }

    public Object consistentId() {
        return this.consistentId;
    }

    public List<IndexValidationIssue> issues() {
        return this.issues;
    }

    public boolean reportIssue(IndexValidationIssue t) {
        if (this.issues.size() >= 10) {
            return true;
        }
        this.issues.add(t);
        return false;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.updateCntr);
        out.writeLong(this.size);
        out.writeBoolean(this.isPrimary);
        out.writeObject(this.consistentId);
        U.writeCollection(out, this.issues);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.updateCntr = in.readLong();
        this.size = in.readLong();
        this.isPrimary = in.readBoolean();
        this.consistentId = in.readObject();
        this.issues = U.readList(in);
    }

    public String toString() {
        return S.toString(ValidateIndexesPartitionResult.class, this);
    }
}

