/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.util.Map;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.igfs.IgfsIpcEndpointConfiguration;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class FileSystemConfiguration {
    public static final String DFLT_USER_NAME = System.getProperty("user.name", "anonymous");
    public static final long DFLT_FRAGMENTIZER_THROTTLING_BLOCK_LENGTH = 0x1000000L;
    public static final long DFLT_FRAGMENTIZER_THROTTLING_DELAY = 200L;
    public static final int DFLT_FRAGMENTIZER_CONCURRENT_FILES = 0;
    public static final boolean DFLT_FRAGMENTIZER_ENABLED = true;
    public static final int DFLT_IGFS_LOG_BATCH_SIZE = 100;
    public static final String DFLT_IGFS_LOG_DIR = "work/igfs/log";
    public static final int DFLT_PER_NODE_BATCH_SIZE = 512;
    public static final int DFLT_PER_NODE_PARALLEL_BATCH_CNT = 16;
    public static final IgfsMode DFLT_MODE = IgfsMode.DUAL_ASYNC;
    public static final int DFLT_BLOCK_SIZE = 65536;
    public static final int DFLT_BUF_SIZE = 65536;
    public static final int DFLT_MGMT_PORT = 11400;
    public static final boolean DFLT_IPC_ENDPOINT_ENABLED = true;
    public static final boolean DFLT_COLOCATE_META = true;
    public static final boolean DFLT_RELAXED_CONSISTENCY = true;
    public static final boolean DFLT_UPDATE_FILE_LEN_ON_FLUSH = false;
    private String name;
    private int blockSize = 65536;
    private int prefetchBlocks;
    private int seqReadsBeforePrefetch;
    private int bufSize = 65536;
    private int perNodeBatchSize = 512;
    private int perNodeParallelBatchCnt = 16;
    private IgfsIpcEndpointConfiguration ipcEndpointCfg;
    private boolean ipcEndpointEnabled = true;
    private int mgmtPort = 11400;
    private IgfsSecondaryFileSystem secondaryFs;
    private IgfsMode dfltMode = DFLT_MODE;
    private long fragmentizerThrottlingBlockLen = 0x1000000L;
    private long fragmentizerThrottlingDelay = 200L;
    private int fragmentizerConcurrentFiles = 0;
    private boolean fragmentizerEnabled = true;
    private Map<String, IgfsMode> pathModes;
    private long maxTaskRangeLen;
    private boolean colocateMeta = true;
    private boolean relaxedConsistency = true;
    private boolean updateFileLenOnFlush = false;
    private CacheConfiguration metaCacheCfg;
    private CacheConfiguration dataCacheCfg;

    public FileSystemConfiguration() {
    }

    public FileSystemConfiguration(FileSystemConfiguration cfg) {
        assert (cfg != null);
        this.blockSize = cfg.getBlockSize();
        this.bufSize = cfg.getBufferSize();
        this.colocateMeta = cfg.isColocateMetadata();
        this.dataCacheCfg = cfg.getDataCacheConfiguration();
        this.dfltMode = cfg.getDefaultMode();
        this.fragmentizerConcurrentFiles = cfg.getFragmentizerConcurrentFiles();
        this.fragmentizerEnabled = cfg.isFragmentizerEnabled();
        this.fragmentizerThrottlingBlockLen = cfg.getFragmentizerThrottlingBlockLength();
        this.fragmentizerThrottlingDelay = cfg.getFragmentizerThrottlingDelay();
        this.secondaryFs = cfg.getSecondaryFileSystem();
        this.ipcEndpointCfg = cfg.getIpcEndpointConfiguration();
        this.ipcEndpointEnabled = cfg.isIpcEndpointEnabled();
        this.maxTaskRangeLen = cfg.getMaximumTaskRangeLength();
        this.metaCacheCfg = cfg.getMetaCacheConfiguration();
        this.mgmtPort = cfg.getManagementPort();
        this.name = cfg.getName();
        this.pathModes = cfg.getPathModes();
        this.perNodeBatchSize = cfg.getPerNodeBatchSize();
        this.perNodeParallelBatchCnt = cfg.getPerNodeParallelBatchCount();
        this.prefetchBlocks = cfg.getPrefetchBlocks();
        this.relaxedConsistency = cfg.isRelaxedConsistency();
        this.seqReadsBeforePrefetch = cfg.getSequentialReadsBeforePrefetch();
        this.updateFileLenOnFlush = cfg.isUpdateFileLengthOnFlush();
    }

    public String getName() {
        return this.name;
    }

    public FileSystemConfiguration setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("IGFS name cannot be null");
        }
        this.name = name;
        return this;
    }

    @Nullable
    public CacheConfiguration getMetaCacheConfiguration() {
        return this.metaCacheCfg;
    }

    public FileSystemConfiguration setMetaCacheConfiguration(CacheConfiguration metaCacheCfg) {
        this.metaCacheCfg = metaCacheCfg;
        return this;
    }

    @Nullable
    public CacheConfiguration getDataCacheConfiguration() {
        return this.dataCacheCfg;
    }

    public FileSystemConfiguration setDataCacheConfiguration(CacheConfiguration dataCacheCfg) {
        this.dataCacheCfg = dataCacheCfg;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public FileSystemConfiguration setBlockSize(int blockSize) {
        A.ensure(blockSize >= 0, "blockSize >= 0");
        this.blockSize = blockSize == 0 ? 65536 : blockSize;
        return this;
    }

    public int getPrefetchBlocks() {
        return this.prefetchBlocks;
    }

    public FileSystemConfiguration setPrefetchBlocks(int prefetchBlocks) {
        A.ensure(prefetchBlocks >= 0, "prefetchBlocks >= 0");
        this.prefetchBlocks = prefetchBlocks;
        return this;
    }

    public int getSequentialReadsBeforePrefetch() {
        return this.seqReadsBeforePrefetch;
    }

    public FileSystemConfiguration setSequentialReadsBeforePrefetch(int seqReadsBeforePrefetch) {
        A.ensure(seqReadsBeforePrefetch >= 0, "seqReadsBeforePrefetch >= 0");
        this.seqReadsBeforePrefetch = seqReadsBeforePrefetch;
        return this;
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public FileSystemConfiguration setBufferSize(int bufSize) {
        A.ensure(bufSize >= 0, "bufSize >= 0");
        this.bufSize = bufSize == 0 ? 65536 : bufSize;
        return this;
    }

    public int getPerNodeBatchSize() {
        return this.perNodeBatchSize;
    }

    public FileSystemConfiguration setPerNodeBatchSize(int perNodeBatchSize) {
        this.perNodeBatchSize = perNodeBatchSize;
        return this;
    }

    public int getPerNodeParallelBatchCount() {
        return this.perNodeParallelBatchCnt;
    }

    public FileSystemConfiguration setPerNodeParallelBatchCount(int perNodeParallelBatchCnt) {
        this.perNodeParallelBatchCnt = perNodeParallelBatchCnt;
        return this;
    }

    @Nullable
    public IgfsIpcEndpointConfiguration getIpcEndpointConfiguration() {
        return this.ipcEndpointCfg;
    }

    public FileSystemConfiguration setIpcEndpointConfiguration(@Nullable IgfsIpcEndpointConfiguration ipcEndpointCfg) {
        this.ipcEndpointCfg = ipcEndpointCfg;
        return this;
    }

    public boolean isIpcEndpointEnabled() {
        return this.ipcEndpointEnabled;
    }

    public FileSystemConfiguration setIpcEndpointEnabled(boolean ipcEndpointEnabled) {
        this.ipcEndpointEnabled = ipcEndpointEnabled;
        return this;
    }

    public int getManagementPort() {
        return this.mgmtPort;
    }

    public FileSystemConfiguration setManagementPort(int mgmtPort) {
        this.mgmtPort = mgmtPort;
        return this;
    }

    public IgfsMode getDefaultMode() {
        return this.dfltMode;
    }

    public FileSystemConfiguration setDefaultMode(IgfsMode dfltMode) {
        this.dfltMode = dfltMode;
        return this;
    }

    public IgfsSecondaryFileSystem getSecondaryFileSystem() {
        return this.secondaryFs;
    }

    public FileSystemConfiguration setSecondaryFileSystem(IgfsSecondaryFileSystem fileSystem) {
        this.secondaryFs = fileSystem;
        return this;
    }

    @Nullable
    public Map<String, IgfsMode> getPathModes() {
        return this.pathModes;
    }

    public FileSystemConfiguration setPathModes(Map<String, IgfsMode> pathModes) {
        this.pathModes = pathModes;
        return this;
    }

    public long getFragmentizerThrottlingBlockLength() {
        return this.fragmentizerThrottlingBlockLen;
    }

    public FileSystemConfiguration setFragmentizerThrottlingBlockLength(long fragmentizerThrottlingBlockLen) {
        this.fragmentizerThrottlingBlockLen = fragmentizerThrottlingBlockLen;
        return this;
    }

    public long getFragmentizerThrottlingDelay() {
        return this.fragmentizerThrottlingDelay;
    }

    public FileSystemConfiguration setFragmentizerThrottlingDelay(long fragmentizerThrottlingDelay) {
        this.fragmentizerThrottlingDelay = fragmentizerThrottlingDelay;
        return this;
    }

    public int getFragmentizerConcurrentFiles() {
        return this.fragmentizerConcurrentFiles;
    }

    public FileSystemConfiguration setFragmentizerConcurrentFiles(int fragmentizerConcurrentFiles) {
        this.fragmentizerConcurrentFiles = fragmentizerConcurrentFiles;
        return this;
    }

    public boolean isFragmentizerEnabled() {
        return this.fragmentizerEnabled;
    }

    public FileSystemConfiguration setFragmentizerEnabled(boolean fragmentizerEnabled) {
        this.fragmentizerEnabled = fragmentizerEnabled;
        return this;
    }

    public long getMaximumTaskRangeLength() {
        return this.maxTaskRangeLen;
    }

    public FileSystemConfiguration setMaximumTaskRangeLength(long maxTaskRangeLen) {
        this.maxTaskRangeLen = maxTaskRangeLen;
        return this;
    }

    public boolean isColocateMetadata() {
        return this.colocateMeta;
    }

    public FileSystemConfiguration setColocateMetadata(boolean colocateMeta) {
        this.colocateMeta = colocateMeta;
        return this;
    }

    public boolean isRelaxedConsistency() {
        return this.relaxedConsistency;
    }

    public FileSystemConfiguration setRelaxedConsistency(boolean relaxedConsistency) {
        this.relaxedConsistency = relaxedConsistency;
        return this;
    }

    public boolean isUpdateFileLengthOnFlush() {
        return this.updateFileLenOnFlush;
    }

    public FileSystemConfiguration setUpdateFileLengthOnFlush(boolean updateFileLenOnFlush) {
        this.updateFileLenOnFlush = updateFileLenOnFlush;
        return this;
    }

    public String toString() {
        return S.toString(FileSystemConfiguration.class, this);
    }
}

