/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs;

import java.util.concurrent.Callable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteOutClosure;
import org.jetbrains.annotations.Nullable;

public abstract class IgfsUserContext {
    private static final ThreadLocal<String> userStackThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(String user, IgniteOutClosure<T> c) {
        if (F.isEmpty(user)) {
            throw new IllegalArgumentException("Failed to use null or empty user name.");
        }
        String ctxUser = userStackThreadLocal.get();
        if (F.eq(ctxUser, user)) {
            return c.apply();
        }
        userStackThreadLocal.set(user);
        try {
            T t = c.apply();
            return t;
        }
        finally {
            userStackThreadLocal.set(ctxUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(String user, Callable<T> c) throws Exception {
        if (F.isEmpty(user)) {
            throw new IllegalArgumentException("Failed to use null or empty user name.");
        }
        String ctxUser = userStackThreadLocal.get();
        if (F.eq(ctxUser, user)) {
            return c.call();
        }
        userStackThreadLocal.set(user);
        try {
            T t = c.call();
            return t;
        }
        finally {
            userStackThreadLocal.set(ctxUser);
        }
    }

    @Nullable
    public static String currentUser() {
        return userStackThreadLocal.get();
    }
}

