/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;

@Deprecated
class JdbcUtils {
    private static final Marshaller MARSHALLER = new JdkMarshaller();

    JdbcUtils() {
    }

    public static byte[] marshalArgument(Map<String, Object> args) throws SQLException {
        assert (args != null);
        try {
            return U.marshal(MARSHALLER, args);
        }
        catch (IgniteCheckedException e) {
            throw new SQLException("Failed to unmarshal result.", e);
        }
    }

    public static SQLException unmarshalError(byte[] bytes) throws SQLException {
        return (SQLException)JdbcUtils.unmarshal(bytes);
    }

    public static <T> T unmarshal(byte[] bytes) throws SQLException {
        assert (bytes != null);
        try {
            return U.unmarshal(MARSHALLER, bytes, null);
        }
        catch (IgniteCheckedException e) {
            throw new SQLException("Failed to unmarshal result.", e);
        }
    }

    public static Map<String, Object> taskArgument(UUID nodeId, String cacheName, String sql, long timeout, Object[] args, int pageSize, int maxRows) {
        assert (sql != null);
        assert (timeout >= 0L);
        assert (pageSize > 0);
        assert (maxRows >= 0);
        HashMap<String, Object> map = U.newHashMap(7);
        map.put("confNodeId", nodeId);
        map.put("cache", cacheName);
        map.put("sql", sql);
        map.put("timeout", timeout);
        map.put("args", args != null ? Arrays.asList(args) : Collections.emptyList());
        map.put("pageSize", pageSize);
        map.put("maxRows", maxRows);
        return map;
    }

    public static Map<String, Object> taskArgument(UUID nodeId, UUID futId, int pageSize, int maxRows) {
        assert (nodeId != null);
        assert (futId != null);
        assert (pageSize > 0);
        assert (maxRows >= 0);
        HashMap<String, Object> map = U.newHashMap(4);
        map.put("nodeId", nodeId);
        map.put("futId", futId);
        map.put("pageSize", pageSize);
        map.put("maxRows", maxRows);
        return map;
    }

    public static int type(String cls) {
        if (Boolean.class.getName().equals(cls) || Boolean.TYPE.getName().equals(cls)) {
            return 16;
        }
        if (Byte.class.getName().equals(cls) || Byte.TYPE.getName().equals(cls)) {
            return -6;
        }
        if (Short.class.getName().equals(cls) || Short.TYPE.getName().equals(cls)) {
            return 5;
        }
        if (Integer.class.getName().equals(cls) || Integer.TYPE.getName().equals(cls)) {
            return 4;
        }
        if (Long.class.getName().equals(cls) || Long.TYPE.getName().equals(cls)) {
            return -5;
        }
        if (Float.class.getName().equals(cls) || Float.TYPE.getName().equals(cls)) {
            return 6;
        }
        if (Double.class.getName().equals(cls) || Double.TYPE.getName().equals(cls)) {
            return 8;
        }
        if (String.class.getName().equals(cls)) {
            return 12;
        }
        if (byte[].class.getName().equals(cls)) {
            return -2;
        }
        if (Time.class.getName().equals(cls)) {
            return 92;
        }
        if (Timestamp.class.getName().equals(cls)) {
            return 93;
        }
        if (Date.class.getName().equals(cls)) {
            return 91;
        }
        return 1111;
    }

    public static String typeName(String cls) {
        if (Boolean.class.getName().equals(cls) || Boolean.TYPE.getName().equals(cls)) {
            return "BOOLEAN";
        }
        if (Byte.class.getName().equals(cls) || Byte.TYPE.getName().equals(cls)) {
            return "TINYINT";
        }
        if (Short.class.getName().equals(cls) || Short.TYPE.getName().equals(cls)) {
            return "SMALLINT";
        }
        if (Integer.class.getName().equals(cls) || Integer.TYPE.getName().equals(cls)) {
            return "INTEGER";
        }
        if (Long.class.getName().equals(cls) || Long.TYPE.getName().equals(cls)) {
            return "BIGINT";
        }
        if (Float.class.getName().equals(cls) || Float.TYPE.getName().equals(cls)) {
            return "FLOAT";
        }
        if (Double.class.getName().equals(cls) || Double.TYPE.getName().equals(cls)) {
            return "DOUBLE";
        }
        if (String.class.getName().equals(cls)) {
            return "VARCHAR";
        }
        if (byte[].class.getName().equals(cls)) {
            return "BINARY";
        }
        if (Time.class.getName().equals(cls)) {
            return "TIME";
        }
        if (Timestamp.class.getName().equals(cls)) {
            return "TIMESTAMP";
        }
        if (Date.class.getName().equals(cls)) {
            return "DATE";
        }
        return "OTHER";
    }

    public static boolean nullable(String name, String cls) {
        return !"_KEY".equalsIgnoreCase(name) && !"_VAL".equalsIgnoreCase(name) && !Boolean.TYPE.getName().equals(cls) && !Byte.TYPE.getName().equals(cls) && !Short.TYPE.getName().equals(cls) && !Integer.TYPE.getName().equals(cls) && !Long.TYPE.getName().equals(cls) && !Float.TYPE.getName().equals(cls) && !Double.TYPE.getName().equals(cls);
    }
}

