/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.ignite.internal.jdbc2.JdbcUtils;

public class JdbcResultSetMetadata
implements ResultSetMetaData {
    private static final int COL_WIDTH = 30;
    private final List<String> tbls;
    private final List<String> cols;
    private final List<String> types;

    JdbcResultSetMetadata(List<String> tbls, List<String> cols, List<String> types) {
        assert (cols != null);
        assert (types != null);
        this.tbls = tbls;
        this.cols = cols;
        this.types = types;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.cols.size();
    }

    @Override
    public boolean isAutoIncrement(int col) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int col) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int col) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int col) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int col) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int col) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int col) throws SQLException {
        return 30;
    }

    @Override
    public String getColumnLabel(int col) throws SQLException {
        return this.cols.get(col - 1);
    }

    @Override
    public String getColumnName(int col) throws SQLException {
        return this.cols.get(col - 1);
    }

    @Override
    public String getSchemaName(int col) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int col) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int col) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int col) throws SQLException {
        return this.tbls != null ? this.tbls.get(col - 1) : "";
    }

    @Override
    public String getCatalogName(int col) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int col) throws SQLException {
        return JdbcUtils.type(this.types.get(col - 1));
    }

    @Override
    public String getColumnTypeName(int col) throws SQLException {
        return JdbcUtils.typeName(this.types.get(col - 1));
    }

    @Override
    public boolean isReadOnly(int col) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int col) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int col) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int col) throws SQLException {
        return this.types.get(col - 1);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Result set meta data is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == ResultSetMetaData.class;
    }
}

