/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

class CacheLockImpl<K, V>
implements Lock {
    private final GridCacheGateway<K, V> gate;
    private final IgniteInternalCache<K, V> delegate;
    private final CacheOperationContext opCtx;
    private final Collection<? extends K> keys;
    private int cntr;
    private volatile Thread lockedThread;

    CacheLockImpl(GridCacheGateway<K, V> gate, IgniteInternalCache<K, V> delegate, CacheOperationContext opCtx, Collection<? extends K> keys) {
        this.gate = gate;
        this.delegate = delegate;
        this.opCtx = opCtx;
        this.keys = keys;
    }

    @Override
    public void lock() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.checkTx();
            this.delegate.lockAll(this.keys, 0L);
            this.incrementLockCounter();
        }
        catch (IgniteCheckedException e) {
            throw new CacheException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    private void incrementLockCounter() {
        assert (this.lockedThread == null && this.cntr == 0 || this.lockedThread == Thread.currentThread() && this.cntr > 0);
        ++this.cntr;
        this.lockedThread = Thread.currentThread();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean tryLock() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.checkTx();
            boolean res = this.delegate.lockAll(this.keys, -1L);
            if (res) {
                this.incrementLockCounter();
            }
            boolean bl = res;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (time <= 0L) {
            return this.tryLock();
        }
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.checkTx();
            IgniteInternalFuture<Boolean> fut = this.delegate.lockAllAsync(this.keys, unit.toMillis(time));
            try {
                boolean res = fut.get();
                if (res) {
                    this.incrementLockCounter();
                }
                boolean bl = res;
                return bl;
            }
            catch (IgniteInterruptedCheckedException e) {
                block14: {
                    if (fut.cancel() || !fut.isDone()) break block14;
                    Boolean res = fut.get();
                    Thread.currentThread().interrupt();
                    if (res.booleanValue()) {
                        this.incrementLockCounter();
                    }
                    boolean bl = res;
                    this.gate.leave(prev);
                    return bl;
                }
                try {
                    if (e.getCause() instanceof InterruptedException) {
                        throw (InterruptedException)e.getCause();
                    }
                    throw new InterruptedException();
                }
                catch (IgniteCheckedException e2) {
                    throw new CacheException(e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void unlock() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            if (this.lockedThread != Thread.currentThread()) {
                throw new IllegalStateException("Failed to unlock keys (did current thread acquire lock with this lock instance?).");
            }
            assert (this.cntr > 0);
            --this.cntr;
            if (this.cntr == 0) {
                this.lockedThread = null;
            }
            this.delegate.unlockAll(this.keys);
        }
        catch (IgniteCheckedException e) {
            throw new CacheException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    @NotNull
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    private void checkTx() throws CacheException {
        if (this.delegate.context().tm().inUserTx()) {
            throw new CacheException("Explicit lock can't be acquired within a transaction.");
        }
    }

    public String toString() {
        return S.toString(CacheLockImpl.class, this);
    }
}

