/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataHolder;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class BinaryMetadataFileStore {
    private File workDir;
    private final ConcurrentMap<Integer, BinaryMetadataHolder> metadataLocCache;
    private final GridKernalContext ctx;
    private final IgniteLogger log;

    BinaryMetadataFileStore(ConcurrentMap<Integer, BinaryMetadataHolder> metadataLocCache, GridKernalContext ctx, IgniteLogger log, @Nullable File binaryMetadataFileStoreDir) throws IgniteCheckedException {
        this.metadataLocCache = metadataLocCache;
        this.ctx = ctx;
        this.log = log;
        if (!CU.isPersistenceEnabled(ctx.config())) {
            return;
        }
        if (binaryMetadataFileStoreDir != null) {
            this.workDir = binaryMetadataFileStoreDir;
        } else {
            String subFolder = ctx.pdsFolderResolver().resolveFolders().folderName();
            this.workDir = new File(U.resolveWorkDirectory(ctx.config().getWorkDirectory(), "binary_meta", false), subFolder);
        }
        U.ensureDirectory(this.workDir, "directory for serialized binary metadata", log);
    }

    void writeMetadata(BinaryMetadata binMeta) {
        if (!CU.isPersistenceEnabled(this.ctx.config())) {
            return;
        }
        try {
            File file = new File(this.workDir, Integer.toString(binMeta.typeId()) + ".bin");
            try (FileOutputStream out = new FileOutputStream(file, false);){
                byte[] marshalled = U.marshal(this.ctx, (Object)binMeta);
                out.write(marshalled);
            }
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to save metadata for typeId: " + binMeta.typeId() + "; exception was thrown: " + e.getMessage());
        }
    }

    void restoreMetadata() {
        if (!CU.isPersistenceEnabled(this.ctx.config())) {
            return;
        }
        for (File file : this.workDir.listFiles()) {
            try (FileInputStream in = new FileInputStream(file);){
                BinaryMetadata meta = (BinaryMetadata)U.unmarshal(this.ctx.config().getMarshaller(), in, U.resolveClassLoader(this.ctx.config()));
                this.metadataLocCache.put(meta.typeId(), new BinaryMetadataHolder(meta, 0, 0));
            }
            catch (Exception e) {
                U.warn(this.log, "Failed to restore metadata from file: " + file.getName() + "; exception was thrown: " + e.getMessage());
            }
        }
    }

    void mergeAndWriteMetadata(BinaryMetadata binMeta) {
        BinaryMetadata existingMeta = this.readMetadata(binMeta.typeId());
        if (existingMeta != null) {
            BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(existingMeta, binMeta);
            this.writeMetadata(mergedMeta);
        } else {
            this.writeMetadata(binMeta);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BinaryMetadata readMetadata(int typeId) {
        File file = new File(this.workDir, Integer.toString(typeId) + ".bin");
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(file);){
            BinaryMetadata binaryMetadata = (BinaryMetadata)U.unmarshal(this.ctx.config().getMarshaller(), in, U.resolveClassLoader(this.ctx.config()));
            return binaryMetadata;
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to restore metadata from file: " + file.getName() + "; exception was thrown: " + e.getMessage());
            return null;
        }
    }
}

