/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.UnregisteredClassException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.CacheStorePartialUpdateException;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateAtomicResult;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedSingleGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.DhtAtomicUpdateResult;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicDeferredUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicNearResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicSingleUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicCheckUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicUpdateResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearAtomicCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetResponse;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrExpirationInfo;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.nio.GridNioBackPressureControl;
import org.apache.ignite.internal.util.nio.GridNioMessageTracker;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.CO;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridDhtAtomicCache<K, V>
extends GridDhtCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;
    private static final int DEFERRED_UPDATE_RESPONSE_BUFFER_SIZE = Integer.getInteger("IGNITE_ATOMIC_DEFERRED_ACK_BUFFER_SIZE", 256);
    private static final int DEFERRED_UPDATE_RESPONSE_TIMEOUT = Integer.getInteger("IGNITE_ATOMIC_DEFERRED_ACK_TIMEOUT", 500);
    private final ThreadLocal<Map<UUID, GridDhtAtomicDeferredUpdateResponse>> defRes = new ThreadLocal<Map<UUID, GridDhtAtomicDeferredUpdateResponse>>(){

        @Override
        protected Map<UUID, GridDhtAtomicDeferredUpdateResponse> initialValue() {
            return new HashMap<UUID, GridDhtAtomicDeferredUpdateResponse>();
        }
    };
    @GridToStringExclude
    private UpdateReplyClosure updateReplyClos;
    private GridNearAtomicCache<K, V> near;
    private IgniteLogger msgLog;

    public GridDhtAtomicCache() {
    }

    public GridDhtAtomicCache(GridCacheContext<K, V> ctx) {
        super(ctx);
        this.msgLog = ctx.shared().atomicMessageLogger();
    }

    public GridDhtAtomicCache(GridCacheContext<K, V> ctx, GridCacheConcurrentMap map) {
        super(ctx, map);
        this.msgLog = ctx.shared().atomicMessageLogger();
    }

    @Override
    protected void checkJta() throws IgniteCheckedException {
    }

    @Override
    public boolean isDhtAtomic() {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.updateReplyClos = new UpdateReplyClosure(){

            @Override
            public void apply(GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
                if (req.writeSynchronizationMode() != CacheWriteSynchronizationMode.FULL_ASYNC) {
                    GridDhtAtomicCache.this.sendNearUpdateReply(res.nodeId(), res);
                } else if (res.remapTopologyVersion() != null) {
                    GridDhtAtomicCache.this.remapToNewPrimary(req);
                } else if (res.error() != null) {
                    U.error(GridDhtAtomicCache.this.log, "Failed to process write update request in FULL_ASYNC mode for keys: " + res.failedKeys(), res.error());
                }
            }
        };
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        CacheMetricsImpl m = new CacheMetricsImpl(this.ctx);
        if (this.ctx.dht().near() != null) {
            m.delegate(this.ctx.dht().near().metrics0());
        }
        this.metrics = m;
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearGetRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearGetRequest>(){

            @Override
            public void apply(UUID nodeId, GridNearGetRequest req) {
                GridDhtAtomicCache.this.processNearGetRequest(nodeId, req);
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearSingleGetRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearSingleGetRequest>(){

            @Override
            public void apply(UUID nodeId, GridNearSingleGetRequest req) {
                GridDhtAtomicCache.this.processNearSingleGetRequest(nodeId, req);
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearAtomicAbstractUpdateRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearAtomicAbstractUpdateRequest>(){

            @Override
            public void apply(UUID nodeId, GridNearAtomicAbstractUpdateRequest req) {
                GridDhtAtomicCache.this.processNearAtomicUpdateRequest(nodeId, req);
            }

            public String toString() {
                return "GridNearAtomicAbstractUpdateRequest handler [msgIdx=" + GridNearAtomicAbstractUpdateRequest.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearAtomicUpdateResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearAtomicUpdateResponse>(){

            @Override
            public void apply(UUID nodeId, GridNearAtomicUpdateResponse res) {
                GridDhtAtomicCache.this.processNearAtomicUpdateResponse(nodeId, res);
            }

            public String toString() {
                return "GridNearAtomicUpdateResponse handler [msgIdx=" + GridNearAtomicUpdateResponse.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridDhtAtomicAbstractUpdateRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridDhtAtomicAbstractUpdateRequest>(){

            @Override
            public void apply(UUID nodeId, GridDhtAtomicAbstractUpdateRequest req) {
                GridDhtAtomicCache.this.processDhtAtomicUpdateRequest(nodeId, req);
            }

            public String toString() {
                return "GridDhtAtomicUpdateRequest handler [msgIdx=" + GridDhtAtomicUpdateRequest.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridDhtAtomicUpdateResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridDhtAtomicUpdateResponse>(){

            @Override
            public void apply(UUID nodeId, GridDhtAtomicUpdateResponse res) {
                GridDhtAtomicCache.this.processDhtAtomicUpdateResponse(nodeId, res);
            }

            public String toString() {
                return "GridDhtAtomicUpdateResponse handler [msgIdx=" + GridDhtAtomicUpdateResponse.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridDhtAtomicDeferredUpdateResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridDhtAtomicDeferredUpdateResponse>(){

            @Override
            public void apply(UUID nodeId, GridDhtAtomicDeferredUpdateResponse res) {
                GridDhtAtomicCache.this.processDhtAtomicDeferredUpdateResponse(nodeId, res);
            }

            public String toString() {
                return "GridDhtAtomicDeferredUpdateResponse handler [msgIdx=" + GridDhtAtomicDeferredUpdateResponse.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridDhtAtomicNearResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridDhtAtomicNearResponse>(){

            @Override
            public void apply(UUID uuid, GridDhtAtomicNearResponse msg) {
                GridDhtAtomicCache.this.processDhtAtomicNearResponse(uuid, msg);
            }

            public String toString() {
                return "GridDhtAtomicNearResponse handler [msgIdx=" + GridDhtAtomicNearResponse.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearAtomicCheckUpdateRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearAtomicCheckUpdateRequest>(){

            @Override
            public void apply(UUID uuid, GridNearAtomicCheckUpdateRequest msg) {
                GridDhtAtomicCache.this.processCheckUpdateRequest(uuid, msg);
            }

            public String toString() {
                return "GridNearAtomicCheckUpdateRequest handler [msgIdx=" + GridNearAtomicCheckUpdateRequest.CACHE_MSG_IDX + ']';
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridDhtForceKeysRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new GridDhtCacheAdapter.MessageHandler<GridDhtForceKeysRequest>(){

            @Override
            public void onMessage(ClusterNode node, GridDhtForceKeysRequest msg) {
                GridDhtAtomicCache.this.processForceKeysRequest(node, msg);
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridDhtForceKeysResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new GridDhtCacheAdapter.MessageHandler<GridDhtForceKeysResponse>(){

            @Override
            public void onMessage(ClusterNode node, GridDhtForceKeysResponse msg) {
                GridDhtAtomicCache.this.processForceKeyResponse(node, msg);
            }
        });
        if (this.near == null) {
            this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearGetResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearGetResponse>(){

                @Override
                public void apply(UUID nodeId, GridNearGetResponse res) {
                    GridDhtAtomicCache.this.processNearGetResponse(nodeId, res);
                }
            });
            this.ctx.io().addCacheHandler(this.ctx.cacheId(), GridNearSingleGetResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridNearSingleGetResponse>(){

                @Override
                public void apply(UUID nodeId, GridNearSingleGetResponse res) {
                    GridDhtAtomicCache.this.processNearSingleGetResponse(nodeId, res);
                }
            });
        }
    }

    public void near(GridNearAtomicCache<K, V> near) {
        this.near = near;
    }

    @Override
    public GridNearCacheAdapter<K, V> near() {
        return this.near;
    }

    @Override
    protected IgniteInternalFuture<V> getAsync(final K key, final boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, final String taskName, final boolean deserializeBinary, final boolean skipVals, final boolean needVer) {
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (this.keyCheck) {
            this.validateCacheKey(key);
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final UUID subjId0 = subjId = this.ctx.subjectIdPerCall(null, opCtx);
        final ExpiryPolicy expiryPlc = skipVals ? null : (opCtx != null ? opCtx.expiry() : null);
        final boolean skipStore = opCtx != null && opCtx.skipStore();
        final boolean recovery = opCtx != null && opCtx.recovery();
        return this.asyncOp(new CO<IgniteInternalFuture<V>>(){

            @Override
            public IgniteInternalFuture<V> apply() {
                return GridDhtAtomicCache.this.getAsync0(GridDhtAtomicCache.this.ctx.toCacheKeyObject(key), forcePrimary, subjId0, taskName, deserializeBinary, recovery, expiryPlc, skipVals, skipStore, needVer);
            }
        });
    }

    @Override
    protected Map<K, V> getAll0(Collection<? extends K> keys, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return this.getAllAsyncInternal(keys, !this.ctx.config().isReadFromBackup(), null, this.ctx.kernalContext().job().currentTaskName(), deserializeBinary, opCtx != null && opCtx.recovery(), false, needVer, false).get();
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(@Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, @Nullable UUID subjId, String taskName, boolean deserializeBinary, boolean recovery, boolean skipVals, boolean needVer) {
        return this.getAllAsyncInternal(keys, forcePrimary, subjId, taskName, deserializeBinary, recovery, skipVals, needVer, true);
    }

    private IgniteInternalFuture<Map<K, V>> getAllAsyncInternal(final @Nullable Collection<? extends K> keys, final boolean forcePrimary, @Nullable UUID subjId, final String taskName, final boolean deserializeBinary, final boolean recovery, final boolean skipVals, final boolean needVer, boolean asyncOp) {
        boolean skipStore;
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture(Collections.emptyMap());
        }
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final UUID subjId0 = subjId = this.ctx.subjectIdPerCall(subjId, opCtx);
        final ExpiryPolicy expiryPlc = skipVals ? null : (opCtx != null ? opCtx.expiry() : null);
        boolean bl = skipStore = opCtx != null && opCtx.skipStore();
        if (asyncOp) {
            return this.asyncOp(new CO<IgniteInternalFuture<Map<K, V>>>(){

                @Override
                public IgniteInternalFuture<Map<K, V>> apply() {
                    return GridDhtAtomicCache.this.getAllAsync0(GridDhtAtomicCache.this.ctx.cacheKeysView(keys), forcePrimary, subjId0, taskName, deserializeBinary, recovery, expiryPlc, skipVals, skipStore, needVer);
                }
            });
        }
        return this.getAllAsync0(this.ctx.cacheKeysView(keys), forcePrimary, subjId0, taskName, deserializeBinary, recovery, expiryPlc, skipVals, skipStore, needVer);
    }

    @Override
    protected V getAndPut0(K key, V val, @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        return (V)this.update0(key, val, null, null, true, filter, false).get();
    }

    @Override
    protected boolean put0(K key, V val, CacheEntryPredicate filter) throws IgniteCheckedException {
        Boolean res = (Boolean)this.update0(key, val, null, null, false, filter, false).get();
        assert (res != null);
        return res;
    }

    @Override
    public IgniteInternalFuture<V> getAndPutAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.update0(key, val, null, null, true, filter, true);
    }

    @Override
    public IgniteInternalFuture<Boolean> putAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.update0(key, val, null, null, false, filter, true);
    }

    @Override
    protected void putAll0(Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        this.updateAll0(m, null, null, null, null, false, false, GridCacheOperation.UPDATE, false).get();
    }

    @Override
    public IgniteInternalFuture<?> putAllAsync0(Map<? extends K, ? extends V> m) {
        return this.updateAll0(m, null, null, null, null, false, false, GridCacheOperation.UPDATE, true).chain(RET2NULL);
    }

    @Override
    public void putAllConflict(Map<KeyCacheObject, GridCacheDrInfo> conflictMap) throws IgniteCheckedException {
        this.putAllConflictAsync(conflictMap).get();
    }

    @Override
    public IgniteInternalFuture<?> putAllConflictAsync(Map<KeyCacheObject, GridCacheDrInfo> conflictMap) {
        this.ctx.dr().onReceiveCacheEntriesReceived(conflictMap.size());
        return this.updateAll0(null, null, null, conflictMap, null, false, false, GridCacheOperation.UPDATE, true);
    }

    @Override
    public V getAndRemove0(K key) throws IgniteCheckedException {
        return (V)this.remove0(key, true, null, false).get();
    }

    @Override
    public IgniteInternalFuture<V> getAndRemoveAsync0(K key) {
        return this.remove0(key, true, null, true);
    }

    @Override
    protected void removeAll0(Collection<? extends K> keys) throws IgniteCheckedException {
        this.removeAllAsync0(keys, null, false, false, false).get();
    }

    @Override
    public IgniteInternalFuture<Object> removeAllAsync0(Collection<? extends K> keys) {
        return this.removeAllAsync0(keys, null, false, false, true).chain(RET2NULL);
    }

    @Override
    protected boolean remove0(K key, CacheEntryPredicate filter) throws IgniteCheckedException {
        return (Boolean)this.remove0(key, false, filter, false).get();
    }

    @Override
    public IgniteInternalFuture<Boolean> removeAsync0(K key, @Nullable CacheEntryPredicate filter) {
        return this.remove0(key, false, filter, true);
    }

    @Override
    public void removeAllConflict(Map<KeyCacheObject, GridCacheVersion> conflictMap) throws IgniteCheckedException {
        this.removeAllConflictAsync(conflictMap).get();
    }

    @Override
    public IgniteInternalFuture<?> removeAllConflictAsync(Map<KeyCacheObject, GridCacheVersion> conflictMap) {
        this.ctx.dr().onReceiveCacheEntriesReceived(conflictMap.size());
        return this.removeAllAsync0(null, conflictMap, false, false, true);
    }

    private boolean writeThrough() {
        return this.ctx.writeThrough() && this.ctx.store().configured();
    }

    private <T> IgniteInternalFuture<T> asyncOp(CO<IgniteInternalFuture<T>> op) {
        IgniteInternalFuture fail = this.asyncOpAcquire(false);
        if (fail != null) {
            return fail;
        }
        IgniteInternalFuture f = (IgniteInternalFuture)op.apply();
        f.listen(new CI1<IgniteInternalFuture<?>>(){

            @Override
            public void apply(IgniteInternalFuture<?> f) {
                GridDhtAtomicCache.this.asyncOpRelease(false);
            }
        });
        return f;
    }

    @Override
    protected IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> keys, long timeout, @Nullable IgniteTxLocalEx tx, boolean isInvalidate, boolean isRead, boolean retval, @Nullable TransactionIsolation isolation, long createTtl, long accessTtl) {
        return new FinishedLockFuture(new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)"));
    }

    @Override
    public <T> EntryProcessorResult<T> invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        IgniteInternalFuture<EntryProcessorResult<T>> invokeFut = this.invoke0(false, key, entryProcessor, args);
        return invokeFut.get();
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.invokeAll0(false, keys, entryProcessor, args).get();
    }

    @Override
    public <T> IgniteInternalFuture<EntryProcessorResult<T>> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.invoke0(true, key, entryProcessor, args);
    }

    private <T> IgniteInternalFuture<EntryProcessorResult<T>> invoke0(boolean async, K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        boolean statsEnabled;
        A.notNull(key, "key", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKey(key);
        }
        final long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        IgniteInternalFuture fut = this.update0(key, null, entryProcessor, args, false, null, async);
        return fut.chain(new CX1<IgniteInternalFuture<Map<K, EntryProcessorResult<T>>>, EntryProcessorResult<T>>(){

            @Override
            public EntryProcessorResult<T> applyx(IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> fut) throws IgniteCheckedException {
                Map resMap = fut.get();
                if (statsEnabled) {
                    GridDhtAtomicCache.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                if (resMap != null) {
                    CacheInvokeResult invokeRes;
                    CacheInvokeResult<Object> res;
                    assert (resMap.isEmpty() || resMap.size() == 1) : resMap.size();
                    CacheInvokeResult cacheInvokeResult = res = resMap.isEmpty() ? new CacheInvokeResult() : resMap.values().iterator().next();
                    if (res instanceof CacheInvokeResult && (invokeRes = res).result() != null) {
                        res = CacheInvokeResult.fromResult(GridDhtAtomicCache.this.ctx.unwrapBinaryIfNeeded(invokeRes.result(), keepBinary, false));
                    }
                    return res;
                }
                return new CacheInvokeResult();
            }
        });
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        return this.invokeAll0(true, keys, entryProcessor, args);
    }

    private <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAll0(boolean async, Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        boolean statsEnabled;
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        final long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor>(){

            @Override
            public EntryProcessor apply(K k) {
                return entryProcessor;
            }
        }, new IgnitePredicate[0]);
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        IgniteInternalFuture resFut = this.updateAll0(null, invokeMap, args, null, null, false, false, GridCacheOperation.TRANSFORM, async);
        return resFut.chain(new CX1<IgniteInternalFuture<Map<K, EntryProcessorResult<T>>>, Map<K, EntryProcessorResult<T>>>(){

            @Override
            public Map<K, EntryProcessorResult<T>> applyx(IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> fut) throws IgniteCheckedException {
                Map<Object, EntryProcessorResult> resMap = fut.get();
                if (statsEnabled) {
                    GridDhtAtomicCache.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                return GridDhtAtomicCache.this.ctx.unwrapInvokeResult(resMap, keepBinary);
            }
        });
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws IgniteCheckedException {
        boolean statsEnabled;
        A.notNull(map, "map");
        if (this.keyCheck) {
            this.validateCacheKeys(map.keySet());
        }
        long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        Map updateResults = (Map)this.updateAll0(null, map, args, null, null, false, false, GridCacheOperation.TRANSFORM, false).get();
        if (statsEnabled) {
            this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
        }
        return updateResults;
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        boolean statsEnabled;
        A.notNull(map, "map");
        if (this.keyCheck) {
            this.validateCacheKeys(map.keySet());
        }
        long start = (statsEnabled = this.ctx.statisticsEnabled()) ? System.nanoTime() : 0L;
        IgniteInternalFuture updateResults = this.updateAll0(null, map, args, null, null, false, false, GridCacheOperation.TRANSFORM, true);
        if (statsEnabled) {
            updateResults.listen(new GridCacheAdapter.InvokeAllTimeStatClosure(this.metrics0(), start));
        }
        return updateResults;
    }

    private IgniteInternalFuture updateAll0(@Nullable Map<? extends K, ? extends V> map, @Nullable Map<? extends K, ? extends EntryProcessor> invokeMap, @Nullable Object[] invokeArgs, @Nullable Map<KeyCacheObject, GridCacheDrInfo> conflictPutMap, @Nullable Map<KeyCacheObject, GridCacheVersion> conflictRmvMap, boolean retval, boolean rawRetval, GridCacheOperation op, boolean async) {
        assert (this.ctx.updatesAllowed());
        if (map != null && this.keyCheck) {
            this.validateCacheKeys(map.keySet());
        }
        this.ctx.checkSecurity(SecurityPermission.CACHE_PUT);
        final CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        if (opCtx != null && opCtx.hasDataCenterId()) {
            assert (conflictPutMap == null) : conflictPutMap;
            assert (conflictRmvMap == null) : conflictRmvMap;
            if (op == GridCacheOperation.TRANSFORM) {
                assert (invokeMap != null) : invokeMap;
                conflictPutMap = F.viewReadOnly(invokeMap, new IgniteClosure<EntryProcessor, GridCacheDrInfo>(){

                    @Override
                    public GridCacheDrInfo apply(EntryProcessor o) {
                        return new GridCacheDrInfo(o, GridDhtAtomicCache.this.ctx.versions().next(opCtx.dataCenterId()));
                    }
                }, new IgnitePredicate[0]);
                invokeMap = null;
            } else if (op == GridCacheOperation.DELETE) {
                assert (map != null) : map;
                conflictRmvMap = F.viewReadOnly(map, new IgniteClosure<V, GridCacheVersion>(){

                    @Override
                    public GridCacheVersion apply(V o) {
                        return GridDhtAtomicCache.this.ctx.versions().next(opCtx.dataCenterId());
                    }
                }, new IgnitePredicate[0]);
                map = null;
            } else {
                assert (map != null) : map;
                conflictPutMap = F.viewReadOnly(map, new IgniteClosure<V, GridCacheDrInfo>(){

                    @Override
                    public GridCacheDrInfo apply(V o) {
                        return new GridCacheDrInfo(GridDhtAtomicCache.this.ctx.toCacheObject(o), GridDhtAtomicCache.this.ctx.versions().next(opCtx.dataCenterId()));
                    }
                }, new IgnitePredicate[0]);
                map = null;
            }
        }
        UUID subjId = this.ctx.subjectIdPerCall(null, opCtx);
        int taskNameHash = this.ctx.kernalContext().job().currentTaskNameHash();
        final GridNearAtomicUpdateFuture updateFut = new GridNearAtomicUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), op, map != null ? map.keySet() : (invokeMap != null ? invokeMap.keySet() : (conflictPutMap != null ? conflictPutMap.keySet() : conflictRmvMap.keySet())), map != null ? map.values() : (invokeMap != null ? invokeMap.values() : null), invokeArgs, conflictPutMap != null ? conflictPutMap.values() : null, conflictRmvMap != null ? conflictRmvMap.values() : null, retval, rawRetval, opCtx != null ? opCtx.expiry() : null, CU.filterArray(null), subjId, taskNameHash, opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.recovery(), opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES);
        if (async) {
            return this.asyncOp(new CO<IgniteInternalFuture<Object>>(){

                @Override
                public IgniteInternalFuture<Object> apply() {
                    updateFut.map();
                    return updateFut;
                }
            });
        }
        updateFut.map();
        return updateFut;
    }

    private IgniteInternalFuture update0(K key, @Nullable V val, @Nullable EntryProcessor proc, @Nullable Object[] invokeArgs, boolean retval, @Nullable CacheEntryPredicate filter, boolean async) {
        assert (val == null || proc == null);
        assert (this.ctx.updatesAllowed());
        this.validateCacheKey(key);
        this.ctx.checkSecurity(SecurityPermission.CACHE_PUT);
        final GridNearAtomicAbstractUpdateFuture updateFut = this.createSingleUpdateFuture(key, val, proc, invokeArgs, retval, filter);
        if (async) {
            return this.asyncOp(new CO<IgniteInternalFuture<Object>>(){

                @Override
                public IgniteInternalFuture<Object> apply() {
                    updateFut.map();
                    return updateFut;
                }
            });
        }
        updateFut.map();
        return updateFut;
    }

    private IgniteInternalFuture remove0(K key, boolean retval, @Nullable CacheEntryPredicate filter, boolean async) {
        assert (this.ctx.updatesAllowed());
        this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        final GridNearAtomicAbstractUpdateFuture updateFut = this.createSingleUpdateFuture(key, null, null, null, retval, filter);
        if (async) {
            return this.asyncOp(new CO<IgniteInternalFuture<Object>>(){

                @Override
                public IgniteInternalFuture<Object> apply() {
                    updateFut.map();
                    return updateFut;
                }
            });
        }
        updateFut.map();
        return updateFut;
    }

    private GridNearAtomicAbstractUpdateFuture createSingleUpdateFuture(K key, @Nullable V val, @Nullable EntryProcessor proc, @Nullable Object[] invokeArgs, boolean retval, @Nullable CacheEntryPredicate filter) {
        Object val0;
        GridCacheOperation op;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        if (val != null) {
            op = GridCacheOperation.UPDATE;
            val0 = val;
        } else if (proc != null) {
            op = GridCacheOperation.TRANSFORM;
            val0 = proc;
        } else {
            op = GridCacheOperation.DELETE;
            val0 = null;
        }
        GridCacheDrInfo conflictPutVal = null;
        GridCacheVersion conflictRmvVer = null;
        if (opCtx != null && opCtx.hasDataCenterId()) {
            Byte dcId = opCtx.dataCenterId();
            assert (dcId != null);
            if (op == GridCacheOperation.UPDATE) {
                conflictPutVal = new GridCacheDrInfo(this.ctx.toCacheObject(val), this.ctx.versions().next(dcId));
                val0 = null;
            } else if (op == GridCacheOperation.TRANSFORM) {
                conflictPutVal = new GridCacheDrInfo(proc, this.ctx.versions().next(dcId));
                val0 = null;
            } else {
                conflictRmvVer = this.ctx.versions().next(dcId);
            }
        }
        CacheEntryPredicate[] filters = CU.filterArray(filter);
        if (conflictPutVal == null && conflictRmvVer == null) {
            return new GridNearAtomicSingleUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), op, key, val0, invokeArgs, retval, false, opCtx != null ? opCtx.expiry() : null, filters, this.ctx.subjectIdPerCall(null, opCtx), this.ctx.kernalContext().job().currentTaskNameHash(), opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.recovery(), opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES);
        }
        return new GridNearAtomicUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), op, Collections.singletonList(key), val0 != null ? Collections.singletonList(val0) : null, invokeArgs, conflictPutVal != null ? Collections.singleton(conflictPutVal) : null, conflictRmvVer != null ? Collections.singleton(conflictRmvVer) : null, retval, false, opCtx != null ? opCtx.expiry() : null, filters, this.ctx.subjectIdPerCall(null, opCtx), this.ctx.kernalContext().job().currentTaskNameHash(), opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.recovery(), opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES);
    }

    private IgniteInternalFuture removeAllAsync0(@Nullable Collection<? extends K> keys, @Nullable Map<KeyCacheObject, GridCacheVersion> conflictMap, boolean retval, boolean rawRetval, boolean async) {
        assert (this.ctx.updatesAllowed());
        assert (keys != null || conflictMap != null);
        if (this.keyCheck) {
            this.validateCacheKeys(keys);
        }
        this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        final CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        UUID subjId = this.ctx.subjectIdPerCall(null, opCtx);
        int taskNameHash = this.ctx.kernalContext().job().currentTaskNameHash();
        Collection drVers = null;
        if (opCtx != null && keys != null && opCtx.hasDataCenterId()) {
            assert (conflictMap == null) : conflictMap;
            drVers = F.transform(keys, new C1<K, GridCacheVersion>(){

                @Override
                public GridCacheVersion apply(K k) {
                    return GridDhtAtomicCache.this.ctx.versions().next(opCtx.dataCenterId());
                }
            });
        }
        final GridNearAtomicUpdateFuture updateFut = new GridNearAtomicUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), GridCacheOperation.DELETE, keys != null ? keys : conflictMap.keySet(), null, null, null, (Collection<GridCacheVersion>)(drVers != null ? drVers : (keys != null ? null : conflictMap.values())), retval, rawRetval, opCtx != null ? opCtx.expiry() : null, CU.filterArray(null), subjId, taskNameHash, opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary(), opCtx != null && opCtx.recovery(), opCtx != null && opCtx.noRetries() ? 1 : MAX_RETRIES);
        if (async) {
            return this.asyncOp(new CO<IgniteInternalFuture<Object>>(){

                @Override
                public IgniteInternalFuture<Object> apply() {
                    updateFut.map();
                    return updateFut;
                }
            });
        }
        updateFut.map();
        return updateFut;
    }

    private IgniteInternalFuture<V> getAsync0(KeyCacheObject key, boolean forcePrimary, UUID subjId, String taskName, boolean deserializeBinary, boolean recovery, @Nullable ExpiryPolicy expiryPlc, boolean skipVals, boolean skipStore, boolean needVer) {
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        IgniteCacheExpiryPolicy expiry = skipVals ? null : this.expiryPolicy(expiryPlc);
        GridPartitionedSingleGetFuture fut = new GridPartitionedSingleGetFuture(this.ctx, key, topVer, !skipStore, forcePrimary, subjId, taskName, deserializeBinary, expiry, skipVals, needVer, false, recovery, null);
        fut.init();
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IgniteInternalFuture<Map<K, V>> getAllAsync0(@Nullable Collection<KeyCacheObject> keys, boolean forcePrimary, UUID subjId, String taskName, boolean deserializeBinary, boolean recovery, @Nullable ExpiryPolicy expiryPlc, boolean skipVals, boolean skipStore, boolean needVer) {
        IgniteCacheExpiryPolicy expiry;
        AffinityTopologyVersion topVer;
        block22: {
            boolean evt;
            topVer = this.ctx.affinity().affinityTopologyVersion();
            expiry = skipVals ? null : this.expiryPolicy(expiryPlc);
            boolean bl = evt = !skipVals;
            if (forcePrimary || !this.ctx.affinityNode()) break block22;
            try {
                HashMap locVals = U.newHashMap(keys.size());
                boolean success = true;
                boolean readNoEntry = this.ctx.readNoEntry(expiry, false);
                for (KeyCacheObject key : keys) {
                    block25: {
                        block23: {
                            block24: {
                                if (!readNoEntry) break block23;
                                CacheDataRow row = this.ctx.offheap().read(this.ctx, key);
                                if (row == null) break block24;
                                long expireTime = row.expireTime();
                                if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                                    this.ctx.addResult(locVals, key, row.value(), skipVals, false, deserializeBinary, true, null, row.version(), 0L, 0L, needVer);
                                    if (evt) {
                                        this.ctx.events().readEvent(key, null, row.value(), subjId, taskName, !deserializeBinary);
                                    }
                                    break block25;
                                } else {
                                    success = false;
                                }
                                break block25;
                            }
                            success = false;
                            break block25;
                        }
                        GridCacheEntryEx entry = null;
                        while (true) {
                            try {
                                entry = this.entryEx(key);
                                if (entry != null) {
                                    boolean isNew = entry.isNewLocked();
                                    EntryGetResult getRes = null;
                                    CacheObject v = null;
                                    GridCacheVersion ver = null;
                                    if (needVer) {
                                        getRes = entry.innerGetVersioned(null, null, false, evt, subjId, null, taskName, expiry, true, null, null);
                                        if (getRes != null) {
                                            v = (CacheObject)getRes.value();
                                            ver = getRes.version();
                                        }
                                    } else {
                                        v = entry.innerGet(null, null, false, false, evt, subjId, null, taskName, expiry, !deserializeBinary, null);
                                    }
                                    if (v == null) {
                                        if (isNew && entry.markObsoleteIfEmpty(this.context().versions().next())) {
                                            this.removeEntry(entry);
                                        }
                                        success = false;
                                        break;
                                    }
                                    this.ctx.addResult(locVals, key, v, skipVals, false, deserializeBinary, true, getRes, ver, 0L, 0L, needVer);
                                    break;
                                }
                                success = false;
                            }
                            catch (GridCacheEntryRemovedException isNew) {
                                continue;
                            }
                            catch (GridDhtInvalidPartitionException ignored) {
                                success = false;
                            }
                            finally {
                                if (entry == null) continue;
                                entry.touch(topVer);
                                continue;
                            }
                            break;
                        }
                    }
                    if (!success) break;
                    if (skipVals || !this.ctx.statisticsEnabled()) continue;
                    this.metrics0().onRead(true);
                }
                if (success) {
                    this.sendTtlUpdateRequest(expiry);
                    return new GridFinishedFuture<Map<K, V>>(locVals);
                }
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture<Map<K, V>>(e);
            }
        }
        if (expiry != null) {
            expiry.reset();
        }
        GridPartitionedGetFuture fut = new GridPartitionedGetFuture(this.ctx, keys, !skipStore, forcePrimary, subjId, taskName, deserializeBinary, recovery, expiry, skipVals, needVer, false, null);
        fut.init(topVer);
        return fut;
    }

    void updateAllAsyncInternal(final ClusterNode node, final GridNearAtomicAbstractUpdateRequest req, final UpdateReplyClosure completionCb) {
        GridDhtFuture<Object> forceFut = this.ctx.group().preloader().request(this.ctx, req, req.topologyVersion());
        if (forceFut == null || forceFut.isDone()) {
            try {
                if (forceFut != null) {
                    forceFut.get();
                }
            }
            catch (NodeStoppingException ignored) {
                return;
            }
            catch (IgniteCheckedException e) {
                this.onForceKeysError(node.id(), req, completionCb, e);
                return;
            }
            this.updateAllAsyncInternal0(node, req, completionCb);
        } else {
            forceFut.listen(new CI1<IgniteInternalFuture<Object>>(){

                @Override
                public void apply(IgniteInternalFuture<Object> fut) {
                    try {
                        fut.get();
                    }
                    catch (NodeStoppingException ignored) {
                        return;
                    }
                    catch (IgniteCheckedException e) {
                        GridDhtAtomicCache.this.onForceKeysError(node.id(), req, completionCb, e);
                        return;
                    }
                    GridDhtAtomicCache.this.updateAllAsyncInternal0(node, req, completionCb);
                }
            });
        }
    }

    private void onForceKeysError(UUID nodeId, GridNearAtomicAbstractUpdateRequest req, UpdateReplyClosure completionCb, IgniteCheckedException e) {
        GridNearAtomicUpdateResponse res = new GridNearAtomicUpdateResponse(this.ctx.cacheId(), nodeId, req.futureId(), req.partition(), false, this.ctx.deploymentEnabled());
        res.addFailedKeys(req.keys(), e);
        completionCb.apply(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void updateAllAsyncInternal0(ClusterNode node, GridNearAtomicAbstractUpdateRequest req, UpdateReplyClosure completionCb) {
        IgniteCacheExpiryPolicy expiry;
        GridDhtAtomicAbstractUpdateFuture dhtFut;
        GridNearAtomicUpdateResponse res;
        block50: {
            res = new GridNearAtomicUpdateResponse(this.ctx.cacheId(), node.id(), req.futureId(), req.partition(), false, this.ctx.deploymentEnabled());
            assert (!req.returnValue() || req.operation() == GridCacheOperation.TRANSFORM || req.size() == 1);
            dhtFut = null;
            expiry = null;
            this.ctx.shared().database().checkpointReadLock();
            try {
                Collection<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>> deleted;
                block49: {
                    this.ctx.shared().database().ensureFreeSpace(this.ctx.dataRegion());
                    List<GridDhtCacheEntry> locked = this.lockEntries(req, req.topologyVersion());
                    deleted = null;
                    DhtAtomicUpdateResult updDhtRes = new DhtAtomicUpdateResult();
                    try {
                        while (true) {
                            IgniteCacheObjectProcessor cacheObjProc;
                            GridDhtPartitionTopology top;
                            block47: {
                                top = this.topology();
                                top.readLock();
                                if (!top.stopping()) break block47;
                                res.addFailedKeys(req.keys(), new CacheStoppedException(this.name()));
                                completionCb.apply(req, res);
                                top.readUnlock();
                                return;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                            }
                            try {
                                try {
                                    boolean remap = false;
                                    if (!req.topologyLocked()) {
                                        boolean bl = remap = !top.topologyVersionFuture().exchangeDone() || this.needRemap(req.topologyVersion(), top.readyTopologyVersion());
                                    }
                                    if (!remap) {
                                        this.update(node, locked, req, res, updDhtRes);
                                        dhtFut = updDhtRes.dhtFuture();
                                        deleted = updDhtRes.deleted();
                                        expiry = updDhtRes.expiryPolicy();
                                    } else {
                                        res.remapTopologyVersion(top.lastTopologyChangeVersion());
                                    }
                                }
                                finally {
                                    top.readUnlock();
                                }
                                if (res.returnValue() == null) break;
                                res.returnValue().marshalResult(this.ctx);
                            }
                            catch (UnregisteredClassException ex) {
                                cacheObjProc = this.ctx.cacheObjects();
                                assert (cacheObjProc instanceof CacheObjectBinaryProcessorImpl);
                                ((CacheObjectBinaryProcessorImpl)cacheObjProc).binaryContext().descriptorForClass(ex.cls(), false, false);
                                continue;
                            }
                            catch (UnregisteredBinaryTypeException ex) {
                                cacheObjProc = this.ctx.cacheObjects();
                                assert (cacheObjProc instanceof CacheObjectBinaryProcessorImpl);
                                ((CacheObjectBinaryProcessorImpl)cacheObjProc).binaryContext().updateMetadata(ex.typeId(), ex.binaryMetadata(), false);
                                continue;
                            }
                            break;
                        }
                        if (locked == null) break block49;
                    }
                    catch (GridCacheEntryRemovedException e) {
                        assert (false) : "Entry should not become obsolete while holding lock.";
                        e.printStackTrace();
                        break block50;
                    }
                    finally {
                        if (locked != null) {
                            this.unlockEntries(locked, req.topologyVersion());
                        }
                        if (deleted != null) {
                            assert (!deleted.isEmpty());
                            assert (this.ctx.deferredDelete()) : this;
                            for (IgniteBiTuple e : deleted) {
                                this.ctx.onDeferredDelete((GridCacheEntryEx)e.get1(), (GridCacheVersion)e.get2());
                            }
                        }
                        if (this.ctx.shared().wal() != null) {
                            this.ctx.shared().wal().flush(null, false);
                        }
                    }
                    this.unlockEntries(locked, req.topologyVersion());
                }
                if (deleted != null) {
                    assert (!deleted.isEmpty());
                    assert (this.ctx.deferredDelete()) : this;
                    for (IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion> e : deleted) {
                        this.ctx.onDeferredDelete(e.get1(), e.get2());
                    }
                }
                if (this.ctx.shared().wal() != null) {
                    this.ctx.shared().wal().flush(null, false);
                }
            }
            catch (GridDhtInvalidPartitionException ignore) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Caught invalid partition exception for cache entry (will remap update request): " + req);
                }
                res.remapTopologyVersion(this.ctx.topology().lastTopologyChangeVersion());
            }
            catch (Throwable e) {
                U.error(this.log, "Unexpected exception during cache update", e);
                res.addFailedKeys(req.keys(), e);
                completionCb.apply(req, res);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                return;
            }
            finally {
                this.ctx.shared().database().checkpointReadUnlock();
            }
        }
        if (res.remapTopologyVersion() != null) {
            assert (dhtFut == null);
            completionCb.apply(req, res);
        } else if (dhtFut != null) {
            dhtFut.map(node, res.returnValue(), res, completionCb);
        }
        if (req.writeSynchronizationMode() != CacheWriteSynchronizationMode.FULL_ASYNC) {
            req.cleanup(!node.isLocal());
        }
        this.sendTtlUpdateRequest(expiry);
    }

    private DhtAtomicUpdateResult update(ClusterNode node, List<GridDhtCacheEntry> locked, GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res, DhtAtomicUpdateResult dhtUpdRes) throws GridCacheEntryRemovedException {
        boolean sndPrevVal;
        GridDhtPartitionTopology top = this.topology();
        String taskName = this.ctx.kernalContext().task().resolveTaskName(req.taskNameHash());
        boolean hasNear = req.nearCache();
        GridCacheVersion ver = this.ctx.versions().next(top.readyTopologyVersion());
        if (hasNear) {
            res.nearVersion(ver);
        }
        if (this.msgLog.isDebugEnabled()) {
            this.msgLog.debug("Assigned update version [futId=" + req.futureId() + ", writeVer=" + ver + ']');
        }
        assert (ver != null) : "Got null version for update request: " + req;
        boolean bl = sndPrevVal = !top.rebalanceFinished(req.topologyVersion());
        if (dhtUpdRes.dhtFuture() == null) {
            dhtUpdRes.dhtFuture(this.createDhtFuture(ver, req));
        }
        IgniteCacheExpiryPolicy expiry = this.expiryPolicy(req.expiry());
        GridCacheReturn retVal = null;
        if (req.size() > 1 && this.writeThrough() && !req.skipStore() && !this.ctx.store().isLocal() && !this.ctx.dr().receiveEnabled()) {
            this.updateWithBatch(node, hasNear, req, res, locked, ver, this.ctx.isDrEnabled(), taskName, expiry, sndPrevVal, dhtUpdRes);
            if (req.operation() == GridCacheOperation.TRANSFORM) {
                retVal = dhtUpdRes.returnValue();
            }
        } else {
            this.updateSingle(node, hasNear, req, res, locked, ver, this.ctx.isDrEnabled(), taskName, expiry, sndPrevVal, dhtUpdRes);
            retVal = dhtUpdRes.returnValue();
        }
        GridDhtAtomicAbstractUpdateFuture dhtFut = dhtUpdRes.dhtFuture();
        if (retVal == null) {
            retVal = new GridCacheReturn(this.ctx, node.isLocal(), true, null, true);
        }
        res.returnValue(retVal);
        if (dhtFut != null) {
            IgniteRunnable tracker;
            if (req.writeSynchronizationMode() == CacheWriteSynchronizationMode.PRIMARY_SYNC && !this.ctx.discovery().cacheGroupAffinityNode(node, this.ctx.groupId()) && !dhtFut.isDone() && (tracker = GridNioBackPressureControl.threadTracker()) instanceof GridNioMessageTracker) {
                ((GridNioMessageTracker)tracker).onMessageReceived();
                dhtFut.listen(new IgniteInClosure<IgniteInternalFuture<Void>>(){

                    @Override
                    public void apply(IgniteInternalFuture<Void> fut) {
                        ((GridNioMessageTracker)tracker).onMessageProcessed();
                    }
                });
            }
            this.ctx.mvcc().addAtomicFuture(dhtFut.id(), dhtFut);
        }
        dhtUpdRes.expiryPolicy(expiry);
        return dhtUpdRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void updateWithBatch(ClusterNode node, boolean hasNear, GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res, List<GridDhtCacheEntry> locked, GridCacheVersion ver, boolean replicate, String taskName, @Nullable IgniteCacheExpiryPolicy expiry, boolean sndPrevVal, DhtAtomicUpdateResult dhtUpdRes) throws GridCacheEntryRemovedException {
        if (!GridDhtAtomicCache.$assertionsDisabled && this.ctx.dr().receiveEnabled()) {
            throw new AssertionError();
        }
        if (!GridDhtAtomicCache.$assertionsDisabled && req.returnValue() && req.operation() != GridCacheOperation.TRANSFORM) {
            throw new AssertionError();
        }
        if (!F.isEmpty(req.filter()) && this.ctx.loadPreviousValue()) {
            try {
                this.reloadIfNeeded(locked);
            }
            catch (IgniteCheckedException e) {
                res.addFailedKeys(req.keys(), e);
                return;
            }
        }
        size = req.size();
        putMap = null;
        entryProcessorMap = null;
        rmvKeys = null;
        writeVals = null;
        filtered /* !! */  = new ArrayList<GridDhtCacheEntry>(size);
        op = req.operation();
        invokeRes = null;
        firstEntryIdx = 0;
        intercept = this.ctx.config().getInterceptor() != null;
        for (i = dhtUpdRes.processedEntriesCount(); i < locked.size(); ++i) {
            entry = locked.get(i);
            try {
                block49: {
                    block48: {
                        block45: {
                            block43: {
                                block44: {
                                    if (!this.checkFilter(entry, req, res)) {
                                        if (expiry != null && entry.hasValue() && (ttl = expiry.forAccess()) != -1L) {
                                            entry.updateTtl(null, ttl);
                                            expiry.ttlUpdated(entry.key(), entry.version(), entry.readers());
                                        }
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Entry did not pass the filter (will skip write) [entry=" + entry + ", filter=" + Arrays.toString(req.filter()) + ", res=" + res + ']');
                                        }
                                        if (hasNear) {
                                            res.addSkippedIndex(i);
                                        }
                                        ++firstEntryIdx;
                                        continue;
                                    }
                                    if (op != GridCacheOperation.TRANSFORM) break block48;
                                    entryProcessor = req.entryProcessor(i);
                                    old = entry.innerGet(ver, null, true, true, true, req.subjectId(), entryProcessor, taskName, null, req.keepBinary(), null);
                                    oldVal = null;
                                    updatedVal = null;
                                    invokeEntry = new CacheInvokeEntry<K, V>(entry.key(), old, entry.version(), req.keepBinary(), entry);
                                    updated = null;
                                    if (invokeRes == null) {
                                        invokeRes = new GridCacheReturn(node.isLocal());
                                    }
                                    curInvokeRes = null;
                                    validation = false;
                                    IgniteThread.onEntryProcessorEntered(true);
                                    computed = entryProcessor.process(invokeEntry, req.invokeArguments());
                                    if (computed != null) {
                                        computed = this.ctx.unwrapTemporary(computed);
                                        curInvokeRes = CacheInvokeResult.fromResult(computed);
                                    }
                                    if (invokeEntry.modified()) break block43;
                                    if (!this.ctx.statisticsEnabled()) break block44;
                                    this.ctx.cache().metrics0().onReadOnlyInvoke(old != null);
                                }
                                IgniteThread.onEntryProcessorLeft();
                                if (curInvokeRes == null) continue;
                                invokeRes.addEntryProcessResult(this.ctx, entry.key(), invokeEntry.key(), curInvokeRes.result(), curInvokeRes.error(), req.keepBinary());
                                continue;
                            }
                            try {
                                updatedVal = (V)this.ctx.unwrapTemporary(invokeEntry.getValue());
                                updated = this.ctx.toCacheObject(updatedVal);
                                validation = true;
                                if (updated == null) break block45;
                                this.ctx.validateKeyAndValue(entry.key(), updated);
                            }
                            catch (Exception e) {
                                block46: {
                                    try {
                                        if (e instanceof UnregisteredClassException || e instanceof UnregisteredBinaryTypeException) {
                                            throw (IgniteException)e;
                                        }
                                        curInvokeRes = CacheInvokeResult.fromError(e);
                                        updated = old;
                                        if (!validation) break block46;
                                        res.addSkippedIndex(i);
                                    }
                                    catch (Throwable var33_40) {
                                        IgniteThread.onEntryProcessorLeft();
                                        if (curInvokeRes != null) {
                                            invokeRes.addEntryProcessResult(this.ctx, entry.key(), invokeEntry.key(), curInvokeRes.result(), curInvokeRes.error(), req.keepBinary());
                                        }
                                        throw var33_40;
                                    }
                                    IgniteThread.onEntryProcessorLeft();
                                    if (curInvokeRes == null) continue;
                                    invokeRes.addEntryProcessResult(this.ctx, entry.key(), invokeEntry.key(), curInvokeRes.result(), curInvokeRes.error(), req.keepBinary());
                                    continue;
                                }
                                IgniteThread.onEntryProcessorLeft();
                                if (curInvokeRes != null) {
                                    invokeRes.addEntryProcessResult(this.ctx, entry.key(), invokeEntry.key(), curInvokeRes.result(), curInvokeRes.error(), req.keepBinary());
                                } else {
                                    ** GOTO lbl94
                                }
                            }
                        }
                        IgniteThread.onEntryProcessorLeft();
                        if (curInvokeRes != null) {
                            invokeRes.addEntryProcessResult(this.ctx, entry.key(), invokeEntry.key(), curInvokeRes.result(), curInvokeRes.error(), req.keepBinary());
                        }
                        if (updated == null) {
                            if (intercept) {
                                e = new CacheLazyEntry<K, Object>(this.ctx, entry.key(), invokeEntry.key(), old, oldVal, req.keepBinary());
                                interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(e);
                                if (this.ctx.cancelRemove(interceptorRes)) continue;
                            }
                            if (putMap != null) {
                                this.updatePartialBatch(hasNear, firstEntryIdx, filtered /* !! */ , ver, node, writeVals, putMap, null, entryProcessorMap, req, res, replicate, dhtUpdRes, taskName, expiry, sndPrevVal);
                                firstEntryIdx = i;
                                putMap = null;
                                writeVals = null;
                                entryProcessorMap = null;
                                filtered /* !! */  = new ArrayList<E>();
                            }
                            if (rmvKeys == null) {
                                rmvKeys = new ArrayList<E>(size);
                            }
                            rmvKeys.add(entry.key());
                        } else {
                            if (intercept) {
                                e = new CacheLazyEntry<K, Object>(this.ctx, entry.key(), invokeEntry.key(), old, oldVal, req.keepBinary());
                                val = this.ctx.config().getInterceptor().onBeforePut(e, updatedVal);
                                if (val == null) continue;
                                updated = this.ctx.toCacheObject(this.ctx.unwrapTemporary(val));
                            }
                            if (rmvKeys != null) {
                                this.updatePartialBatch(hasNear, firstEntryIdx, filtered /* !! */ , ver, node, null, null, rmvKeys, entryProcessorMap, req, res, replicate, dhtUpdRes, taskName, expiry, sndPrevVal);
                                firstEntryIdx = i;
                                rmvKeys = null;
                                entryProcessorMap = null;
                                filtered /* !! */  = new ArrayList<E>();
                            }
                            if (putMap == null) {
                                putMap = new LinkedHashMap<K, V>(size, 1.0f);
                                writeVals = new ArrayList<E>(size);
                            }
                            putMap.put(entry.key(), updated);
                            writeVals.add(updated);
                        }
                        if (entryProcessorMap == null) {
                            entryProcessorMap = new HashMap<KeyCacheObject, EntryProcessor<Object, Object, Object>>();
                        }
                        entryProcessorMap.put(entry.key(), entryProcessor);
                        break block49;
                    }
                    if (op == GridCacheOperation.UPDATE) {
                        updated = req.value(i);
                        if (intercept) {
                            old = entry.innerGet(null, null, this.ctx.loadPreviousValue(), true, true, req.subjectId(), null, taskName, null, req.keepBinary(), null);
                            val = this.ctx.config().getInterceptor().onBeforePut(new CacheLazyEntry<K, CacheObject>(this.ctx, entry.key(), old, req.keepBinary()), this.ctx.unwrapBinaryIfNeeded(updated, req.keepBinary(), false));
                            if (val == null) continue;
                            updated = this.ctx.toCacheObject(this.ctx.unwrapTemporary(val));
                        }
                        if (!GridDhtAtomicCache.$assertionsDisabled && updated == null) {
                            throw new AssertionError();
                        }
                        this.ctx.validateKeyAndValue(entry.key(), updated);
                        if (putMap == null) {
                            putMap = new LinkedHashMap<KeyCacheObject, CacheObject>(size, 1.0f);
                            writeVals = new ArrayList<CacheObject>(size);
                        }
                        putMap.put(entry.key(), updated);
                        writeVals.add(updated);
                    } else {
                        if (!GridDhtAtomicCache.$assertionsDisabled && op != GridCacheOperation.DELETE) {
                            throw new AssertionError();
                        }
                        if (intercept) {
                            old = entry.innerGet(null, null, this.ctx.loadPreviousValue(), true, true, req.subjectId(), null, taskName, null, req.keepBinary(), null);
                            interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry<K, CacheObject>(this.ctx, entry.key(), old, req.keepBinary()));
                            if (this.ctx.cancelRemove(interceptorRes)) continue;
                        }
                        if (rmvKeys == null) {
                            rmvKeys = new ArrayList<KeyCacheObject>(size);
                        }
                        rmvKeys.add(entry.key());
                    }
                }
                filtered /* !! */ .add(entry);
                continue;
            }
            catch (IgniteCheckedException e) {
                res.addFailedKey(entry.key(), e);
            }
        }
        if (putMap != null || rmvKeys != null) {
            this.updatePartialBatch(hasNear, firstEntryIdx, filtered /* !! */ , ver, node, writeVals, putMap, rmvKeys, entryProcessorMap, req, res, replicate, dhtUpdRes, taskName, expiry, sndPrevVal);
        } else if (!GridDhtAtomicCache.$assertionsDisabled && !filtered /* !! */ .isEmpty()) {
            throw new AssertionError();
        }
        dhtUpdRes.returnValue(invokeRes);
    }

    private void reloadIfNeeded(final List<GridDhtCacheEntry> entries) throws IgniteCheckedException {
        HashMap<KeyCacheObject, Integer> needReload = null;
        for (int i = 0; i < entries.size(); ++i) {
            CacheObject val;
            GridDhtCacheEntry entry = entries.get(i);
            if (entry == null || (val = entry.rawGet()) != null) continue;
            if (needReload == null) {
                needReload = new HashMap<KeyCacheObject, Integer>(entries.size(), 1.0f);
            }
            needReload.put(entry.key(), i);
        }
        if (needReload != null) {
            final HashMap<KeyCacheObject, Integer> idxMap = needReload;
            this.ctx.store().loadAll(null, needReload.keySet(), (IgniteBiInClosure<KeyCacheObject, Object>)new CI2<KeyCacheObject, Object>(){

                @Override
                public void apply(KeyCacheObject k, Object v) {
                    Integer idx = (Integer)idxMap.get(k);
                    if (idx != null) {
                        GridDhtCacheEntry entry = (GridDhtCacheEntry)entries.get(idx);
                        try {
                            GridCacheVersion ver = entry.version();
                            entry.versionedValue(GridDhtAtomicCache.this.ctx.toCacheObject(v), null, ver, null, null);
                        }
                        catch (GridCacheEntryRemovedException e) {
                            assert (false) : "Entry should not get obsolete while holding lock [entry=" + entry + ", e=" + e + ']';
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    }
                }
            });
        }
    }

    private void updateSingle(ClusterNode nearNode, boolean hasNear, GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res, List<GridDhtCacheEntry> locked, GridCacheVersion ver, boolean replicate, String taskName, @Nullable IgniteCacheExpiryPolicy expiry, boolean sndPrevVal, DhtAtomicUpdateResult dhtUpdRes) throws GridCacheEntryRemovedException {
        GridCacheReturn retVal = dhtUpdRes.returnValue();
        GridDhtAtomicAbstractUpdateFuture dhtFut = dhtUpdRes.dhtFuture();
        Collection<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>> deleted = dhtUpdRes.deleted();
        AffinityTopologyVersion topVer = req.topologyVersion();
        boolean intercept = this.ctx.config().getInterceptor() != null;
        AffinityAssignment affAssignment = this.ctx.affinity().assignment(topVer);
        for (int i = dhtUpdRes.processedEntriesCount(); i < req.size(); ++i) {
            KeyCacheObject k = req.key(i);
            GridCacheOperation op = req.operation();
            try {
                GridDhtCacheEntry entry = locked.get(i);
                GridCacheVersion newConflictVer = req.conflictVersion(i);
                long newConflictTtl = req.conflictTtl(i);
                long newConflictExpireTime = req.conflictExpireTime(i);
                assert (!(newConflictVer instanceof GridCacheVersionEx)) : newConflictVer;
                Object writeVal = op == GridCacheOperation.TRANSFORM ? req.entryProcessor(i) : req.writeValue(i);
                GridDhtCacheEntry.ReaderId[] readers = entry.readersLocked();
                GridCacheUpdateAtomicResult updRes = entry.innerUpdate(ver, nearNode.id(), this.locNodeId, op, writeVal, req.invokeArguments(), this.writeThrough() && !req.skipStore(), !req.skipStore(), sndPrevVal || req.returnValue(), req.keepBinary(), expiry, true, true, true, false, topVer, req.filter(), replicate ? GridDrType.DR_PRIMARY : GridDrType.DR_NONE, newConflictTtl, newConflictExpireTime, newConflictVer, true, intercept, req.subjectId(), taskName, null, null, dhtFut, false);
                if (dhtFut != null) {
                    if (updRes.sendToDht()) {
                        GridCacheVersionConflictContext<?, ?> conflictCtx = updRes.conflictResolveResult();
                        if (conflictCtx == null) {
                            newConflictVer = null;
                        } else if (conflictCtx.isMerge()) {
                            newConflictVer = null;
                        }
                        EntryProcessor<Object, Object, Object> entryProcessor = null;
                        dhtFut.addWriteEntry(affAssignment, entry, updRes.newValue(), entryProcessor, updRes.newTtl(), updRes.conflictExpireTime(), newConflictVer, sndPrevVal, updRes.oldValue(), updRes.updateCounter(), op);
                        if (readers != null) {
                            dhtFut.addNearWriteEntries(nearNode, readers, entry, updRes.newValue(), entryProcessor, updRes.newTtl(), updRes.conflictExpireTime());
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Entry did not pass the filter or conflict resolution (will skip write) [entry=" + entry + ", filter=" + Arrays.toString(req.filter()) + ']');
                    }
                }
                if (hasNear) {
                    if (updRes.sendToDht()) {
                        if (!this.ctx.affinity().partitionBelongs(nearNode, entry.partition(), topVer)) {
                            if (op == GridCacheOperation.TRANSFORM || writeVal != updRes.newValue()) {
                                res.addNearValue(i, updRes.newValue(), updRes.newTtl(), updRes.conflictExpireTime());
                            } else {
                                res.addNearTtl(i, updRes.newTtl(), updRes.conflictExpireTime());
                            }
                            if (updRes.newValue() != null) {
                                IgniteInternalFuture<Boolean> f = entry.addReader(nearNode.id(), req.messageId(), topVer);
                                assert (f == null) : f;
                            }
                        } else if (GridDhtCacheEntry.ReaderId.contains(readers, nearNode.id())) {
                            entry.removeReader(nearNode.id(), req.messageId());
                        } else {
                            res.addSkippedIndex(i);
                        }
                    } else {
                        res.addSkippedIndex(i);
                    }
                }
                if (updRes.removeVersion() != null) {
                    if (deleted == null) {
                        deleted = new ArrayList<IgniteBiTuple<GridDhtCacheEntry, GridCacheVersion>>(req.size());
                    }
                    deleted.add(F.t(entry, updRes.removeVersion()));
                }
                if (op == GridCacheOperation.TRANSFORM) {
                    assert (!req.returnValue());
                    IgniteBiTuple<Object, Exception> compRes = updRes.computedResult();
                    if (compRes != null && (compRes.get1() != null || compRes.get2() != null)) {
                        if (retVal == null) {
                            retVal = new GridCacheReturn(nearNode.isLocal());
                        }
                        retVal.addEntryProcessResult(this.ctx, k, null, compRes.get1(), compRes.get2(), req.keepBinary());
                    }
                } else if (retVal == null) {
                    CacheObject ret = updRes.oldValue();
                    retVal = new GridCacheReturn(this.ctx, nearNode.isLocal(), req.keepBinary(), req.returnValue() ? ret : null, updRes.success());
                }
            }
            catch (IgniteCheckedException e) {
                res.addFailedKey(k, e);
            }
            dhtUpdRes.processedEntriesCount(i + 1);
        }
        dhtUpdRes.returnValue(retVal);
        dhtUpdRes.deleted(deleted);
        dhtUpdRes.dhtFuture(dhtFut);
    }

    @Nullable
    private void updatePartialBatch(boolean hasNear, int firstEntryIdx, List<GridDhtCacheEntry> entries, final GridCacheVersion ver, ClusterNode nearNode, @Nullable List<CacheObject> writeVals, @Nullable Map<KeyCacheObject, CacheObject> putMap, @Nullable Collection<KeyCacheObject> rmvKeys, @Nullable Map<KeyCacheObject, EntryProcessor<Object, Object, Object>> entryProcessorMap, GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res, boolean replicate, DhtAtomicUpdateResult dhtUpdRes, String taskName, @Nullable IgniteCacheExpiryPolicy expiry, boolean sndPrevVal) {
        assert (putMap == null ^ rmvKeys == null);
        assert (req.conflictVersions() == null) : "Cannot be called when there are conflict entries in the batch.";
        AffinityTopologyVersion topVer = req.topologyVersion();
        CacheStorePartialUpdateException storeErr = null;
        try {
            GridCacheOperation op;
            if (putMap != null) {
                try {
                    Map<KeyCacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>> view = F.viewReadOnly(putMap, new C1<CacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>>(){

                        @Override
                        public IgniteBiTuple<? extends CacheObject, GridCacheVersion> apply(CacheObject val) {
                            return F.t(val, ver);
                        }
                    }, new IgnitePredicate[0]);
                    this.ctx.store().putAll(null, view);
                }
                catch (CacheStorePartialUpdateException e) {
                    storeErr = e;
                }
                op = GridCacheOperation.UPDATE;
            } else {
                try {
                    this.ctx.store().removeAll(null, rmvKeys);
                }
                catch (CacheStorePartialUpdateException e) {
                    storeErr = e;
                }
                op = GridCacheOperation.DELETE;
            }
            boolean intercept = this.ctx.config().getInterceptor() != null;
            AffinityAssignment affAssignment = this.ctx.affinity().assignment(topVer);
            GridDhtAtomicAbstractUpdateFuture dhtFut = dhtUpdRes.dhtFuture();
            for (int i = 0; i < entries.size(); ++i) {
                GridDhtCacheEntry entry = entries.get(i);
                assert (entry.lockedByCurrentThread());
                if (entry.obsolete()) {
                    assert (req.operation() == GridCacheOperation.DELETE) : "Entry can become obsolete only after remove: " + entry;
                    continue;
                }
                if (storeErr != null && storeErr.failedKeys().contains(entry.key().value(this.ctx.cacheObjectContext(), false))) continue;
                try {
                    CacheObject writeVal;
                    CacheObject cacheObject = writeVal = op == GridCacheOperation.UPDATE ? writeVals.get(i) : null;
                    assert (writeVal != null || op == GridCacheOperation.DELETE) : "null write value found.";
                    GridDhtCacheEntry.ReaderId[] readers = entry.readersLocked();
                    EntryProcessor<Object, Object, Object> entryProcessor = entryProcessorMap == null ? null : entryProcessorMap.get(entry.key());
                    GridCacheUpdateAtomicResult updRes = entry.innerUpdate(ver, nearNode.id(), this.locNodeId, op, writeVal, null, false, false, sndPrevVal, req.keepBinary(), expiry, true, true, true, false, topVer, null, replicate ? GridDrType.DR_PRIMARY : GridDrType.DR_NONE, -1L, -1L, null, false, false, req.subjectId(), taskName, null, null, dhtFut, entryProcessor != null);
                    assert (!updRes.success() || updRes.newTtl() == -1L || expiry != null) : "success=" + updRes.success() + ", newTtl=" + updRes.newTtl() + ", expiry=" + expiry;
                    if (intercept) {
                        if (op == GridCacheOperation.UPDATE) {
                            this.ctx.config().getInterceptor().onAfterPut(new CacheLazyEntry(this.ctx, entry.key(), updRes.newValue(), req.keepBinary()));
                        } else {
                            assert (op == GridCacheOperation.DELETE) : op;
                            this.ctx.config().getInterceptor().onAfterRemove(new CacheLazyEntry(this.ctx, entry.key(), updRes.oldValue(), req.keepBinary()));
                        }
                    }
                    dhtUpdRes.addDeleted(entry, updRes, entries);
                    if (dhtFut != null) {
                        dhtFut.addWriteEntry(affAssignment, entry, writeVal, entryProcessor, updRes.newTtl(), -1L, null, sndPrevVal, updRes.oldValue(), updRes.updateCounter(), op);
                        if (readers != null) {
                            dhtFut.addNearWriteEntries(nearNode, readers, entry, writeVal, entryProcessor, updRes.newTtl(), -1L);
                        }
                    }
                    if (hasNear) {
                        if (!this.ctx.affinity().partitionBelongs(nearNode, entry.partition(), topVer)) {
                            int idx = firstEntryIdx + i;
                            if (req.operation() == GridCacheOperation.TRANSFORM) {
                                res.addNearValue(idx, writeVal, updRes.newTtl(), -1L);
                            } else {
                                res.addNearTtl(idx, updRes.newTtl(), -1L);
                            }
                            if (writeVal != null || entry.hasValue()) {
                                IgniteInternalFuture<Boolean> f = entry.addReader(nearNode.id(), req.messageId(), topVer);
                                assert (f == null) : f;
                            }
                        } else if (GridDhtCacheEntry.ReaderId.contains(readers, nearNode.id())) {
                            entry.removeReader(nearNode.id(), req.messageId());
                        } else {
                            res.addSkippedIndex(firstEntryIdx + i);
                        }
                    }
                }
                catch (GridCacheEntryRemovedException e) {
                    assert (false) : "Entry cannot become obsolete while holding lock.";
                    e.printStackTrace();
                }
                dhtUpdRes.processedEntriesCount(firstEntryIdx + i + 1);
            }
        }
        catch (IgniteCheckedException e) {
            res.addFailedKeys(putMap != null ? putMap.keySet() : rmvKeys, e);
        }
        if (storeErr != null) {
            ArrayList<KeyCacheObject> failed = new ArrayList<KeyCacheObject>(storeErr.failedKeys().size());
            for (Object failedKey : storeErr.failedKeys()) {
                failed.add(this.ctx.toCacheKeyObject(failedKey));
            }
            res.addFailedKeys(failed, storeErr.getCause());
        }
    }

    private List<GridDhtCacheEntry> lockEntries(GridNearAtomicAbstractUpdateRequest req, AffinityTopologyVersion topVer) throws GridDhtInvalidPartitionException {
        boolean retry;
        if (req.size() == 1) {
            GridDhtCacheEntry entry;
            KeyCacheObject key = req.key(0);
            while (true) {
                entry = this.entryExx(key, topVer);
                entry.lockEntry();
                if (!entry.obsolete()) break;
                entry.unlockEntry();
            }
            return Collections.singletonList(entry);
        }
        ArrayList<GridDhtCacheEntry> locked = new ArrayList<GridDhtCacheEntry>(req.size());
        block1: do {
            for (int i = 0; i < req.size(); ++i) {
                GridDhtCacheEntry entry = this.entryExx(req.key(i), topVer);
                locked.add(entry);
            }
            retry = false;
            for (int i = 0; i < locked.size(); ++i) {
                GridCacheMapEntry entry = (GridCacheMapEntry)locked.get(i);
                if (entry == null) continue;
                entry.lockEntry();
                if (!entry.obsolete()) continue;
                for (int j = 0; j <= i; ++j) {
                    if (locked.get(j) == null) continue;
                    ((GridDhtCacheEntry)locked.get(j)).unlockEntry();
                }
                locked.clear();
                retry = true;
                continue block1;
            }
        } while (retry);
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockEntries(List<GridDhtCacheEntry> locked, AffinityTopologyVersion topVer) {
        GridCacheMapEntry entry;
        int i;
        assert (this.ctx.deferredDelete()) : this;
        HashSet skip = null;
        int size = locked.size();
        try {
            for (i = 0; i < size; ++i) {
                entry = locked.get(i);
                if (entry == null || !entry.deleted()) continue;
                if (skip == null) {
                    skip = U.newHashSet(locked.size());
                }
                skip.add(entry.key());
            }
        }
        finally {
            for (i = 0; i < size; ++i) {
                entry = locked.get(i);
                if (entry == null) continue;
                entry.unlockEntry();
            }
        }
        for (i = 0; i < size; ++i) {
            entry = locked.get(i);
            if (entry == null) continue;
            ((GridDhtCacheEntry)entry).onUnlock();
        }
        if (skip != null && skip.size() == size) {
            return;
        }
        for (i = 0; i < size; ++i) {
            entry = locked.get(i);
            if (entry == null || skip != null && skip.contains(entry.key())) continue;
            entry.touch(topVer);
        }
    }

    private boolean checkFilter(GridCacheEntryEx entry, GridNearAtomicAbstractUpdateRequest req, GridNearAtomicUpdateResponse res) {
        try {
            return this.ctx.isAllLocked(entry, req.filter());
        }
        catch (IgniteCheckedException e) {
            res.addFailedKey(entry.key(), e);
            return false;
        }
    }

    void remapToNewPrimary(GridNearAtomicAbstractUpdateRequest req) {
        List<GridCacheVersion> drRmvVals;
        ArrayList<GridCacheDrInfo> drPutVals;
        List<?> vals;
        assert (req.writeSynchronizationMode() == CacheWriteSynchronizationMode.FULL_ASYNC) : req;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remapping near update request locally: " + req);
        }
        if (req.conflictVersions() == null) {
            vals = req.values();
            drPutVals = null;
            drRmvVals = null;
        } else if (req.operation() == GridCacheOperation.UPDATE) {
            int size = req.keys().size();
            drPutVals = new ArrayList<GridCacheDrInfo>(size);
            for (int i = 0; i < size; ++i) {
                long ttl = req.conflictTtl(i);
                if (ttl == -1L) {
                    drPutVals.add(new GridCacheDrInfo(req.value(i), req.conflictVersion(i)));
                    continue;
                }
                drPutVals.add(new GridCacheDrExpirationInfo(req.value(i), req.conflictVersion(i), ttl, req.conflictExpireTime(i)));
            }
            vals = null;
            drRmvVals = null;
        } else {
            assert (req.operation() == GridCacheOperation.DELETE) : req;
            drRmvVals = req.conflictVersions();
            vals = null;
            drPutVals = null;
        }
        GridNearAtomicUpdateFuture updateFut = new GridNearAtomicUpdateFuture(this.ctx, this, this.ctx.config().getWriteSynchronizationMode(), req.operation(), req.keys(), vals, req.invokeArguments(), drPutVals, drRmvVals, req.returnValue(), false, req.expiry(), req.filter(), req.subjectId(), req.taskNameHash(), req.skipStore(), req.keepBinary(), req.recovery(), MAX_RETRIES);
        updateFut.map();
    }

    private GridDhtAtomicAbstractUpdateFuture createDhtFuture(GridCacheVersion writeVer, GridNearAtomicAbstractUpdateRequest updateReq) {
        if (updateReq.size() == 1) {
            return new GridDhtAtomicSingleUpdateFuture(this.ctx, writeVer, updateReq);
        }
        return new GridDhtAtomicUpdateFuture(this.ctx, writeVer, updateReq);
    }

    private void processNearAtomicUpdateRequest(UUID nodeId, GridNearAtomicAbstractUpdateRequest req) {
        ClusterNode node;
        if (this.msgLog.isDebugEnabled()) {
            this.msgLog.debug("Received near atomic update request [futId=" + req.futureId() + ", node=" + nodeId + ']');
        }
        if ((node = this.ctx.discovery().node(nodeId)) == null) {
            U.warn(this.msgLog, "Skip near update request, node originated update request left [futId=" + req.futureId() + ", node=" + nodeId + ']');
            return;
        }
        this.updateAllAsyncInternal(node, req, this.updateReplyClos);
    }

    private void processNearAtomicUpdateResponse(UUID nodeId, GridNearAtomicUpdateResponse res) {
        if (this.msgLog.isDebugEnabled()) {
            this.msgLog.debug("Received near atomic update response [futId" + res.futureId() + ", node=" + nodeId + ']');
        }
        res.nodeId(this.ctx.localNodeId());
        GridNearAtomicAbstractUpdateFuture fut = (GridNearAtomicAbstractUpdateFuture)this.ctx.mvcc().atomicFuture(res.futureId());
        if (fut != null) {
            fut.onPrimaryResponse(nodeId, res, false);
        } else {
            U.warn(this.msgLog, "Failed to find near update future for update response (will ignore) [futId=" + res.futureId() + ", node=" + nodeId + ", res=" + res + ']');
        }
    }

    private void processCheckUpdateRequest(UUID nodeId, GridNearAtomicCheckUpdateRequest checkReq) {
        GridNearAtomicUpdateResponse res = new GridNearAtomicUpdateResponse(this.ctx.cacheId(), nodeId, checkReq.futureId(), checkReq.partition(), false, false);
        GridCacheReturn ret = new GridCacheReturn(false, true);
        res.returnValue(ret);
        this.sendNearUpdateReply(nodeId, res);
    }

    /*
     * Exception decompiling
     */
    private void processDhtAtomicUpdateRequest(UUID nodeId, GridDhtAtomicAbstractUpdateRequest req) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendDhtPrimaryResponse(UUID nodeId, GridDhtAtomicAbstractUpdateRequest req, GridDhtAtomicUpdateResponse dhtRes) {
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)dhtRes, this.ctx.ioPolicy());
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Sent DHT response [futId=" + req.futureId() + ", nearFutId=" + req.nearFutureId() + ", writeVer=" + req.writeVersion() + ", node=" + nodeId + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            U.warn(this.msgLog, "Failed to send DHT response, node left [futId=" + req.futureId() + ", nearFutId=" + req.nearFutureId() + ", node=" + nodeId + ']');
        }
        catch (IgniteCheckedException e) {
            U.error(this.msgLog, "Failed to send DHT near response [futId=" + req.futureId() + ", nearFutId=" + req.nearFutureId() + ", node=" + nodeId + ", res=" + dhtRes + ']', e);
        }
    }

    private void sendDeferredUpdateResponse(int part, UUID primaryId, long futId) {
        Map<UUID, GridDhtAtomicDeferredUpdateResponse> resMap = this.defRes.get();
        GridDhtAtomicDeferredUpdateResponse msg = resMap.get(primaryId);
        if (msg == null) {
            msg = new GridDhtAtomicDeferredUpdateResponse(this.ctx.cacheId(), new GridLongList(DEFERRED_UPDATE_RESPONSE_BUFFER_SIZE));
            if (DEFERRED_UPDATE_RESPONSE_TIMEOUT > 0) {
                DeferredUpdateTimeout timeoutSnd = new DeferredUpdateTimeout(part, primaryId);
                msg.timeoutSender(timeoutSnd);
                this.ctx.time().addTimeoutObject(timeoutSnd);
            }
            resMap.put(primaryId, msg);
        }
        GridLongList futIds = msg.futureIds();
        assert (futIds.size() < DEFERRED_UPDATE_RESPONSE_BUFFER_SIZE) : futIds.size();
        futIds.add(futId);
        if (futIds.size() >= DEFERRED_UPDATE_RESPONSE_BUFFER_SIZE) {
            resMap.remove(primaryId);
            this.sendDeferredUpdateResponse(primaryId, msg);
        }
    }

    private void sendDeferredUpdateResponse(UUID primaryId, GridDhtAtomicDeferredUpdateResponse msg) {
        try {
            GridTimeoutObject timeoutSnd = msg.timeoutSender();
            if (timeoutSnd != null) {
                this.ctx.time().removeTimeoutObject(timeoutSnd);
            }
            this.ctx.io().send(primaryId, (GridCacheMessage)msg, this.ctx.ioPolicy());
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Sent deferred DHT update response [futIds=" + msg.futureIds() + ", node=" + primaryId + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Failed to send deferred DHT update response, node left [futIds=" + msg.futureIds() + ", node=" + primaryId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send deferredDHT  update response to remote node [futIds=" + msg.futureIds() + ", node=" + primaryId + ']', e);
        }
    }

    private void sendDhtNearResponse(GridDhtAtomicAbstractUpdateRequest req, GridDhtAtomicNearResponse nearRes) {
        try {
            ClusterNode node = this.ctx.discovery().node(req.nearNodeId());
            if (node == null) {
                throw new ClusterTopologyCheckedException("Node failed: " + req.nearNodeId());
            }
            if (node.isLocal()) {
                this.processDhtAtomicNearResponse(node.id(), nearRes);
            } else {
                this.ctx.io().send(node, (GridCacheMessage)nearRes, this.ctx.ioPolicy());
            }
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Sent DHT near response [futId=" + req.futureId() + ", nearFutId=" + req.nearFutureId() + ", writeVer=" + req.writeVersion() + ", node=" + req.nearNodeId() + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Failed to send DHT near response, node left [futId=" + req.futureId() + ", nearFutId=" + req.nearFutureId() + ", node=" + req.nearNodeId() + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.msgLog, "Failed to send DHT near response [futId=" + req.futureId() + ", nearFutId=" + req.nearFutureId() + ", node=" + req.nearNodeId() + ", res=" + nearRes + ']', e);
        }
    }

    private void processDhtAtomicNearResponse(UUID nodeId, GridDhtAtomicNearResponse res) {
        GridNearAtomicAbstractUpdateFuture updateFut = (GridNearAtomicAbstractUpdateFuture)this.ctx.mvcc().atomicFuture(res.futureId());
        if (updateFut != null) {
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Received DHT atomic near response [futId=" + res.futureId() + ", node=" + nodeId + ']');
            }
            updateFut.onDhtResponse(nodeId, res);
        } else if (this.msgLog.isDebugEnabled()) {
            this.msgLog.debug("Failed to find future for DHT atomic near response [futId=" + res.futureId() + ", node=" + nodeId + ", res=" + res + ']');
        }
    }

    private void processDhtAtomicUpdateResponse(UUID nodeId, GridDhtAtomicUpdateResponse res) {
        GridDhtAtomicAbstractUpdateFuture updateFut = (GridDhtAtomicAbstractUpdateFuture)this.ctx.mvcc().atomicFuture(res.futureId());
        if (updateFut != null) {
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Received DHT atomic update response [futId=" + res.futureId() + ", writeVer=" + updateFut.writeVersion() + ", node=" + nodeId + ']');
            }
            updateFut.onDhtResponse(nodeId, res);
        } else {
            U.warn(this.msgLog, "Failed to find DHT update future for update response [futId=" + res.futureId() + ", node=" + nodeId + ", res=" + res + ']');
        }
    }

    private void processDhtAtomicDeferredUpdateResponse(UUID nodeId, GridDhtAtomicDeferredUpdateResponse res) {
        GridLongList futIds = res.futureIds();
        assert (futIds != null && !futIds.isEmpty()) : futIds;
        for (int i = 0; i < futIds.size(); ++i) {
            long id = futIds.get(i);
            GridDhtAtomicAbstractUpdateFuture updateFut = (GridDhtAtomicAbstractUpdateFuture)this.ctx.mvcc().atomicFuture(id);
            if (updateFut != null) {
                if (this.msgLog.isDebugEnabled()) {
                    this.msgLog.debug("Received DHT atomic deferred update response [futId=" + id + ", writeVer=" + res + ", node=" + nodeId + ']');
                }
                updateFut.onDeferredResponse(nodeId);
                continue;
            }
            U.warn(this.msgLog, "Failed to find DHT update future for deferred update response [futId=" + id + ", nodeId=" + nodeId + ", res=" + res + ']');
        }
    }

    private void sendNearUpdateReply(UUID nodeId, GridNearAtomicUpdateResponse res) {
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)res, this.ctx.ioPolicy());
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Sent near update response [futId=" + res.futureId() + ", node=" + nodeId + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.msgLog.isDebugEnabled()) {
                this.msgLog.debug("Failed to send near update response [futId=" + res.futureId() + ", node=" + nodeId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.msgLog, "Failed to send near update response [futId=" + res.futureId() + ", node=" + nodeId + ", res=" + res + ']', e);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicCache.class, this, super.toString());
    }

    private class DeferredUpdateTimeout
    implements GridTimeoutObject,
    Runnable {
        private final int part;
        private final UUID primaryId;
        private final IgniteUuid id;
        private final long endTime;

        DeferredUpdateTimeout(int part, UUID primaryId) {
            this.part = part;
            this.primaryId = primaryId;
            this.endTime = U.currentTimeMillis() + (long)DEFERRED_UPDATE_RESPONSE_TIMEOUT;
            this.id = IgniteUuid.fromUuid(primaryId);
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.id;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        @Override
        public void run() {
            Map resMap = (Map)GridDhtAtomicCache.this.defRes.get();
            GridDhtAtomicDeferredUpdateResponse msg = (GridDhtAtomicDeferredUpdateResponse)resMap.get(this.primaryId);
            if (msg != null && msg.timeoutSender() == this) {
                msg.timeoutSender(null);
                resMap.remove(this.primaryId);
                GridDhtAtomicCache.this.sendDeferredUpdateResponse(this.primaryId, msg);
            }
        }

        @Override
        public void onTimeout() {
            GridDhtAtomicCache.this.ctx.kernalContext().getStripedExecutorService().execute(this.part, this);
        }
    }

    static interface UpdateReplyClosure
    extends CI2<GridNearAtomicAbstractUpdateRequest, GridNearAtomicUpdateResponse> {
    }

    private static class FinishedLockFuture
    extends GridFinishedFuture<Boolean>
    implements GridDhtFuture<Boolean> {
        private FinishedLockFuture(Throwable err) {
            super(err);
        }

        @Override
        public Collection<Integer> invalidPartitions() {
            return Collections.emptyList();
        }
    }
}

