/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearTxSelectForUpdateFuture
extends GridCacheCompoundIdentityFuture<Long>
implements GridCacheVersionedFuture<Long> {
    private static final long serialVersionUID = 6931664882548658420L;
    private static final AtomicIntegerFieldUpdater<GridNearTxSelectForUpdateFuture> DONE_UPD = AtomicIntegerFieldUpdater.newUpdater(GridNearTxSelectForUpdateFuture.class, "done");
    private static final AtomicReferenceFieldUpdater<GridNearTxSelectForUpdateFuture, Throwable> EX_UPD = AtomicReferenceFieldUpdater.newUpdater(GridNearTxSelectForUpdateFuture.class, Throwable.class, "ex");
    @GridToStringExclude
    private volatile int done;
    @GridToStringExclude
    private volatile Throwable ex;
    @GridToStringExclude
    private final GridCacheContext<?, ?> cctx;
    private final GridNearTxLocal tx;
    private final IgniteUuid futId;
    private final GridCacheVersion lockVer;
    private AffinityTopologyVersion topVer;
    private final long timeout;
    @GridToStringExclude
    private final IgniteLogger log;
    @GridToStringExclude
    private LockTimeoutObject timeoutObj;
    private final Map<UUID, Integer> miniFutIds = new HashMap<UUID, Integer>();

    public GridNearTxSelectForUpdateFuture(GridCacheContext<?, ?> cctx, GridNearTxLocal tx, long timeout) {
        super(CU.longReducer());
        this.cctx = cctx;
        this.tx = tx;
        this.timeout = timeout;
        this.futId = IgniteUuid.randomUuid();
        this.lockVer = tx.xidVersion();
        this.log = cctx.logger(GridNearTxSelectForUpdateFuture.class);
    }

    public GridCacheContext<?, ?> cache() {
        return this.cctx;
    }

    private void map(ClusterNode node) {
        GridDistributedTxMapping mapping = this.tx.mappings().get(node.id());
        if (mapping == null) {
            mapping = new GridDistributedTxMapping(node);
            this.tx.mappings().put(mapping);
        }
        mapping.markQueryUpdate();
        if (node.isLocal()) {
            this.tx.colocatedLocallyMapped(true);
        }
        int futId = this.futuresCountNoLock();
        this.miniFutIds.put(node.id(), futId);
        this.add(new NodeFuture(node));
    }

    public void onResult(UUID nodeId, Long cnt, boolean removeMapping, @Nullable Throwable err) {
        NodeFuture nodeFut = this.mapFuture(nodeId);
        if (nodeFut != null) {
            nodeFut.onResult(cnt, removeMapping, err);
        }
    }

    @Override
    protected boolean processFailure(Throwable err, IgniteInternalFuture<Long> fut) {
        if (this.ex != null || !EX_UPD.compareAndSet(this, null, err)) {
            this.ex.addSuppressed(err);
        }
        return true;
    }

    @Override
    public boolean onDone(@Nullable Long res, @Nullable Throwable err, boolean cancelled) {
        if (!DONE_UPD.compareAndSet(this, 0, 1)) {
            return false;
        }
        this.cctx.tm().txContext(this.tx);
        Throwable ex0 = this.ex;
        if (ex0 != null) {
            if (err != null) {
                ex0.addSuppressed(err);
            }
            err = ex0;
        }
        if (!cancelled && err == null) {
            this.tx.clearLockFuture(this);
        } else {
            this.tx.setRollbackOnly();
        }
        boolean done = super.onDone(res, err, cancelled);
        assert (done);
        this.cctx.mvcc().removeVersionedFuture(this);
        if (this.timeoutObj != null) {
            this.cctx.time().removeTimeoutObject(this.timeoutObj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeFuture mapFuture(UUID nodeId) {
        GridNearTxSelectForUpdateFuture gridNearTxSelectForUpdateFuture = this;
        synchronized (gridNearTxSelectForUpdateFuture) {
            Integer idx = this.miniFutIds.get(nodeId);
            if (idx == null) {
                throw new IllegalStateException("SELECT FOR UPDATE node future not found [nodeId=" + nodeId + "].");
            }
            assert (idx >= 0 && idx < this.futuresCountNoLock());
            IgniteInternalFuture fut = this.future(idx);
            if (!fut.isDone()) {
                return (NodeFuture)fut;
            }
        }
        return null;
    }

    @Override
    public GridCacheVersion version() {
        return this.lockVer;
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        return false;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        if (this.topVer == null) {
            return false;
        }
        for (IgniteInternalFuture fut : this.futures()) {
            NodeFuture f = (NodeFuture)fut;
            if (!f.node.id().equals(nodeId)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found mini-future for left node [nodeId=" + nodeId + ", mini=" + f + ", fut=" + this + ']');
            }
            ClusterTopologyCheckedException topEx = new ClusterTopologyCheckedException("Failed to enlist keys (primary node left grid, retry transaction if possible) [node=" + nodeId + ']');
            topEx.retryReadyFuture(this.cctx.shared().nextAffinityReadyFuture(this.topVer));
            return f.onResult(0L, false, topEx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Future does not have mapping for left node (ignoring) [nodeId=" + nodeId + ", fut=" + this + ']');
        }
        return false;
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
    }

    @Override
    protected void logError(IgniteLogger log, String msg, Throwable e) {
    }

    @Override
    protected void logDebug(IgniteLogger log, String msg) {
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxSelectForUpdateFuture.class, this, super.toString());
    }

    public synchronized void init(AffinityTopologyVersion topVer, Collection<ClusterNode> nodes) {
        this.doInit(topVer, nodes, false);
    }

    public synchronized void initLocal() {
        this.doInit(null, Collections.singletonList(this.cctx.localNode()), true);
    }

    private void doInit(@Nullable AffinityTopologyVersion topVer, Collection<ClusterNode> nodes, boolean loc) {
        assert (!loc || topVer == null && nodes.size() == 1 && nodes.iterator().next().isLocal());
        if (this.initialized()) {
            throw new IllegalStateException("SELECT FOR UPDATE future has been initialized already.");
        }
        this.tx.init();
        if (this.timeout < 0L) {
            this.onDone(this.timeoutException());
            return;
        }
        if (this.timeout > 0L) {
            this.timeoutObj = new LockTimeoutObject();
        }
        if (!this.tx.updateLockFuture(null, this)) {
            this.onDone(this.tx.timedOut() ? this.tx.timeoutException() : this.tx.rollbackException());
            return;
        }
        boolean added = this.cctx.mvcc().addFuture(this);
        assert (added) : this;
        try {
            this.tx.addActiveCache(this.cctx, false);
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
            return;
        }
        if (this.timeoutObj != null) {
            this.cctx.time().addTimeoutObject(this.timeoutObj);
        }
        this.topVer = topVer;
        for (ClusterNode n : nodes) {
            this.map(n);
        }
        this.markInitialized();
    }

    @NotNull
    private IgniteTxTimeoutCheckedException timeoutException() {
        return new IgniteTxTimeoutCheckedException("Failed to acquire lock within provided timeout for transaction [timeout=" + this.timeout + ", tx=" + this.tx + ']');
    }

    private class LockTimeoutObject
    extends GridTimeoutObjectAdapter {
        LockTimeoutObject() {
            super(GridNearTxSelectForUpdateFuture.this.timeout);
        }

        @Override
        public void onTimeout() {
            if (GridNearTxSelectForUpdateFuture.this.log.isDebugEnabled()) {
                GridNearTxSelectForUpdateFuture.this.log.debug("Timed out waiting for lock response: " + this);
            }
            GridNearTxSelectForUpdateFuture.this.onDone(GridNearTxSelectForUpdateFuture.this.timeoutException());
        }

        public String toString() {
            return S.toString(LockTimeoutObject.class, this);
        }
    }

    private class NodeFuture
    extends GridFutureAdapter<Long> {
        private boolean completed;
        @GridToStringExclude
        private final ClusterNode node;

        private NodeFuture(ClusterNode node) {
            this.node = node;
        }

        public ClusterNode node() {
            return this.node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onResult(long cnt, boolean removeMapping, Throwable err) {
            NodeFuture nodeFuture = this;
            synchronized (nodeFuture) {
                if (this.completed) {
                    return false;
                }
                this.completed = true;
            }
            if (X.hasCause(err, ClusterTopologyCheckedException.class) || removeMapping) {
                GridDistributedTxMapping m = GridNearTxSelectForUpdateFuture.this.tx.mappings().get(this.node.id());
                assert (m != null && m.empty());
                GridNearTxSelectForUpdateFuture.this.tx.removeMapping(this.node.id());
                if (this.node.isLocal()) {
                    GridNearTxSelectForUpdateFuture.this.tx.colocatedLocallyMapped(false);
                }
            } else if (err == null && cnt > 0L && !this.node.isLocal()) {
                GridNearTxSelectForUpdateFuture.this.tx.hasRemoteLocks(true);
            }
            return this.onDone(cnt, err);
        }
    }
}

