/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class AbstractFileIO
implements FileIO {
    private static final int MAX_IO_TIMEOUT_MS = 2000;

    private int fully(IOOperation operation, long position, int num, boolean write) throws IOException {
        if (num > 0) {
            long time = 0L;
            int i = 0;
            while (i < num) {
                int n = operation.run(i);
                if (n > 0) {
                    i += n;
                    time = 0L;
                    continue;
                }
                if (n == 0) {
                    if (!write && this.available(num - i, position + (long)i) == 0) {
                        return i;
                    }
                    if (time == 0L) {
                        time = U.currentTimeMillis();
                        continue;
                    }
                    if (U.currentTimeMillis() - time < 2000L) continue;
                    throw new IOException(write && position + (long)i == this.size() ? "Failed to extend file." : "Probably disk is too busy, please check your device.");
                }
                return -1;
            }
        }
        return num;
    }

    @Override
    public int readFully(final ByteBuffer destBuf) throws IOException {
        return this.fully(new IOOperation(){

            @Override
            public int run(int offs) throws IOException {
                return AbstractFileIO.this.read(destBuf);
            }
        }, this.position(), destBuf.remaining(), false);
    }

    @Override
    public int readFully(final ByteBuffer destBuf, final long position) throws IOException {
        return this.fully(new IOOperation(){

            @Override
            public int run(int offs) throws IOException {
                return AbstractFileIO.this.read(destBuf, position + (long)offs);
            }
        }, position, destBuf.remaining(), false);
    }

    @Override
    public int readFully(final byte[] buf, final int off, final int len) throws IOException {
        return this.fully(new IOOperation(){

            @Override
            public int run(int offs) throws IOException {
                return AbstractFileIO.this.read(buf, off + offs, len - offs);
            }
        }, this.position(), len, false);
    }

    @Override
    public int writeFully(final ByteBuffer srcBuf) throws IOException {
        return this.fully(new IOOperation(){

            @Override
            public int run(int offs) throws IOException {
                return AbstractFileIO.this.write(srcBuf);
            }
        }, this.position(), srcBuf.remaining(), true);
    }

    @Override
    public int writeFully(final ByteBuffer srcBuf, final long position) throws IOException {
        return this.fully(new IOOperation(){

            @Override
            public int run(int offs) throws IOException {
                return AbstractFileIO.this.write(srcBuf, position + (long)offs);
            }
        }, position, srcBuf.remaining(), true);
    }

    @Override
    public int writeFully(final byte[] buf, final int off, final int len) throws IOException {
        return this.fully(new IOOperation(){

            @Override
            public int run(int offs) throws IOException {
                return AbstractFileIO.this.write(buf, off + offs, len - offs);
            }
        }, this.position(), len, true);
    }

    private int available(int requested, long position) throws IOException {
        long avail = this.size() - position;
        return (long)requested > avail ? (int)avail : requested;
    }

    private static interface IOOperation {
        public int run(int var1) throws IOException;
    }
}

