/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheIteratorConverter;
import org.apache.ignite.internal.processors.cache.CacheWeakQueryIteratorsHolder;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.datastructures.CollocatedSetItemKey;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetHeader;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetHeaderKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetItemKey;
import org.apache.ignite.internal.processors.datastructures.GridSetQueryPredicate;
import org.apache.ignite.internal.processors.datastructures.SetItemKey;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridCacheSetImpl<T>
extends AbstractCollection<T>
implements IgniteSet<T> {
    private static final int BATCH_SIZE = 100;
    private final GridCacheContext ctx;
    private final IgniteInternalCache<SetItemKey, Boolean> cache;
    private final IgniteLogger log;
    private final String name;
    private final IgniteUuid id;
    private final boolean collocated;
    private final boolean separated;
    private final int hdrPart;
    private final GridCacheSetHeaderKey setKey;
    private volatile boolean rmvd;
    private final IgniteCompute compute;

    public GridCacheSetImpl(GridCacheContext ctx, String name, GridCacheSetHeader hdr) {
        this.ctx = ctx;
        this.name = name;
        this.collocated = hdr.collocated();
        this.id = hdr.id();
        this.compute = ctx.kernalContext().grid().compute();
        this.cache = ctx.cache();
        this.setKey = new GridCacheSetHeaderKey(name);
        this.log = ctx.logger(GridCacheSetImpl.class);
        this.hdrPart = ctx.affinity().partition(this.setKey);
        this.separated = hdr.separated();
    }

    @Override
    public boolean collocated() {
        return this.collocated;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean removed() {
        return this.rmvd;
    }

    boolean checkHeader() throws IgniteCheckedException {
        GridCacheAdapter cache0 = this.ctx.cache();
        GridCacheSetHeader hdr = (GridCacheSetHeader)cache0.get(new GridCacheSetHeaderKey(this.name));
        return hdr != null && hdr.id().equals(this.id);
    }

    @Override
    public int size() {
        try {
            Integer val;
            this.onAccess();
            if (this.separated) {
                return this.cache.sizeAsync(new CachePeekMode[0]).get() - 1;
            }
            GridCacheQueryAdapter<Object> qry = new GridCacheQueryAdapter<Object>(this.ctx, GridCacheQueryType.SET, null, null, new GridSetQueryPredicate<Object, Object>(this.id, this.collocated), this.collocated ? Integer.valueOf(this.hdrPart) : null, false, false);
            Collection<ClusterNode> nodes = this.dataNodes(this.ctx.affinity().affinityTopologyVersion());
            qry.projection(this.ctx.grid().cluster().forNodes(nodes));
            CacheQueryFuture<Integer> qryFut = qry.execute(new SumReducer(), new Object[0]);
            int sum = 0;
            while ((val = qryFut.next()) != null) {
                sum += val.intValue();
            }
            return sum;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        this.onAccess();
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        this.onAccess();
        final SetItemKey key = this.itemKey(o);
        return this.retry(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return GridCacheSetImpl.this.cache.get(key) != null;
            }
        });
    }

    @Override
    public boolean add(T o) {
        this.onAccess();
        final SetItemKey key = this.itemKey(o);
        return this.retry(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return GridCacheSetImpl.this.cache.putIfAbsent(key, true);
            }
        });
    }

    @Override
    public boolean remove(Object o) {
        this.onAccess();
        final SetItemKey key = this.itemKey(o);
        return this.retry(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return GridCacheSetImpl.this.cache.remove(key);
            }
        });
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.onAccess();
        boolean add = false;
        HashMap<SetItemKey, Boolean> addKeys = null;
        for (T obj : c) {
            if (add) {
                if (addKeys == null) {
                    addKeys = U.newHashMap(100);
                }
                addKeys.put(this.itemKey(obj), true);
                if (addKeys.size() != 100) continue;
                this.retryPutAll(addKeys);
                addKeys.clear();
                continue;
            }
            add = this.add(obj);
        }
        if (!F.isEmpty(addKeys)) {
            this.retryPutAll(addKeys);
        }
        return add;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.onAccess();
        boolean rmv = false;
        HashSet<SetItemKey> rmvKeys = null;
        for (Object obj : c) {
            if (rmv) {
                if (rmvKeys == null) {
                    rmvKeys = U.newHashSet(100);
                }
                rmvKeys.add(this.itemKey(obj));
                if (rmvKeys.size() != 100) continue;
                this.retryRemoveAll(rmvKeys);
                rmvKeys.clear();
                continue;
            }
            rmv = this.remove(obj);
        }
        if (!F.isEmpty(rmvKeys)) {
            this.retryRemoveAll(rmvKeys);
        }
        return rmv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        try {
            this.onAccess();
            try (GridCloseableIterator<T> iter = this.iterator0();){
                boolean rmv = false;
                HashSet<SetItemKey> rmvKeys = null;
                for (Object val : iter) {
                    if (c.contains(val)) continue;
                    rmv = true;
                    if (rmvKeys == null) {
                        rmvKeys = U.newHashSet(100);
                    }
                    rmvKeys.add(this.itemKey(val));
                    if (rmvKeys.size() != 100) continue;
                    this.retryRemoveAll(rmvKeys);
                    rmvKeys.clear();
                }
                if (!F.isEmpty(rmvKeys)) {
                    this.retryRemoveAll(rmvKeys);
                }
                boolean bl = rmv;
                return bl;
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.onAccess();
            try (GridCloseableIterator<T> iter = this.iterator0();){
                ArrayList<SetItemKey> rmvKeys = new ArrayList<SetItemKey>(100);
                for (Object val : iter) {
                    rmvKeys.add(this.itemKey(val));
                    if (rmvKeys.size() != 100) continue;
                    this.retryRemoveAll(rmvKeys);
                    rmvKeys.clear();
                }
                if (!rmvKeys.isEmpty()) {
                    this.retryRemoveAll(rmvKeys);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.onAccess();
        return this.iterator0();
    }

    @Override
    public void affinityRun(IgniteRunnable job) {
        if (!this.collocated) {
            throw new IgniteException("Failed to execute affinityRun() for non-collocated set: " + this.name() + ". This operation is supported only for collocated sets.");
        }
        this.compute.affinityRun(this.cache.name(), (Object)this.setKey, job);
    }

    @Override
    public <R> R affinityCall(IgniteCallable<R> job) {
        if (!this.collocated) {
            throw new IgniteException("Failed to execute affinityCall() for non-collocated set: " + this.name() + ". This operation is supported only for collocated sets.");
        }
        return this.compute.affinityCall(this.cache.name(), (Object)this.setKey, job);
    }

    @Override
    public void close() {
        try {
            if (this.rmvd) {
                return;
            }
            this.ctx.kernalContext().dataStructures().removeSet(this.name, this.ctx);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private GridCloseableIterator<T> iterator0() {
        try {
            CacheWeakQueryIteratorsHolder.WeakReferenceCloseableIterator<T> it;
            CacheWeakQueryIteratorsHolder.WeakReferenceCloseableIterator<T> weakReferenceCloseableIterator = it = this.separated ? this.separatedCacheIterator() : this.sharedCacheIterator();
            if (this.rmvd) {
                this.ctx.itHolder().removeIterator(it);
                this.checkRemoved();
            }
            return it;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private CacheWeakQueryIteratorsHolder.WeakReferenceCloseableIterator<T> sharedCacheIterator() throws IgniteCheckedException {
        GridCacheQueryAdapter qry = new GridCacheQueryAdapter(this.ctx, GridCacheQueryType.SET, null, null, new GridSetQueryPredicate<Object, Object>(this.id, this.collocated), this.collocated ? Integer.valueOf(this.hdrPart) : null, false, false);
        Collection<ClusterNode> nodes = this.dataNodes(this.ctx.affinity().affinityTopologyVersion());
        qry.projection(this.ctx.grid().cluster().forNodes(nodes));
        CacheQueryFuture fut = qry.execute(new Object[0]);
        return this.ctx.itHolder().iterator(fut, new CacheIteratorConverter<T, Map.Entry<T, ?>>(){

            @Override
            protected T convert(Map.Entry<T, ?> e) {
                return e.getKey();
            }

            @Override
            protected void remove(T item) {
                GridCacheSetImpl.this.remove(item);
            }
        });
    }

    private CacheWeakQueryIteratorsHolder.WeakReferenceCloseableIterator<T> separatedCacheIterator() throws IgniteCheckedException {
        GridCloseableIterator iter = (GridCloseableIterator)this.cache.scanIterator(false, new IgniteBiPredicate<Object, Object>(){

            @Override
            public boolean apply(Object k, Object v) {
                return k.getClass() == GridCacheSetItemKey.class;
            }
        });
        return this.ctx.itHolder().iterator(iter, new CacheIteratorConverter<T, Map.Entry<T, ?>>(){

            @Override
            protected T convert(Map.Entry<T, ?> e) {
                return ((SetItemKey)e.getKey()).item();
            }

            @Override
            protected void remove(T item) {
                GridCacheSetImpl.this.remove(item);
            }
        });
    }

    private <R> R retry(Callable<R> call) {
        try {
            return DataStructuresProcessor.retry(this.log, call);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private void retryRemoveAll(final Collection<SetItemKey> keys) {
        this.retry(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridCacheSetImpl.this.cache.removeAll(keys);
                return null;
            }
        });
    }

    private void retryPutAll(final Map<SetItemKey, Boolean> keys) {
        this.retry(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GridCacheSetImpl.this.cache.putAll(keys);
                return null;
            }
        });
    }

    private Collection<ClusterNode> dataNodes(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        List<ClusterNode> nodes0;
        if (this.ctx.isLocal() || this.ctx.isReplicated()) {
            return Collections.singleton(this.ctx.localNode());
        }
        Collection<ClusterNode> nodes = this.collocated ? (!(nodes0 = this.ctx.affinity().nodesByPartition(this.hdrPart, topVer)).isEmpty() ? Collections.singleton(nodes0.contains(this.ctx.localNode()) ? this.ctx.localNode() : F.first(nodes0)) : nodes0) : CU.affinityNodes(this.ctx, topVer);
        if (nodes.isEmpty()) {
            throw new IgniteCheckedException("Failed to get set data, all cache nodes left grid.");
        }
        return nodes;
    }

    void removed(boolean rmvd) {
        if (this.rmvd) {
            return;
        }
        this.rmvd = rmvd;
        if (rmvd) {
            this.ctx.itHolder().clearQueries();
        }
    }

    private void checkRemoved() {
        if (this.rmvd) {
            throw new IllegalStateException("Set has been removed: " + this);
        }
    }

    private void onAccess() {
        this.ctx.itHolder().checkWeakQueue();
        this.checkRemoved();
    }

    public IgniteUuid id() {
        return this.id;
    }

    GridCacheContext context() {
        return this.ctx;
    }

    boolean separated() {
        return this.separated;
    }

    private SetItemKey itemKey(Object item) {
        return this.collocated ? new CollocatedSetItemKey(this.name, this.id, item) : new GridCacheSetItemKey(this.separated ? null : this.id, item);
    }

    @Override
    public String toString() {
        return S.toString(GridCacheSetImpl.class, this);
    }

    private static class SumReducer
    implements IgniteReducer<Object, Integer>,
    Externalizable {
        private static final long serialVersionUID = -3436987759126521204L;
        private int cntr;

        @Override
        public boolean collect(@Nullable Object o) {
            ++this.cntr;
            return true;
        }

        @Override
        public Integer reduce() {
            return this.cntr;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

