/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class JdbcResponse
extends ClientListenerResponse
implements JdbcRawBinarylizable {
    @GridToStringInclude
    private JdbcResult res;

    public JdbcResponse() {
        super(-1, null);
    }

    public JdbcResponse(JdbcResult res) {
        super(0, null);
        this.res = res;
    }

    public JdbcResponse(int status, @Nullable String err) {
        super(status, err);
        assert (status != 0);
    }

    public JdbcResult response() {
        return this.res;
    }

    public String toString() {
        return S.toString(JdbcResponse.class, this, "status", this.status(), "err", this.error());
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        writer.writeInt(this.status());
        if (this.status() == 0) {
            writer.writeBoolean(this.res != null);
            if (this.res != null) {
                this.res.writeBinary(writer, ver);
            }
        } else {
            writer.writeString(this.error());
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        this.status(reader.readInt());
        if (this.status() == 0) {
            if (reader.readBoolean()) {
                this.res = JdbcResult.readResult(reader, ver);
            }
        } else {
            this.error(reader.readString());
        }
    }
}

