/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.security.SecurityPermission;

public class SecurityUtils {
    public static final IgniteProductVersion SERVICE_PERMISSIONS_SINCE = IgniteProductVersion.fromString("1.7.11");
    private static final int DFLT_SERIALIZE_VERSION = SecurityUtils.isSecurityCompatibilityMode() ? 1 : 2;
    private static final ThreadLocal<Integer> SERIALIZE_VERSION = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return DFLT_SERIALIZE_VERSION;
        }
    };

    private SecurityUtils() {
    }

    public static boolean isSecurityCompatibilityMode() {
        return IgniteSystemProperties.getBoolean("IGNITE_SECURITY_COMPATIBILITY_MODE", false);
    }

    public static void serializeVersion(int ver) {
        SERIALIZE_VERSION.set(ver);
    }

    public static int serializeVersion() {
        return SERIALIZE_VERSION.get();
    }

    public static void restoreDefaultSerializeVersion() {
        SecurityUtils.serializeVersion(DFLT_SERIALIZE_VERSION);
    }

    public static Map<String, Collection<SecurityPermission>> compatibleServicePermissions() {
        HashMap<String, Collection<SecurityPermission>> srvcPerms = new HashMap<String, Collection<SecurityPermission>>();
        srvcPerms.put("*", Arrays.asList(SecurityPermission.SERVICE_CANCEL, SecurityPermission.SERVICE_DEPLOY, SecurityPermission.SERVICE_INVOKE));
        return srvcPerms;
    }
}

