/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.GridNioBackPressureControl;
import org.apache.ignite.internal.util.nio.GridNioFilterChain;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioKeyAttachment;
import org.apache.ignite.internal.util.nio.GridNioRecoveryDescriptor;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioSessionImpl;
import org.apache.ignite.internal.util.nio.GridNioWorker;
import org.apache.ignite.internal.util.nio.SessionWriteRequest;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.util.deque.FastSizeDeque;
import org.jetbrains.annotations.Nullable;

class GridSelectorNioSessionImpl
extends GridNioSessionImpl
implements GridNioKeyAttachment {
    private final FastSizeDeque<SessionWriteRequest> queue = new FastSizeDeque(new ConcurrentLinkedDeque());
    @GridToStringExclude
    private SelectionKey key;
    private volatile GridNioWorker worker;
    @GridToStringExclude
    private final Semaphore sem;
    private ByteBuffer writeBuf;
    private ByteBuffer readBuf;
    private GridNioRecoveryDescriptor inRecovery;
    private GridNioRecoveryDescriptor outRecovery;
    private final IgniteLogger log;
    private List<GridNioServer.SessionChangeRequest> pendingStateChanges;
    final AtomicBoolean procWrite = new AtomicBoolean();
    private Object sysMsg;

    GridSelectorNioSessionImpl(IgniteLogger log, GridNioWorker worker, GridNioFilterChain filterChain, InetSocketAddress locAddr, InetSocketAddress rmtAddr, boolean accepted, int sndQueueLimit, @Nullable ByteBuffer writeBuf, @Nullable ByteBuffer readBuf) {
        super(filterChain, locAddr, rmtAddr, accepted);
        assert (worker != null);
        assert (sndQueueLimit >= 0);
        assert (locAddr != null) : "GridSelectorNioSessionImpl should have local socket address.";
        assert (rmtAddr != null) : "GridSelectorNioSessionImpl should have remote socket address.";
        assert (log != null);
        this.log = log;
        this.worker = worker;
        Semaphore semaphore = this.sem = sndQueueLimit > 0 ? new Semaphore(sndQueueLimit) : null;
        if (writeBuf != null) {
            writeBuf.clear();
            this.writeBuf = writeBuf;
        }
        if (readBuf != null) {
            readBuf.clear();
            this.readBuf = readBuf;
        }
    }

    @Override
    public boolean hasSession() {
        return true;
    }

    @Override
    @Nullable
    public GridSelectorNioSessionImpl session() {
        return this;
    }

    GridNioWorker worker() {
        return this.worker;
    }

    void key(SelectionKey key) {
        assert (key != null);
        this.key = key;
    }

    public ByteBuffer writeBuffer() {
        return this.writeBuf;
    }

    public ByteBuffer readBuffer() {
        return this.readBuf;
    }

    SelectionKey key() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean offerMove(GridNioWorker from, GridNioServer.SessionChangeRequest fut) {
        GridSelectorNioSessionImpl gridSelectorNioSessionImpl = this;
        synchronized (gridSelectorNioSessionImpl) {
            GridNioWorker worker0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Offered move [ses=" + this + ", fut=" + fut + ']');
            }
            if ((worker0 = this.worker) != from) {
                return false;
            }
            this.worker.offer(fut);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void offerStateChange(GridNioServer.SessionChangeRequest fut) {
        GridSelectorNioSessionImpl gridSelectorNioSessionImpl = this;
        synchronized (gridSelectorNioSessionImpl) {
            GridNioWorker worker0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Offered move [ses=" + this + ", fut=" + fut + ']');
            }
            if ((worker0 = this.worker) == null) {
                if (this.pendingStateChanges == null) {
                    this.pendingStateChanges = new ArrayList<GridNioServer.SessionChangeRequest>();
                }
                this.pendingStateChanges.add(fut);
            } else {
                worker0.offer(fut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMoveSession(GridNioWorker moveFrom) {
        GridSelectorNioSessionImpl gridSelectorNioSessionImpl = this;
        synchronized (gridSelectorNioSessionImpl) {
            assert (this.worker == moveFrom);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Started moving [ses=" + this + ", from=" + moveFrom + ']');
            }
            List<GridNioServer.SessionChangeRequest> sesReqs = moveFrom.clearSessionRequests(this);
            this.worker = null;
            if (sesReqs != null) {
                if (this.pendingStateChanges == null) {
                    this.pendingStateChanges = new ArrayList<GridNioServer.SessionChangeRequest>();
                }
                this.pendingStateChanges.addAll(sesReqs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishMoveSession(GridNioWorker moveTo) {
        GridSelectorNioSessionImpl gridSelectorNioSessionImpl = this;
        synchronized (gridSelectorNioSessionImpl) {
            assert (this.worker == null);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finishing moving [ses=" + this + ", to=" + moveTo + ']');
            }
            this.worker = moveTo;
            if (this.pendingStateChanges != null) {
                moveTo.offer(this.pendingStateChanges);
                this.pendingStateChanges = null;
            }
        }
    }

    int offerSystemFuture(SessionWriteRequest writeFut) {
        writeFut.messageThread(true);
        boolean res = this.queue.offerFirst(writeFut);
        assert (res) : "Future was not added to queue";
        return this.queue.sizex();
    }

    int offerFuture(SessionWriteRequest writeFut) {
        boolean msgThread = GridNioBackPressureControl.threadProcessingMessage();
        if (this.sem != null && !msgThread) {
            this.sem.acquireUninterruptibly();
        }
        writeFut.messageThread(msgThread);
        boolean res = this.queue.offer(writeFut);
        assert (res) : "Future was not added to queue";
        return this.queue.sizex();
    }

    void resend(Collection<SessionWriteRequest> futs) {
        assert (this.queue.isEmpty()) : this.queue.size();
        boolean add = this.queue.addAll(futs);
        assert (add);
    }

    @Nullable
    SessionWriteRequest pollFuture() {
        SessionWriteRequest last = this.queue.poll();
        if (last != null) {
            if (this.sem != null && !last.messageThread()) {
                this.sem.release();
            }
            if (this.outRecovery != null && !this.outRecovery.add(last)) {
                LT.warn(this.log, "Unacknowledged messages queue size overflow, will attempt to reconnect [remoteAddr=" + this.remoteAddress() + ", queueLimit=" + this.outRecovery.queueLimit() + ']');
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unacknowledged messages queue size overflow, will attempt to reconnect [remoteAddr=" + this.remoteAddress() + ", queueSize=" + this.outRecovery.messagesRequests().size() + ", queueLimit=" + this.outRecovery.queueLimit() + ']');
                }
                this.close();
            }
        }
        return last;
    }

    boolean removeFuture(SessionWriteRequest fut) {
        assert (this.closed());
        return this.queue.removeLastOccurrence(fut);
    }

    int writeQueueSize() {
        return this.queue.sizex();
    }

    Collection<SessionWriteRequest> writeQueue() {
        return this.queue;
    }

    @Override
    public void outRecoveryDescriptor(GridNioRecoveryDescriptor recoveryDesc) {
        assert (recoveryDesc != null);
        this.outRecovery = recoveryDesc;
        this.outRecovery.session(this);
    }

    @Override
    @Nullable
    public GridNioRecoveryDescriptor outRecoveryDescriptor() {
        return this.outRecovery;
    }

    @Override
    public void inRecoveryDescriptor(GridNioRecoveryDescriptor recoveryDesc) {
        assert (recoveryDesc != null);
        this.inRecovery = recoveryDesc;
    }

    @Override
    @Nullable
    public GridNioRecoveryDescriptor inRecoveryDescriptor() {
        return this.inRecovery;
    }

    void onServerStopped() {
        this.onClosed();
    }

    void onClosed() {
        if (this.sem != null) {
            this.sem.release(1000000);
        }
    }

    @Override
    public void systemMessage(Object sysMsg) {
        this.sysMsg = sysMsg;
    }

    boolean hasSystemMessage() {
        return this.sysMsg != null;
    }

    Object systemMessage() {
        Object ret = this.sysMsg;
        this.sysMsg = null;
        return ret;
    }

    @Override
    public GridNioFuture<Boolean> close() {
        GridNioFuture<Boolean> fut = super.close();
        if (!fut.isDone()) {
            fut.listen(fut0 -> {
                try {
                    fut0.get();
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Failed to close session [ses=" + this + ']', e);
                }
            });
        } else if (fut.error() != null) {
            this.log.error("Failed to close session [ses=" + this + ']', fut.error());
        }
        return fut;
    }

    @Override
    public String toString() {
        return S.toString(GridSelectorNioSessionImpl.class, this, super.toString());
    }
}

