/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.igfs.VisorIgfsMetrics;

public class VisorIgfs
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private IgfsMode mode;
    private VisorIgfsMetrics metrics;
    private boolean secondaryFsConfigured;

    public VisorIgfs() {
    }

    public VisorIgfs(String name, IgfsMode mode, VisorIgfsMetrics metrics, boolean secondaryFsConfigured) {
        this.name = name;
        this.mode = mode;
        this.metrics = metrics;
        this.secondaryFsConfigured = secondaryFsConfigured;
    }

    public VisorIgfs(IgniteFileSystem igfs) {
        assert (igfs != null);
        this.name = igfs.name();
        this.mode = igfs.configuration().getDefaultMode();
        this.metrics = new VisorIgfsMetrics(igfs);
        this.secondaryFsConfigured = igfs.configuration().getSecondaryFileSystem() != null;
    }

    public String getName() {
        return this.name;
    }

    public IgfsMode getMode() {
        return this.mode;
    }

    public VisorIgfsMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isSecondaryFileSystemConfigured() {
        return this.secondaryFsConfigured;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeEnum(out, this.mode);
        out.writeObject(this.metrics);
        out.writeBoolean(this.secondaryFsConfigured);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.mode = IgfsMode.fromOrdinal(in.readByte());
        this.metrics = (VisorIgfsMetrics)in.readObject();
        this.secondaryFsConfigured = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorIgfs.class, this);
    }
}

