/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorEither;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryCursor;
import org.apache.ignite.internal.visor.query.VisorQueryField;
import org.apache.ignite.internal.visor.query.VisorQueryResult;
import org.apache.ignite.internal.visor.query.VisorQueryTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;

@GridInternal
public class VisorQueryTask
extends VisorOneNodeTask<VisorQueryTaskArg, VisorEither<VisorQueryResult>> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryJob job(VisorQueryTaskArg arg) {
        return new VisorQueryJob(arg, this.debug);
    }

    private static class VisorQueryJob
    extends VisorJob<VisorQueryTaskArg, VisorEither<VisorQueryResult>> {
        private static final long serialVersionUID = 0L;

        private VisorQueryJob(VisorQueryTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorEither<VisorQueryResult> run(VisorQueryTaskArg arg) {
            try {
                List<FieldsQueryCursor<List<?>>> qryCursors;
                UUID nid = this.ignite.localNode().id();
                SqlFieldsQuery qry = new SqlFieldsQuery(arg.getQueryText());
                qry.setPageSize(arg.getPageSize());
                qry.setLocal(arg.isLocal());
                qry.setDistributedJoins(arg.isDistributedJoins());
                qry.setCollocated(arg.isCollocated());
                qry.setEnforceJoinOrder(arg.isEnforceJoinOrder());
                qry.setReplicatedOnly(arg.isReplicatedOnly());
                qry.setLazy(arg.getLazy());
                long start = U.currentTimeMillis();
                String cacheName = arg.getCacheName();
                if (F.isEmpty(cacheName)) {
                    qryCursors = this.ignite.context().query().querySqlFields(qry, true, false);
                } else {
                    IgniteCache c = this.ignite.cache(cacheName);
                    if (c == null) {
                        throw new SQLException("Fail to execute query. Cache not found: " + cacheName);
                    }
                    qryCursors = ((IgniteCacheProxy)c.withKeepBinary()).queryMultipleStatements(qry);
                }
                for (int i = 0; i < qryCursors.size() - 1; ++i) {
                    U.closeQuiet(qryCursors.get(i));
                }
                VisorQueryCursor cur = new VisorQueryCursor(F.last(qryCursors));
                Collection<GridQueryFieldMetadata> meta = cur.fieldsMeta();
                if (meta == null) {
                    return new VisorEither<VisorExceptionWrapper>(new VisorExceptionWrapper(new SQLException("Fail to execute query. No metadata available.")));
                }
                ArrayList<VisorQueryField> names = new ArrayList<VisorQueryField>(meta.size());
                for (GridQueryFieldMetadata col : meta) {
                    names.add(new VisorQueryField(col.schemaName(), col.typeName(), col.fieldName(), col.fieldTypeName()));
                }
                List<Object[]> rows = VisorQueryUtils.fetchSqlQueryRows(cur, arg.getPageSize());
                long duration = U.currentTimeMillis() - start;
                boolean hasNext = cur.hasNext();
                String qryId = "VISOR_SQL_QUERY-" + UUID.randomUUID();
                if (hasNext) {
                    this.ignite.cluster().nodeLocalMap().put(qryId, cur);
                    VisorQueryUtils.scheduleResultSetHolderRemoval(qryId, this.ignite);
                } else {
                    cur.close();
                }
                return new VisorEither<VisorQueryResult>(new VisorQueryResult(nid, qryId, names, rows, hasNext, duration));
            }
            catch (Throwable e) {
                return new VisorEither<VisorExceptionWrapper>(new VisorExceptionWrapper(e));
            }
        }

        public String toString() {
            return S.toString(VisorQueryJob.class, this);
        }
    }
}

