/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

@MXBeanDescription(value="MBean that provides access to aggregated cluster metrics.")
public interface ClusterMetricsMXBean
extends ClusterMetrics {
    @Override
    @MXBeanDescription(value="Last update time of this node metrics.")
    public long getLastUpdateTime();

    @Override
    @MXBeanDescription(value="Maximum number of jobs that ever ran concurrently on this node.")
    public int getMaximumActiveJobs();

    @Override
    @MXBeanDescription(value="Number of currently active jobs concurrently executing on the node.")
    public int getCurrentActiveJobs();

    @Override
    @MXBeanDescription(value="Average number of active jobs concurrently executing on the node.")
    public float getAverageActiveJobs();

    @Override
    @MXBeanDescription(value="Maximum number of waiting jobs this node had.")
    public int getMaximumWaitingJobs();

    @Override
    @MXBeanDescription(value="Number of queued jobs currently waiting to be executed.")
    public int getCurrentWaitingJobs();

    @Override
    @MXBeanDescription(value="Average number of waiting jobs this node had queued.")
    public float getAverageWaitingJobs();

    @Override
    @MXBeanDescription(value="Maximum number of jobs rejected at once during a single collision resolution operation.")
    public int getMaximumRejectedJobs();

    @Override
    @MXBeanDescription(value="Number of jobs rejected after more recent collision resolution operation.")
    public int getCurrentRejectedJobs();

    @Override
    @MXBeanDescription(value="Average number of jobs this node rejects during collision resolution operations.")
    public float getAverageRejectedJobs();

    @Override
    @MXBeanDescription(value="Total number of jobs this node rejects during collision resolution operations since node startup.")
    public int getTotalRejectedJobs();

    @Override
    @MXBeanDescription(value="Maximum number of cancelled jobs this node ever had running concurrently.")
    public int getMaximumCancelledJobs();

    @Override
    @MXBeanDescription(value="Number of cancelled jobs that are still running.")
    public int getCurrentCancelledJobs();

    @Override
    @MXBeanDescription(value="Average number of cancelled jobs this node ever had running concurrently.")
    public float getAverageCancelledJobs();

    @Override
    @MXBeanDescription(value="Total number of cancelled jobs since node startup.")
    public int getTotalCancelledJobs();

    @Override
    @MXBeanDescription(value="Total number of jobs handled by the node.")
    public int getTotalExecutedJobs();

    @Override
    @MXBeanDescription(value="Total time all finished jobs takes to execute on the node.")
    public long getTotalJobsExecutionTime();

    @Override
    @MXBeanDescription(value="Maximum time a job ever spent waiting in a queue to be executed.")
    public long getMaximumJobWaitTime();

    @Override
    @MXBeanDescription(value="Current wait time of oldest job.")
    public long getCurrentJobWaitTime();

    @Override
    @MXBeanDescription(value="Average time jobs spend waiting in the queue to be executed.")
    public double getAverageJobWaitTime();

    @Override
    @MXBeanDescription(value="Time it took to execute the longest job on the node.")
    public long getMaximumJobExecuteTime();

    @Override
    @MXBeanDescription(value="Longest time a current job has been executing for.")
    public long getCurrentJobExecuteTime();

    @Override
    @MXBeanDescription(value="Average time a job takes to execute on the node.")
    public double getAverageJobExecuteTime();

    @Override
    @MXBeanDescription(value="Total number of tasks handled by the node.")
    public int getTotalExecutedTasks();

    @Override
    @MXBeanDescription(value="Total time this node spent executing jobs.")
    public long getTotalBusyTime();

    @Override
    @MXBeanDescription(value="Total time this node spent idling (not executing any jobs).")
    public long getTotalIdleTime();

    @Override
    @MXBeanDescription(value="Time this node spend idling since executing last job.")
    public long getCurrentIdleTime();

    @Override
    @MXBeanDescription(value="Percentage of time this node is busy executing jobs vs. idling.")
    public float getBusyTimePercentage();

    @Override
    @MXBeanDescription(value="Percentage of time this node is idling vs. executing jobs.")
    public float getIdleTimePercentage();

    @Override
    @MXBeanDescription(value="The number of CPUs available to the Java Virtual Machine.")
    public int getTotalCpus();

    @Override
    @MXBeanDescription(value="The system load average; or a negative value if not available.")
    public double getCurrentCpuLoad();

    @Override
    @MXBeanDescription(value="Average of CPU load values over all metrics kept in the history.")
    public double getAverageCpuLoad();

    @Override
    @MXBeanDescription(value="Average time spent in GC since the last update.")
    public double getCurrentGcCpuLoad();

    @Override
    @MXBeanDescription(value="The initial size of memory in bytes; -1 if undefined.")
    public long getHeapMemoryInitialized();

    @Override
    @MXBeanDescription(value="Current heap size that is used for object allocation.")
    public long getHeapMemoryUsed();

    @Override
    @MXBeanDescription(value="The amount of committed memory in bytes.")
    public long getHeapMemoryCommitted();

    @Override
    @MXBeanDescription(value="The maximum amount of memory in bytes; -1 if undefined.")
    public long getHeapMemoryMaximum();

    @Override
    @MXBeanDescription(value="The total amount of memory in bytes; -1 if undefined.")
    public long getHeapMemoryTotal();

    @Override
    @MXBeanDescription(value="The initial size of memory in bytes; -1 if undefined.")
    public long getNonHeapMemoryInitialized();

    @Override
    @MXBeanDescription(value="Current non-heap memory size that is used by Java VM.")
    public long getNonHeapMemoryUsed();

    @Override
    @MXBeanDescription(value="Amount of non-heap memory in bytes that is committed for the JVM to use.")
    public long getNonHeapMemoryCommitted();

    @Override
    @MXBeanDescription(value="Maximum amount of non-heap memory in bytes that can be used for memory management. -1 if undefined.")
    public long getNonHeapMemoryMaximum();

    @Override
    @MXBeanDescription(value="Total amount of non-heap memory in bytes that can be used for memory management. -1 if undefined.")
    public long getNonHeapMemoryTotal();

    @Override
    @MXBeanDescription(value="Uptime of the JVM in milliseconds.")
    public long getUpTime();

    @Override
    @MXBeanDescription(value="Start time of the JVM in milliseconds.")
    public long getStartTime();

    @Override
    @MXBeanDescription(value="Current number of live threads.")
    public int getCurrentThreadCount();

    @Override
    @MXBeanDescription(value="The peak live thread count.")
    public int getMaximumThreadCount();

    @Override
    @MXBeanDescription(value="The total number of threads started.")
    public long getTotalStartedThreadCount();

    @Override
    @MXBeanDescription(value="Current number of live daemon threads.")
    public int getCurrentDaemonThreadCount();

    @Override
    @MXBeanDescription(value="Last data version.")
    public long getLastDataVersion();

    @Override
    @MXBeanDescription(value="Sent messages count.")
    public int getSentMessagesCount();

    @Override
    @MXBeanDescription(value="Sent bytes count.")
    public long getSentBytesCount();

    @Override
    @MXBeanDescription(value="Received messages count.")
    public int getReceivedMessagesCount();

    @Override
    @MXBeanDescription(value="Received bytes count.")
    public long getReceivedBytesCount();

    @Override
    @MXBeanDescription(value="Outbound messages queue size.")
    public int getOutboundMessagesQueueSize();

    @Override
    @MXBeanDescription(value="Start time of the grid node in milliseconds.")
    public long getNodeStartTime();

    @Override
    @MXBeanDescription(value="Total number of nodes.")
    public int getTotalNodes();

    @MXBeanDescription(value="Total baseline nodes count.")
    public int getTotalBaselineNodes();

    @MXBeanDescription(value="Active baseline nodes count.")
    public int getActiveBaselineNodes();

    @MXBeanDescription(value="Server nodes count.")
    public int getTotalServerNodes();

    @MXBeanDescription(value="Client nodes count.")
    public int getTotalClientNodes();

    @MXBeanDescription(value="Current topology version.")
    public long getTopologyVersion();

    @MXBeanDescription(value="Distinct attribute names for given nodes projection.")
    public Set<String> attributeNames();

    @MXBeanDescription(value="Distinct attribute values for given nodes projection.")
    @MXBeanParametersNames(value={"attrName"})
    @MXBeanParametersDescriptions(value={"Attribute name."})
    public Set<String> attributeValues(String var1);

    @MXBeanDescription(value="Get node IDs with the given attribute value.")
    @MXBeanParametersNames(value={"attrName", "attrValue", "includeSrvs", "includeClients"})
    @MXBeanParametersDescriptions(value={"Attribute name.", "Attribute value.", "Include server nodes.", "Include client nodes."})
    public Set<UUID> nodeIdsForAttribute(String var1, String var2, boolean var3, boolean var4);
}

