/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Cursor;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeFilterClosure;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class H2TreeIndex
extends GridH2IndexBase {
    public static final int IGNITE_MAX_INDEX_PAYLOAD_SIZE_DEFAULT = 10;
    private final H2Tree[] segments;
    private final List<InlineIndexHelper> inlineIdxs;
    private final GridCacheContext<?, ?> cctx;
    private final String tblName;
    private final boolean pk;
    private final boolean affinityKey;
    private final String idxName;
    private final IgniteLogger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H2TreeIndex(GridCacheContext<?, ?> cctx, @Nullable H2RowCache rowCache, GridH2Table tbl, String idxName, boolean pk, boolean affinityKey, List<IndexColumn> colsList, int inlineSize, int segmentsCnt) throws IgniteCheckedException {
        assert (segmentsCnt > 0) : segmentsCnt;
        this.cctx = cctx;
        this.log = cctx.logger(((Object)((Object)this)).getClass().getName());
        this.pk = pk;
        this.affinityKey = affinityKey;
        this.tblName = tbl.getName();
        this.idxName = idxName;
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        this.initBaseIndex((Table)tbl, 0, idxName, cols, pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
        GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
        int typeId = cctx.binaryMarshaller() ? typeDesc.typeId() : typeDesc.valueClass().hashCode();
        String treeName = (tbl.rowDescriptor() == null ? "" : typeId + "_") + idxName;
        treeName = BPlusTree.treeName((String)treeName, (String)"H2Tree");
        if (cctx.affinityNode()) {
            this.inlineIdxs = this.getAvailableInlineColumns(cols);
            this.segments = new H2Tree[segmentsCnt];
            IgniteCacheDatabaseSharedManager db = cctx.shared().database();
            AtomicInteger maxCalculatedInlineSize = new AtomicInteger();
            for (int i = 0; i < this.segments.length; ++i) {
                db.checkpointReadLock();
                try {
                    RootPage page = this.getMetaPage(treeName, i);
                    this.segments[i] = new H2Tree(treeName, idxName, this.tblName, tbl.cacheName(), cctx.offheap().reuseListForIndex(treeName), cctx.groupId(), cctx.dataRegion().pageMemory(), cctx.shared().wal(), (AtomicLong)cctx.offheap().globalRemoveId(), tbl.rowFactory(), page.pageId().pageId(), page.isAllocated(), cols, this.inlineIdxs, this.computeInlineSize(this.inlineIdxs, inlineSize), maxCalculatedInlineSize, pk, affinityKey, cctx.mvccEnabled(), rowCache, cctx.kernalContext().failure(), this.log){

                        @Override
                        public int compareValues(Value v1, Value v2) {
                            return v1 == v2 ? 0 : H2TreeIndex.this.table.compareTypeSafe(v1, v2);
                        }
                    };
                    continue;
                }
                finally {
                    db.checkpointReadUnlock();
                }
            }
        } else {
            this.segments = null;
            this.inlineIdxs = null;
        }
        this.initDistributedJoinMessaging(tbl);
    }

    private List<InlineIndexHelper> getAvailableInlineColumns(IndexColumn[] cols) {
        ArrayList<InlineIndexHelper> res = new ArrayList<InlineIndexHelper>();
        for (IndexColumn col : cols) {
            if (!InlineIndexHelper.AVAILABLE_TYPES.contains(col.column.getType())) {
                String idxType = this.pk ? "PRIMARY KEY" : (this.affinityKey ? "AFFINITY KEY (implicit)" : "SECONDARY");
                U.warn((IgniteLogger)this.log, (Object)("Column cannot be inlined into the index because it's type doesn't support inlining, index access may be slow due to additional page reads (change column type if possible) [cacheName=" + this.cctx.name() + ", tableName=" + this.tblName + ", idxName=" + this.idxName + ", idxType=" + idxType + ", colName=" + col.columnName + ", columnType=" + InlineIndexHelper.nameTypeBycode(col.column.getType()) + ']'));
                break;
            }
            InlineIndexHelper idx = new InlineIndexHelper(col.columnName, col.column.getType(), col.column.getColumnId(), col.sortType, this.table.getCompareMode());
            res.add(idx);
        }
        return res;
    }

    @Override
    protected int segmentsCount() {
        return this.segments.length;
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        try {
            assert (lower == null || lower instanceof GridH2SearchRow) : lower;
            assert (upper == null || upper instanceof GridH2SearchRow) : upper;
            int seg = this.threadLocalSegment();
            H2Tree tree = this.treeForRead(seg);
            if (!this.cctx.mvccEnabled() && this.indexType.isPrimaryKey() && lower != null && upper != null && tree.compareRows((GridH2SearchRow)lower, (GridH2SearchRow)upper) == 0) {
                GridH2Row row = (GridH2Row)tree.findOne((GridH2SearchRow)lower, this.filter(GridH2QueryContext.get()), null);
                return row == null ? GridH2Cursor.EMPTY : new SingleRowCursor((Row)row);
            }
            return new H2Cursor((GridCursor<GridH2Row>)tree.find((GridH2SearchRow)lower, (GridH2SearchRow)upper, this.filter(GridH2QueryContext.get()), null));
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    public GridH2Row put(GridH2Row row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow((SearchRow)row);
            H2Tree tree = this.treeForRead(seg);
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            GridH2Row gridH2Row = (GridH2Row)tree.put(row);
            return gridH2Row;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public boolean putx(GridH2Row row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow((SearchRow)row);
            H2Tree tree = this.treeForRead(seg);
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            boolean bl = tree.putx(row);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public GridH2Row remove(SearchRow row) {
        assert (row instanceof GridH2SearchRow) : row;
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            GridH2Row gridH2Row = (GridH2Row)tree.remove((GridH2SearchRow)row);
            return gridH2Row;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public boolean removex(SearchRow row) {
        try {
            assert (row instanceof GridH2SearchRow) : row;
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            boolean bl = tree.removex((GridH2SearchRow)row);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = this.getCostRangeIndex(masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public long getRowCount(Session ses) {
        try {
            int seg = this.threadLocalSegment();
            H2Tree tree = this.treeForRead(seg);
            GridH2QueryContext qctx = GridH2QueryContext.get();
            return tree.size(this.filter(qctx));
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public long getRowCountApproximation() {
        return 10000L;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean b) {
        try {
            H2Tree tree = this.treeForRead(this.threadLocalSegment());
            GridH2QueryContext qctx = GridH2QueryContext.get();
            return new SingleRowCursor(b ? (Row)tree.findFirst(this.filter(qctx)) : (Row)tree.findLast(this.filter(qctx)));
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    public void destroy(boolean rmvIndex) {
        try {
            if (this.cctx.affinityNode() && rmvIndex) {
                assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
                for (int i = 0; i < this.segments.length; ++i) {
                    H2Tree tree = this.segments[i];
                    tree.destroy();
                    this.dropMetaPage(tree.getName(), i);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        finally {
            super.destroy(rmvIndex);
        }
    }

    protected H2Tree treeForRead(int segment) {
        return this.segments[segment];
    }

    @Override
    protected H2Cursor doFind0(IgniteTree t, @Nullable SearchRow first, @Nullable SearchRow last, BPlusTree.TreeRowClosure<GridH2SearchRow, GridH2Row> filter) {
        try {
            GridCursor range = ((BPlusTree)t).find((Object)first, (Object)last, filter, null);
            if (range == null) {
                range = EMPTY_CURSOR;
            }
            return new H2Cursor((GridCursor<GridH2Row>)range);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    protected BPlusTree.TreeRowClosure<GridH2SearchRow, GridH2Row> filter(GridH2QueryContext qctx) {
        if (qctx == null) {
            assert (!this.cctx.mvccEnabled());
            return null;
        }
        IndexingQueryFilter f = qctx.filter();
        IndexingQueryCacheFilter p = f == null ? null : f.forCache(this.getTable().cacheName());
        MvccSnapshot v = qctx.mvccSnapshot();
        assert (!this.cctx.mvccEnabled() || v != null);
        if (p == null && v == null) {
            return null;
        }
        return new H2TreeFilterClosure(p, v, this.cctx, this.log);
    }

    private int computeInlineSize(List<InlineIndexHelper> inlineIdxs, int cfgInlineSize) {
        int propSize;
        int confSize = this.cctx.config().getSqlIndexMaxInlineSize();
        int n = propSize = confSize == -1 ? IgniteSystemProperties.getInteger((String)"IGNITE_MAX_INDEX_PAYLOAD_SIZE", (int)10) : confSize;
        if (cfgInlineSize == 0) {
            return 0;
        }
        if (F.isEmpty(inlineIdxs)) {
            return 0;
        }
        if (cfgInlineSize == -1) {
            if (propSize == 0) {
                return 0;
            }
            int size = 0;
            for (InlineIndexHelper idxHelper : inlineIdxs) {
                if (idxHelper.size() <= 0) {
                    size = propSize;
                    break;
                }
                size += idxHelper.size() + 1;
            }
            return Math.min(2048, size);
        }
        return Math.min(2048, cfgInlineSize);
    }

    private RootPage getMetaPage(String name, int segIdx) throws IgniteCheckedException {
        return this.cctx.offheap().rootPageForIndex(this.cctx.cacheId(), name + "%" + segIdx);
    }

    private void dropMetaPage(String name, int segIdx) throws IgniteCheckedException {
        this.cctx.offheap().dropRootPageForIndex(this.cctx.cacheId(), name + "%" + segIdx);
    }

    @Override
    public void refreshColumnIds() {
        super.refreshColumnIds();
        if (this.inlineIdxs == null) {
            return;
        }
        List<InlineIndexHelper> inlineHelpers = this.getAvailableInlineColumns(this.indexColumns);
        assert (this.inlineIdxs.size() == inlineHelpers.size());
        for (int pos = 0; pos < inlineHelpers.size(); ++pos) {
            this.inlineIdxs.set(pos, inlineHelpers.get(pos));
        }
    }
}

